/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.message;

import org.jboss.logging.Logger;
import org.jboss.messaging.core.message.Message;
import org.jboss.messaging.core.message.MessageHolder;
import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.plugin.contract.MessageStore;

public class SimpleMessageReference
implements MessageReference {
    private static final Logger log = Logger.getLogger(SimpleMessageReference.class);
    private boolean trace = log.isTraceEnabled();
    protected transient MessageStore ms;
    private MessageHolder holder;
    private long pagingOrder = -1L;
    private boolean released;
    private int deliveryCount;
    private long scheduledDeliveryTime;

    public SimpleMessageReference() {
        if (this.trace) {
            log.trace("Creating using default constructor");
        }
    }

    public SimpleMessageReference(SimpleMessageReference other) {
        this.ms = other.ms;
        this.holder = other.holder;
        this.pagingOrder = other.pagingOrder;
        this.released = other.released;
        this.deliveryCount = other.deliveryCount;
        this.scheduledDeliveryTime = other.scheduledDeliveryTime;
    }

    protected SimpleMessageReference(MessageHolder holder, MessageStore ms) {
        this.holder = holder;
        this.ms = ms;
    }

    public boolean isReference() {
        return true;
    }

    public int getDeliveryCount() {
        return this.deliveryCount;
    }

    public void setDeliveryCount(int deliveryCount) {
        this.deliveryCount = deliveryCount;
    }

    public long getScheduledDeliveryTime() {
        return this.scheduledDeliveryTime;
    }

    public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
        this.scheduledDeliveryTime = scheduledDeliveryTime;
    }

    public Message getMessage() {
        return this.holder.getMessage();
    }

    public void releaseMemoryReference() {
        if (this.released) {
            return;
        }
        this.holder.decrementInMemoryChannelCount();
        this.released = true;
    }

    public int getInMemoryChannelCount() {
        return this.holder.getInMemoryChannelCount();
    }

    public long getPagingOrder() {
        return this.pagingOrder;
    }

    public void setPagingOrder(long order) {
        this.pagingOrder = order;
    }

    public MessageReference copy() {
        SimpleMessageReference ref = new SimpleMessageReference(this);
        ref.holder.incrementInMemoryChannelCount();
        return ref;
    }

    public String toString() {
        return "Reference[" + this.getMessage().getMessageID() + "]:" + (this.getMessage().isReliable() ? "RELIABLE" : "NON-RELIABLE");
    }
}

