/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin;

import java.util.Collections;
import java.util.Set;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.transaction.TransactionManager;
import org.jboss.jms.selector.SelectorFactory;
import org.jboss.jms.server.JMSConditionFactory;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.util.ExceptionUtil;
import org.jboss.messaging.core.plugin.JDBCServiceSupport;
import org.jboss.messaging.core.plugin.contract.MessageStore;
import org.jboss.messaging.core.plugin.contract.MessagingComponent;
import org.jboss.messaging.core.plugin.contract.PersistenceManager;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRouterFactory;
import org.jboss.messaging.core.plugin.postoffice.cluster.DefaultClusteredPostOffice;
import org.jboss.messaging.core.plugin.postoffice.cluster.DefaultFailoverMapper;
import org.jboss.messaging.core.plugin.postoffice.cluster.MessagePullPolicy;
import org.jboss.messaging.core.plugin.postoffice.cluster.Peer;
import org.jboss.messaging.core.plugin.postoffice.cluster.jchannelfactory.JChannelFactory;
import org.jboss.messaging.core.plugin.postoffice.cluster.jchannelfactory.MultiplexerJChannelFactory;
import org.jboss.messaging.core.plugin.postoffice.cluster.jchannelfactory.XMLJChannelFactory;
import org.jboss.messaging.core.tx.TransactionRepository;
import org.w3c.dom.Element;

public class ClusteredPostOfficeService
extends JDBCServiceSupport
implements Peer {
    private boolean started;
    private Element syncChannelConfig;
    private Element asyncChannelConfig;
    private ObjectName channelFactoryName;
    private String syncChannelName;
    private String asyncChannelName;
    private String channelPartitionName;
    private ObjectName serverPeerObjectName;
    private String officeName;
    private long stateTimeout = 5000L;
    private long castTimeout = 5000L;
    private String groupName;
    private long statsSendPeriod = 1000L;
    private String clusterRouterFactory;
    private String messagePullPolicy;
    private int threadPoolSize = 50;
    private DefaultClusteredPostOffice postOffice;

    public MessagingComponent getInstance() {
        return this.postOffice;
    }

    public Set getNodeIDView() {
        if (this.postOffice == null) {
            return Collections.EMPTY_SET;
        }
        return this.postOffice.getNodeIDView();
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object object) throws IllegalArgumentException {
        this.postOffice.addNotificationListener(listener, filter, object);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.postOffice.removeNotificationListener(listener);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.postOffice.getNotificationInfo();
    }

    public synchronized ObjectName getServerPeer() {
        return this.serverPeerObjectName;
    }

    public synchronized void setServerPeer(ObjectName on) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.serverPeerObjectName = on;
    }

    public synchronized String getPostOfficeName() {
        return this.officeName;
    }

    public synchronized void setPostOfficeName(String name) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.officeName = name;
    }

    public ObjectName getChannelFactoryName() {
        return this.channelFactoryName;
    }

    public void setChannelFactoryName(ObjectName channelFactoryName) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.channelFactoryName = channelFactoryName;
    }

    public String getSyncChannelName() {
        return this.syncChannelName;
    }

    public void setSyncChannelName(String syncChannelName) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.syncChannelName = syncChannelName;
    }

    public String getAsyncChannelName() {
        return this.asyncChannelName;
    }

    public void setAsyncChannelName(String asyncChannelName) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.asyncChannelName = asyncChannelName;
    }

    public String getChannelPartitionName() {
        return this.channelPartitionName;
    }

    public void setChannelPartitionName(String channelPartitionName) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.channelPartitionName = channelPartitionName;
    }

    public void setSyncChannelConfig(Element config) throws Exception {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.syncChannelConfig = config;
    }

    public Element getSyncChannelConfig() {
        return this.syncChannelConfig;
    }

    public void setAsyncChannelConfig(Element config) throws Exception {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.asyncChannelConfig = config;
    }

    public Element getAsyncChannelConfig() {
        return this.asyncChannelConfig;
    }

    public void setStateTimeout(long timeout) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.stateTimeout = timeout;
    }

    public long getStateTimeout() {
        return this.stateTimeout;
    }

    public void setCastTimeout(long timeout) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.castTimeout = timeout;
    }

    public long getCastTimeout() {
        return this.castTimeout;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setStatsSendPeriod(long period) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.statsSendPeriod = period;
    }

    public long getStatsSendPeriod() {
        return this.statsSendPeriod;
    }

    public String getClusterRouterFactory() {
        return this.clusterRouterFactory;
    }

    public String getMessagePullPolicy() {
        return this.messagePullPolicy;
    }

    public void setClusterRouterFactory(String clusterRouterFactory) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.clusterRouterFactory = clusterRouterFactory;
    }

    public void setMessagePullPolicy(String messagePullPolicy) {
        this.messagePullPolicy = messagePullPolicy;
    }

    public String listBindings() {
        return this.postOffice.printBindingInformation();
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int size) {
        if (this.started) {
            this.log.warn("Cannot set attribute when service is started");
            return;
        }
        this.threadPoolSize = size;
    }

    protected synchronized void startService() throws Exception {
        if (this.started) {
            throw new IllegalStateException("Service is already started");
        }
        super.startService();
        try {
            TransactionManager tm = this.getTransactionManagerReference();
            ServerPeer serverPeer = (ServerPeer)this.server.getAttribute(this.serverPeerObjectName, "Instance");
            MessageStore ms = serverPeer.getMessageStore();
            TransactionRepository tr = serverPeer.getTxRepository();
            PersistenceManager pm = serverPeer.getPersistenceManagerInstance();
            int nodeId = serverPeer.getServerPeerID();
            Class<?> clazz = Class.forName(this.messagePullPolicy);
            MessagePullPolicy pullPolicy = (MessagePullPolicy)clazz.newInstance();
            clazz = Class.forName(this.clusterRouterFactory);
            ClusterRouterFactory rf = (ClusterRouterFactory)clazz.newInstance();
            JMSConditionFactory cf = new JMSConditionFactory();
            SelectorFactory ff = new SelectorFactory();
            DefaultFailoverMapper mapper = new DefaultFailoverMapper();
            JChannelFactory jChannelFactory = null;
            if (this.channelFactoryName != null) {
                MBeanInfo info = null;
                try {
                    info = this.server.getMBeanInfo(this.channelFactoryName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (info != null) {
                    this.log.debug(this + " uses MultiplexerJChannelFactory");
                    jChannelFactory = new MultiplexerJChannelFactory(this.server, this.channelFactoryName, this.channelPartitionName, this.syncChannelName, this.asyncChannelName);
                } else {
                    this.log.debug(this + " uses XMLJChannelFactory");
                    jChannelFactory = new XMLJChannelFactory(this.syncChannelConfig, this.asyncChannelConfig);
                }
            } else {
                this.log.debug(this + " uses XMLJChannelFactory");
                jChannelFactory = new XMLJChannelFactory(this.syncChannelConfig, this.asyncChannelConfig);
            }
            this.postOffice = new DefaultClusteredPostOffice(this.ds, tm, this.sqlProperties, this.createTablesOnStartup, nodeId, this.officeName, ms, pm, tr, ff, cf, this.groupName, jChannelFactory, this.stateTimeout, this.castTimeout, pullPolicy, rf, mapper, this.statsSendPeriod, this.threadPoolSize);
            this.postOffice.start();
            this.started = true;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }

    protected void stopService() throws Exception {
        if (!this.started) {
            throw new IllegalStateException("Service is not started");
        }
        super.stopService();
        try {
            this.postOffice.stop();
            this.postOffice = null;
            this.started = false;
            this.log.debug(this + " stopped");
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }
}

