/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;
import org.jboss.messaging.util.StreamUtils;
import org.jboss.messaging.util.Streamable;

class BindingInfo
implements Streamable {
    private int nodeId;
    private String queueName;
    private String conditionText;
    private String filterString;
    private long channelId;
    private boolean durable;

    BindingInfo() {
    }

    BindingInfo(int nodeId, String queueName, String conditionText, String filterString, long channelId, boolean durable) {
        this.nodeId = nodeId;
        this.queueName = queueName;
        this.conditionText = conditionText;
        this.filterString = filterString;
        this.channelId = channelId;
        this.durable = durable;
    }

    public void execute(PostOfficeInternal office) throws Exception {
        office.addBindingFromCluster(this.nodeId, this.queueName, this.conditionText, this.filterString, this.channelId, this.durable);
    }

    public void read(DataInputStream in) throws Exception {
        this.nodeId = in.readInt();
        this.queueName = in.readUTF();
        this.conditionText = in.readUTF();
        this.filterString = (String)StreamUtils.readObject(in, false);
        this.channelId = in.readLong();
        this.durable = in.readBoolean();
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.nodeId);
        out.writeUTF(this.queueName);
        out.writeUTF(this.conditionText);
        StreamUtils.writeObject(out, this.filterString, false, false);
        out.writeLong(this.channelId);
        out.writeBoolean(this.durable);
    }

    long getChannelId() {
        return this.channelId;
    }

    String getConditionText() {
        return this.conditionText;
    }

    boolean isDurable() {
        return this.durable;
    }

    String getFilterString() {
        return this.filterString;
    }

    int getNodeId() {
        return this.nodeId;
    }

    String getQueueName() {
        return this.queueName;
    }
}

