/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.util.Iterator;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.Delivery;
import org.jboss.messaging.core.DeliveryObserver;
import org.jboss.messaging.core.Filter;
import org.jboss.messaging.core.Receiver;
import org.jboss.messaging.core.SimpleDelivery;
import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.plugin.contract.PersistenceManager;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusteredQueue;
import org.jboss.messaging.core.plugin.postoffice.cluster.QueueStats;
import org.jboss.messaging.core.tx.Transaction;

public class RemoteQueueStub
implements ClusteredQueue {
    private static final Logger log = Logger.getLogger(RemoteQueueStub.class);
    private static boolean trace = log.isTraceEnabled();
    private int nodeID;
    private String name;
    private long channelID;
    private Filter filter;
    private boolean recoverable;
    private PersistenceManager pm;
    private QueueStats stats;

    public RemoteQueueStub(int nodeId, String name, long id, boolean recoverable, PersistenceManager pm, Filter filter) {
        this.nodeID = nodeId;
        this.name = name;
        this.channelID = id;
        this.recoverable = recoverable;
        this.pm = pm;
        this.filter = filter;
    }

    public Delivery handle(DeliveryObserver observer, MessageReference reference, Transaction tx) {
        if (trace) {
            log.trace(this + " handling " + reference);
        }
        if (this.filter != null && !this.filter.accept(reference.getMessage())) {
            if (trace) {
                log.trace(this + " rejecting " + reference + " because it doesn't match filter");
            }
            return new SimpleDelivery(this, reference, false, false);
        }
        if (this.recoverable && reference.getMessage().isReliable()) {
            try {
                this.pm.addReference(this.channelID, reference, tx);
            }
            catch (Exception e) {
                log.error("Failed to add reference", e);
                return null;
            }
        }
        if (trace) {
            log.trace(this + " accepting " + reference + " for delivery");
        }
        return new SimpleDelivery(this, reference);
    }

    public boolean contains(Receiver receiver) {
        throw new UnsupportedOperationException();
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException();
    }

    public boolean add(Receiver receiver) {
        return false;
    }

    public boolean remove(Receiver receiver) {
        throw new UnsupportedOperationException();
    }

    public int getNumberOfReceivers() {
        throw new UnsupportedOperationException();
    }

    public void acknowledge(Delivery d, Transaction tx) throws Throwable {
        if (this.recoverable && d.getReference().getMessage().isReliable()) {
            this.pm.removeReference(this.channelID, d.getReference(), tx);
        }
    }

    public void cancel(Delivery d) throws Throwable {
        throw new UnsupportedOperationException();
    }

    public long getChannelID() {
        return this.channelID;
    }

    public boolean isRecoverable() {
        return this.recoverable;
    }

    public boolean acceptReliableMessages() {
        return true;
    }

    public List browse() {
        throw new UnsupportedOperationException();
    }

    public List browse(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public void deliver() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public List delivering(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public List undelivered(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public int getMessageCount() {
        throw new UnsupportedOperationException();
    }

    public void removeAllReferences() throws Throwable {
        throw new UnsupportedOperationException();
    }

    public void load() throws Exception {
    }

    public void unload() throws Exception {
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public boolean isActive() {
        throw new UnsupportedOperationException();
    }

    public List recoverDeliveries(List messageIds) {
        throw new UnsupportedOperationException();
    }

    public int getDeliveringCount() {
        throw new UnsupportedOperationException();
    }

    public int getMaxSize() {
        throw new UnsupportedOperationException();
    }

    public int getMessagesAdded() {
        throw new UnsupportedOperationException();
    }

    public void setMaxSize(int newSize) {
        throw new UnsupportedOperationException();
    }

    public int getScheduledCount() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean isClustered() {
        return true;
    }

    public QueueStats getStats() {
        return this.stats;
    }

    public int getNodeId() {
        return this.nodeID;
    }

    public boolean isLocal() {
        return false;
    }

    public void setStats(QueueStats stats) {
        this.stats = stats;
    }

    public String toString() {
        return "RemoteQueueStub[" + this.channelID + "/" + this.name + " -> " + this.nodeID + "]";
    }
}

