/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.messaging.util.Streamable;

class TransactionId
implements Streamable {
    private int nodeId;
    private long txId;
    private int hash = -1;

    TransactionId() {
    }

    TransactionId(int nodeId, long txId) {
        this.nodeId = nodeId;
        this.txId = txId;
    }

    int getNodeId() {
        return this.nodeId;
    }

    long getTxId() {
        return this.txId;
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.calculateHash();
        }
        return this.hash;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TransactionId)) {
            return false;
        }
        TransactionId tother = (TransactionId)other;
        return tother.txId == this.txId && tother.nodeId == this.nodeId;
    }

    public String toString() {
        return "TransactionId [" + System.identityHashCode(this) + "] nodeId: " + this.nodeId + " txId: " + this.txId;
    }

    private void calculateHash() {
        this.hash = 17;
        this.hash = 37 * this.hash + (int)(this.txId ^ this.txId >>> 32);
        this.hash = 37 * this.hash + this.nodeId;
    }

    public void read(DataInputStream in) throws Exception {
        this.nodeId = in.readInt();
        this.txId = in.readLong();
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.nodeId);
        out.writeLong(this.txId);
    }
}

