/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util;

import EDU.oswego.cs.dl.util.concurrent.ReentrantLock;
import org.jboss.logging.Logger;

public class Lockable {
    private static final Logger log = Logger.getLogger(Lockable.class);
    private ReentrantLock lock = new ReentrantLock();

    public final void lock() {
        while (true) {
            try {
                this.lock.acquire();
                if (log.isTraceEnabled()) {
                    log.trace("locked " + this);
                }
                return;
            }
            catch (InterruptedException e) {
                log.warn("failed to acquire " + this + "'s lock", e);
                continue;
            }
            break;
        }
    }

    public final boolean lock(long millisecs) {
        long t1 = System.currentTimeMillis();
        while (true) {
            try {
                boolean locked = this.lock.attempt(millisecs - System.currentTimeMillis() + t1);
                if (log.isTraceEnabled()) {
                    log.trace((locked ? "locked " : "could not acquire lock on ") + this);
                }
                return locked;
            }
            catch (InterruptedException e) {
                log.warn(e);
                continue;
            }
            break;
        }
    }

    public final void unlock() {
        this.lock.release();
        if (log.isTraceEnabled()) {
            log.trace("unlocked " + this);
        }
    }
}

