/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.types;

import java.io.Serializable;
import org.jboss.metatype.api.types.AbstractMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.types.TableMetaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMetaType<T extends Serializable>
extends AbstractMetaType<T> {
    private static final long serialVersionUID = -2062790692152055156L;
    private int dimension = 0;
    private MetaType elementType;
    private transient int cachedHashCode = Integer.MIN_VALUE;
    private transient String cachedToString = null;

    private static String genName(int dimension, MetaType elementType) {
        if (dimension < 1) {
            throw new IllegalArgumentException("negative dimension");
        }
        if (elementType == null) {
            throw new IllegalArgumentException("null element type");
        }
        if (elementType instanceof ArrayMetaType) {
            throw new IllegalArgumentException("array type cannot be an element of an array type");
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < dimension; ++i) {
            buffer.append('[');
        }
        buffer.append('L');
        buffer.append(elementType.getClassName());
        buffer.append(';');
        return buffer.toString();
    }

    private static String genDesc(int dimension, MetaType elementType) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(new Integer(dimension));
        buffer.append("-dimension array of ");
        buffer.append(elementType.getClassName());
        return buffer.toString();
    }

    public ArrayMetaType(int dimension, MetaType elementType) {
        super(ArrayMetaType.genName(dimension, elementType), ArrayMetaType.genDesc(dimension, elementType));
        this.dimension = dimension;
        this.elementType = elementType;
    }

    public int getDimension() {
        return this.dimension;
    }

    public MetaType getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        if (!clazz.isArray()) {
            return false;
        }
        if (this.elementType instanceof SimpleMetaType) {
            return this.recursiveCheck((Object[])obj, this.dimension);
        }
        if (this.elementType instanceof TableMetaType || this.elementType instanceof CompositeMetaType) {
            Class<?> thisClass = null;
            try {
                thisClass = Thread.currentThread().getContextClassLoader().loadClass(this.getClassName());
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            if (!thisClass.isAssignableFrom(clazz)) {
                return false;
            }
            return this.recursiveCheck((Object[])obj, this.dimension);
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ArrayMetaType)) {
            return false;
        }
        ArrayMetaType other = (ArrayMetaType)obj;
        return this.getDimension() == other.getDimension() && this.getElementType().equals(other.getElementType());
    }

    @Override
    public int hashCode() {
        if (this.cachedHashCode != Integer.MIN_VALUE) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = this.getDimension() + this.getElementType().hashCode();
        return this.cachedHashCode;
    }

    @Override
    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        StringBuilder buffer = new StringBuilder(ArrayMetaType.class.getSimpleName());
        buffer.append("{type=");
        buffer.append(this.getTypeName());
        buffer.append(" dims=");
        buffer.append(this.dimension);
        buffer.append(" elementType=" + this.elementType);
        this.cachedToString = buffer.toString();
        return this.cachedToString;
    }

    private boolean recursiveCheck(Object[] elements, int dimension) {
        if (dimension == 1) {
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] == null || this.elementType.isValue(elements[i])) continue;
                return false;
            }
        } else {
            for (int i = 0; i < elements.length; ++i) {
                if (this.recursiveCheck((Object[])elements[i], dimension - 1)) continue;
                return false;
            }
        }
        return true;
    }
}

