/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimerTask;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionListener;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.transport.ClientInvoker;
import org.jboss.remoting.util.StoppableTimerTask;
import org.jboss.remoting.util.TimerUtil;

public class ConnectionValidator
extends TimerTask
implements StoppableTimerTask {
    private static final Logger log = Logger.getLogger((class$org$jboss$remoting$ConnectionValidator == null ? (class$org$jboss$remoting$ConnectionValidator = ConnectionValidator.class$("org.jboss.remoting.ConnectionValidator")) : class$org$jboss$remoting$ConnectionValidator).getName());
    public static final long DEFAULT_PING_PERIOD = 2000L;
    private static boolean trace = log.isTraceEnabled();
    private Client client;
    private long pingPeriod;
    private InvokerLocator locator;
    private Map configMap;
    private List listeners;
    private ClientInvoker clientInvoker;
    private Object lock = new Object();
    private volatile boolean stopped;
    static /* synthetic */ Class class$org$jboss$remoting$ConnectionValidator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkConnection(InvokerLocator locator, Map config) throws Throwable {
        boolean pingWorked = false;
        HashMap<String, String> configMap = null;
        configMap = config == null ? new HashMap<String, String>() : new HashMap(config);
        configMap.put("connection_checker", "true");
        configMap.put("timeout", "1000");
        configMap.put("NumberOfRetries", "1");
        ClientInvoker innerClientInvoker = null;
        try {
            innerClientInvoker = InvokerRegistry.createClientInvoker(locator, configMap);
            if (!innerClientInvoker.isConnected()) {
                if (trace) {
                    log.trace("inner client invoker not connected, connecting ...");
                }
                innerClientInvoker.connect();
            }
            pingWorked = ConnectionValidator.doCheckConnection(innerClientInvoker);
        }
        catch (Throwable throwable) {
            log.debug("ConnectionValidator to connect to server " + innerClientInvoker.getLocator().getProtocol() + "://" + innerClientInvoker.getLocator().getHost() + ":" + innerClientInvoker.getLocator().getPort(), throwable);
        }
        finally {
            if (innerClientInvoker != null) {
                InvokerRegistry.destroyClientInvoker(locator, configMap);
            }
        }
        return pingWorked;
    }

    private static boolean doCheckConnection(ClientInvoker clientInvoker) throws Throwable {
        boolean pingWorked = false;
        try {
            InvocationRequest ir = new InvocationRequest(null, "self", "$PING$", null, null, null);
            if (trace) {
                log.trace("pinging, sending " + ir + " over " + clientInvoker);
            }
            clientInvoker.invoke(ir);
            if (trace) {
                log.trace("ConnectionValidator got successful ping using " + clientInvoker);
            }
            pingWorked = true;
        }
        catch (Throwable t) {
            log.debug("ConnectionValidator failed to ping via " + clientInvoker, t);
        }
        return pingWorked;
    }

    public ConnectionValidator(Client client) {
        this(client, 2000L);
    }

    public ConnectionValidator(Client client, long pingPeriod) {
        this.client = client;
        this.pingPeriod = pingPeriod;
        this.listeners = new ArrayList();
        this.stopped = false;
        log.debug(this + " created");
    }

    public void stop() {
        if (this.stopped) {
            return;
        }
        this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.stopped) {
                try {
                    boolean isValid;
                    if (trace) {
                        log.trace(this + " pinging ...");
                    }
                    if (!(isValid = ConnectionValidator.doCheckConnection(this.clientInvoker))) {
                        log.debug(this + "'s connections is invalid");
                        this.notifyListeners(new Exception("Could not connect to server!"));
                    }
                }
                catch (Throwable thr) {
                    log.debug(this + " got throwable while pinging", thr);
                    this.notifyListeners(thr);
                }
            }
        }
    }

    public boolean cancel() {
        return this.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(ConnectionListener listener) {
        if (listener != null) {
            List list2 = this.listeners;
            synchronized (list2) {
                if (this.listeners.size() == 0) {
                    this.start();
                }
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConnectionListener(ConnectionListener listener) {
        boolean isRemoved = false;
        if (listener != null) {
            List list2 = this.listeners;
            synchronized (list2) {
                isRemoved = this.listeners.remove(listener);
                if (this.listeners.size() == 0) {
                    this.stop();
                }
            }
        }
        return isRemoved;
    }

    public long getPingPeriod() {
        if (this.stopped) {
            return -1L;
        }
        return this.pingPeriod;
    }

    public String toString() {
        return "ConnectionValidator[" + this.clientInvoker + ", pingPeriod=" + this.pingPeriod + " ms]";
    }

    private void start() {
        this.configMap = this.client.getConfiguration() == null ? new HashMap() : new HashMap(this.client.getConfiguration());
        this.configMap.put("connection_checker", "true");
        this.configMap.put("timeout", "1000");
        this.configMap.put("NumberOfRetries", "1");
        this.locator = this.client.getInvoker().getLocator();
        try {
            this.clientInvoker = InvokerRegistry.createClientInvoker(this.locator, this.configMap);
        }
        catch (Exception e) {
            log.error("Unable to create client invoker for locator: " + this.locator);
            throw new RuntimeException("Unable to create client invoker for locator: " + this.locator, e);
        }
        if (!this.clientInvoker.isConnected()) {
            if (trace) {
                log.trace("inner client invoker not connected, connecting ...");
            }
            this.clientInvoker.connect();
        }
        TimerUtil.schedule(this, this.pingPeriod);
        this.stopped = false;
        log.debug(this + " started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doStop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.listeners.isEmpty()) {
                this.listeners.clear();
            }
            this.stopped = true;
        }
        if (this.clientInvoker != null) {
            InvokerRegistry.destroyClientInvoker(this.locator, this.configMap);
        }
        TimerUtil.unschedule(this);
        boolean result = super.cancel();
        log.debug(this + " stopped, returning " + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(Throwable thr) {
        final Throwable t = thr;
        List list2 = this.listeners;
        synchronized (list2) {
            ListIterator itr = this.listeners.listIterator();
            while (itr.hasNext()) {
                final ConnectionListener listener = (ConnectionListener)itr.next();
                new Thread(){

                    public void run() {
                        listener.handleConnectionException(t, ConnectionValidator.this.client);
                    }
                }.start();
            }
        }
        this.stop();
        this.listeners.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

