/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.plugins.deployers.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.resource.deployers.builder.AbstractBuilder;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.jboss.resource.metadata.repository.DefaultJCAMetaDataRepository;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedConnectionFactoryDeployer
extends AbstractSimpleRealDeployer<ManagedConnectionFactoryDeploymentGroup> {
    private String suffix;
    private DefaultJCAMetaDataRepository repository;
    private List<AbstractBuilder> builders = new ArrayList<AbstractBuilder>();

    public void setBuilders(List<AbstractBuilder> builders) {
        this.builders = builders;
    }

    public List<AbstractBuilder> getBuilders() {
        return this.builders;
    }

    public DefaultJCAMetaDataRepository getRepository() {
        return this.repository;
    }

    public void setRepository(DefaultJCAMetaDataRepository repository) {
        this.repository = repository;
    }

    public ManagedConnectionFactoryDeployer() {
        super(ManagedConnectionFactoryDeploymentGroup.class);
        this.setRelativeOrder(2001);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public void deploy(DeploymentUnit unit, ManagedConnectionFactoryDeploymentGroup group) throws DeploymentException {
        List<ManagedConnectionFactoryDeploymentMetaData> deployments = group.getDeployments();
        ServiceDeployment serviceDeployment = new ServiceDeployment();
        ArrayList<ServiceMetaData> componentServices = new ArrayList<ServiceMetaData>();
        List<ServiceMetaData> serviceDefintion = group.getServices();
        for (ServiceMetaData serviceMetaData : serviceDefintion) {
            componentServices.add(serviceMetaData);
        }
        for (ManagedConnectionFactoryDeploymentMetaData managedConnectionFactoryDeploymentMetaData : deployments) {
            for (AbstractBuilder builder : this.builders) {
                ServiceMetaData candidate = builder.build(managedConnectionFactoryDeploymentMetaData);
                if (candidate == null) continue;
                componentServices.add(candidate);
            }
        }
        serviceDeployment.setServices(componentServices);
        unit.addAttachment(ServiceDeployment.class, serviceDeployment);
    }

    @Override
    public void undeploy(DeploymentUnit unit, ManagedConnectionFactoryDeploymentGroup deployment) {
    }
}

