/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.acl.Group;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import org.jboss.crypto.JBossSXProvider;
import org.jboss.crypto.digest.DigestCallback;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.Base64Encoder;
import org.jboss.security.Base64Utils;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.SecurityConfiguration;

public class Util {
    private static Logger log = Logger.getLogger(Util.class);
    private static final int HASH_LEN = 20;
    public static final String BASE64_ENCODING = "BASE64";
    public static final String BASE16_ENCODING = "HEX";
    public static final String RFC2617_ENCODING = "RFC2617";
    private static char[] MD5_HEX = "0123456789abcdef".toCharArray();
    private static SecureRandom psuedoRng;
    private static MessageDigest sha1Digest;
    private static boolean initialized;

    public static void init() throws NoSuchAlgorithmException {
        if (initialized) {
            return;
        }
        Util.init(null);
    }

    public static void init(byte[] prngSeed) throws NoSuchAlgorithmException {
        sha1Digest = MessageDigest.getInstance("SHA");
        psuedoRng = SecureRandom.getInstance("SHA1PRNG");
        if (prngSeed != null) {
            psuedoRng.setSeed(prngSeed);
        }
        JBossSXProvider provider = new JBossSXProvider();
        Security.addProvider(provider);
        initialized = true;
    }

    public static MessageDigest newDigest() {
        MessageDigest md = null;
        try {
            md = (MessageDigest)sha1Digest.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return md;
    }

    public static MessageDigest copy(MessageDigest md) {
        MessageDigest copy = null;
        try {
            copy = (MessageDigest)md.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return copy;
    }

    public static Random getPRNG() {
        return psuedoRng;
    }

    public static double nextDouble() {
        return psuedoRng.nextDouble();
    }

    public static long nextLong() {
        return psuedoRng.nextLong();
    }

    public static void nextBytes(byte[] bytes) {
        psuedoRng.nextBytes(bytes);
    }

    public static byte[] generateSeed(int numBytes) {
        return psuedoRng.generateSeed(numBytes);
    }

    public static byte[] calculatePasswordHash(String username, char[] password, byte[] salt) {
        MessageDigest xd = Util.newDigest();
        byte[] user = null;
        byte[] colon = new byte[]{};
        try {
            user = username.getBytes("UTF-8");
            colon = ":".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("Failed to convert username to byte[] using UTF-8", e);
            user = username.getBytes();
            colon = ":".getBytes();
        }
        byte[] passBytes = new byte[2 * password.length];
        int passBytesLength = 0;
        for (int p = 0; p < password.length; ++p) {
            int c = password[p] & 0xFFFF;
            byte b0 = (byte)(c & 0xFF);
            byte b1 = (byte)((c & 0xFF00) >> 8);
            passBytes[passBytesLength++] = b0;
            if (c <= 255) continue;
            passBytes[passBytesLength++] = b1;
        }
        xd.update(user);
        xd.update(colon);
        xd.update(passBytes, 0, passBytesLength);
        byte[] h = xd.digest();
        xd.reset();
        xd.update(salt);
        xd.update(h);
        byte[] xb = xd.digest();
        return xb;
    }

    public static byte[] calculateVerifier(String username, char[] password, byte[] salt, byte[] Nb, byte[] gb) {
        BigInteger g = new BigInteger(1, gb);
        BigInteger N = new BigInteger(1, Nb);
        return Util.calculateVerifier(username, password, salt, N, g);
    }

    public static byte[] calculateVerifier(String username, char[] password, byte[] salt, BigInteger N, BigInteger g) {
        byte[] xb = Util.calculatePasswordHash(username, password, salt);
        BigInteger x = new BigInteger(1, xb);
        BigInteger v = g.modPow(x, N);
        return v.toByteArray();
    }

    public static byte[] sessionKeyHash(byte[] number) {
        int i;
        int offset;
        for (offset = 0; offset < number.length && number[offset] == 0; ++offset) {
        }
        byte[] key = new byte[40];
        int klen = (number.length - offset) / 2;
        byte[] hbuf = new byte[klen];
        for (i = 0; i < klen; ++i) {
            hbuf[i] = number[number.length - 2 * i - 1];
        }
        byte[] hout = Util.newDigest().digest(hbuf);
        for (i = 0; i < 20; ++i) {
            key[2 * i] = hout[i];
        }
        for (i = 0; i < klen; ++i) {
            hbuf[i] = number[number.length - 2 * i - 2];
        }
        hout = Util.newDigest().digest(hbuf);
        for (i = 0; i < 20; ++i) {
            key[2 * i + 1] = hout[i];
        }
        return key;
    }

    public static byte[] trim(byte[] in) {
        int i;
        if (in.length == 0 || in[0] != 0) {
            return in;
        }
        int len = in.length;
        for (i = 1; in[i] == 0 && i < len; ++i) {
        }
        byte[] ret = new byte[len - i];
        System.arraycopy(in, i, ret, 0, len - i);
        return ret;
    }

    public static byte[] xor(byte[] b1, byte[] b2, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)(b1[i] ^ b2[i]);
        }
        return result;
    }

    public static String encodeRFC2617(byte[] data) {
        char[] hash = new char[32];
        for (int i = 0; i < 16; ++i) {
            int j = data[i] >> 4 & 0xF;
            hash[i * 2] = MD5_HEX[j];
            j = data[i] & 0xF;
            hash[i * 2 + 1] = MD5_HEX[j];
        }
        return new String(hash);
    }

    public static String encodeBase16(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            char c = (char)(b >> 4 & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
            c = (char)(b & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String encodeBase64(byte[] bytes) {
        String base64 = null;
        try {
            base64 = Base64Encoder.encode(bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return base64;
    }

    public static String createPasswordHash(String hashAlgorithm, String hashEncoding, String hashCharset, String username, String password) {
        return Util.createPasswordHash(hashAlgorithm, hashEncoding, hashCharset, username, password, null);
    }

    public static String createPasswordHash(String hashAlgorithm, String hashEncoding, String hashCharset, String username, String password, DigestCallback callback) {
        byte[] passBytes;
        String passwordHash = null;
        try {
            passBytes = hashCharset == null ? password.getBytes() : password.getBytes(hashCharset);
        }
        catch (UnsupportedEncodingException uee) {
            log.error("charset " + hashCharset + " not found. Using platform default.", uee);
            passBytes = password.getBytes();
        }
        try {
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm);
            if (callback != null) {
                callback.preDigest(md);
            }
            md.update(passBytes);
            if (callback != null) {
                callback.postDigest(md);
            }
            byte[] hash = md.digest();
            if (hashEncoding.equalsIgnoreCase(BASE64_ENCODING)) {
                passwordHash = Util.encodeBase64(hash);
            } else if (hashEncoding.equalsIgnoreCase(BASE16_ENCODING)) {
                passwordHash = Util.encodeBase16(hash);
            } else if (hashEncoding.equalsIgnoreCase(RFC2617_ENCODING)) {
                passwordHash = Util.encodeRFC2617(hash);
            } else {
                log.error("Unsupported hash encoding format " + hashEncoding);
            }
        }
        catch (Exception e) {
            log.error("Password hash calculation failed ", e);
        }
        return passwordHash;
    }

    public static String tob64(byte[] buffer) {
        return Base64Utils.tob64(buffer);
    }

    public static byte[] fromb64(String str) throws NumberFormatException {
        return Base64Utils.fromb64(str);
    }

    public static boolean hasUnlimitedCrypto() {
        boolean hasUnlimitedCrypto = false;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> keyGenClass = loader.loadClass("javax.crypto.KeyGenerator");
            Class[] sig = new Class[]{String.class};
            Object[] args = new Object[]{"Blowfish"};
            Method kgenInstance = keyGenClass.getDeclaredMethod("getInstance", sig);
            Object kgen = kgenInstance.invoke(null, args);
            Class[] sig2 = new Class[]{Integer.TYPE};
            Object[] args2 = new Object[]{new Integer(256)};
            Method init = keyGenClass.getDeclaredMethod("init", sig2);
            init.invoke(kgen, args2);
            hasUnlimitedCrypto = true;
        }
        catch (Throwable e) {
            log.debug("hasUnlimitedCrypto error", e);
        }
        return hasUnlimitedCrypto;
    }

    public static Object createSecretKey(String cipherAlgorithm, Object key) throws KeyException {
        Class[] signature = new Class[]{key.getClass(), String.class};
        Object[] args = new Object[]{key, cipherAlgorithm};
        Object secretKey = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> secretKeySpecClass = loader.loadClass("javax.crypto.spec.SecretKeySpec");
            Constructor<?> ctor = secretKeySpecClass.getDeclaredConstructor(signature);
            secretKey = ctor.newInstance(args);
        }
        catch (Exception e) {
            throw new KeyException("Failed to create SecretKeySpec from session key, msg=" + e.getMessage());
        }
        catch (Throwable e) {
            throw new KeyException("Unexpected exception during SecretKeySpec creation, msg=" + e.getMessage());
        }
        return secretKey;
    }

    public static Object createCipher(String cipherAlgorithm) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(cipherAlgorithm);
        return cipher;
    }

    public static Object createSealedObject(String cipherAlgorithm, Object key, byte[] cipherIV, Serializable data) throws GeneralSecurityException {
        SealedObject sealedObject = null;
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            SecretKey skey = (SecretKey)key;
            if (cipherIV != null) {
                IvParameterSpec iv = new IvParameterSpec(cipherIV);
                cipher.init(1, (Key)skey, iv);
            } else {
                cipher.init(1, skey);
            }
            sealedObject = new SealedObject(data, cipher);
        }
        catch (GeneralSecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new GeneralSecurityException("Failed to create SealedObject, msg=" + e.getMessage());
        }
        return sealedObject;
    }

    public static Object accessSealedObject(String cipherAlgorithm, Object key, byte[] cipherIV, Object obj) throws GeneralSecurityException {
        Object data = null;
        try {
            Cipher cipher = Cipher.getInstance(cipherAlgorithm);
            SecretKey skey = (SecretKey)key;
            if (cipherIV != null) {
                IvParameterSpec iv = new IvParameterSpec(cipherIV);
                cipher.init(2, (Key)skey, iv);
            } else {
                cipher.init(2, skey);
            }
            SealedObject sealedObj = (SealedObject)obj;
            data = sealedObj.getObject(cipher);
        }
        catch (GeneralSecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new GeneralSecurityException("Failed to access SealedObject, msg=" + e.getMessage());
        }
        return data;
    }

    public static String unprefixSecurityDomain(String securityDomain) {
        String result = null;
        if (securityDomain != null) {
            if (securityDomain.startsWith("java:/jaas")) {
                result = securityDomain.substring("java:/jaas/".length());
            } else if (securityDomain.startsWith("java:/jbsx")) {
                result = securityDomain.substring("java:/jbsx/".length());
            }
        }
        return result;
    }

    public static Group getSubjectRoles(Subject theSubject) {
        if (theSubject == null) {
            throw new IllegalArgumentException("Subject is null");
        }
        Set<Group> subjectGroups = theSubject.getPrincipals(Group.class);
        Iterator<Group> iter = subjectGroups.iterator();
        Group roles = null;
        while (iter.hasNext()) {
            Group grp = iter.next();
            String name = grp.getName();
            if (!name.equals("Roles")) continue;
            roles = grp;
        }
        return roles;
    }

    public static ApplicationPolicy getApplicationPolicy(String domainName) {
        return SecurityConfiguration.getApplicationPolicy(domainName);
    }

    public static AuthenticationManager getAuthenticationManager(String securityDomain) {
        AuthenticationManager am;
        block2: {
            String securityMgrURL = "/securityMgr";
            String lookupURL = null;
            lookupURL = securityDomain.startsWith("java:/jaas") ? securityDomain + securityMgrURL : "java:/jaas/" + securityDomain + securityMgrURL;
            am = null;
            try {
                InitialContext ic = new InitialContext();
                am = (AuthenticationManager)ic.lookup(lookupURL);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace("Error in obtaining AuthenticationManager", e);
            }
        }
        return am;
    }

    public static AuthorizationManager getAuthorizationManager(String securityDomain) {
        AuthorizationManager am;
        block2: {
            String authorizationMgrURL = "/authorizationMgr";
            String lookupURL = null;
            lookupURL = securityDomain.startsWith("java:/jaas") ? securityDomain + authorizationMgrURL : "java:/jaas/" + securityDomain + authorizationMgrURL;
            am = null;
            try {
                InitialContext ic = new InitialContext();
                am = (AuthorizationManager)ic.lookup(lookupURL);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace("Error in obtaining AuthorizationMgr", e);
            }
        }
        return am;
    }
}

