/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.jacc.PolicyContext;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityDomain;
import org.jboss.security.SecurityProxyFactory;
import org.jboss.security.SubjectSecurityProxyFactory;
import org.jboss.security.auth.callback.CallbackHandlerPolicyContextHandler;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.jacc.SubjectPolicyContextHandler;
import org.jboss.security.plugins.AuthorizationManagerService;
import org.jboss.security.plugins.JaasSecurityManager;
import org.jboss.security.plugins.JaasSecurityManagerServiceMBean;
import org.jboss.security.plugins.SecurityDomainContext;
import org.jboss.security.plugins.SubjectActions;
import org.jboss.security.propertyeditor.PrincipalEditor;
import org.jboss.security.propertyeditor.SecurityDomainEditor;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.CachePolicy;
import org.jboss.util.TimedCachePolicy;

public class JaasSecurityManagerService
extends ServiceMBeanSupport
implements JaasSecurityManagerServiceMBean {
    private static final String SECURITY_MGR_PATH = "java:/jaas";
    private static final String DEFAULT_CACHE_POLICY_PATH = "java:/timedCacheFactory";
    private static Logger log;
    private static String securityMgrClassName;
    private static Class securityMgrClass;
    private static String callbackHandlerClassName;
    private static Class callbackHandlerClass;
    private static String cacheJndiName;
    private static int defaultCacheTimeout;
    private static int defaultCacheResolution;
    private static String securityProxyFactoryClassName;
    private static Class securityProxyFactoryClass;
    private static ConcurrentReaderHashMap securityDomainCtxMap;
    private static NameParser parser;
    private boolean serverMode = true;
    private static boolean deepCopySubjectMode;
    private static String defaultUnauthenticatedPrincipal;

    public boolean getServerMode() {
        return this.serverMode;
    }

    public void setServerMode(boolean mode) {
        this.serverMode = mode;
    }

    public String getSecurityManagerClassName() {
        return securityMgrClassName;
    }

    public void setSecurityManagerClassName(String className) throws ClassNotFoundException, ClassCastException {
        securityMgrClassName = className;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        securityMgrClass = loader.loadClass(securityMgrClassName);
        if (!AuthenticationManager.class.isAssignableFrom(securityMgrClass)) {
            throw new ClassCastException(securityMgrClass + " does not implement " + AuthenticationManager.class);
        }
    }

    public String getSecurityProxyFactoryClassName() {
        return securityProxyFactoryClassName;
    }

    public void setSecurityProxyFactoryClassName(String className) throws ClassNotFoundException {
        securityProxyFactoryClassName = className;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        securityProxyFactoryClass = loader.loadClass(securityProxyFactoryClassName);
    }

    public String getCallbackHandlerClassName() {
        return callbackHandlerClassName;
    }

    public void setCallbackHandlerClassName(String className) throws ClassNotFoundException {
        callbackHandlerClassName = className;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        callbackHandlerClass = loader.loadClass(callbackHandlerClassName);
    }

    public String getAuthenticationCacheJndiName() {
        return cacheJndiName;
    }

    public void setAuthenticationCacheJndiName(String jndiName) {
        cacheJndiName = jndiName;
    }

    public int getDefaultCacheTimeout() {
        return defaultCacheTimeout;
    }

    public void setDefaultCacheTimeout(int timeoutInSecs) {
        defaultCacheTimeout = timeoutInSecs;
    }

    public int getDefaultCacheResolution() {
        return defaultCacheResolution;
    }

    public void setDefaultCacheResolution(int resInSecs) {
        defaultCacheResolution = resInSecs;
    }

    public boolean getDeepCopySubjectMode() {
        return deepCopySubjectMode;
    }

    public void setDeepCopySubjectMode(boolean flag) {
        log.debug("setDeepCopySubjectMode=" + flag);
        deepCopySubjectMode = flag;
        if (!securityDomainCtxMap.isEmpty()) {
            for (String securityDomainName : securityDomainCtxMap.keySet()) {
                SecurityDomainContext sdc = (SecurityDomainContext)securityDomainCtxMap.get((Object)securityDomainName);
                JaasSecurityManagerService.setDeepCopySubjectOption(sdc.securityMgr, flag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheTimeout(String securityDomain, int timeoutInSecs, int resInSecs) {
        CachePolicy cache = JaasSecurityManagerService.getCachePolicy(securityDomain);
        if (cache != null && cache instanceof TimedCachePolicy) {
            TimedCachePolicy tcp;
            TimedCachePolicy timedCachePolicy = tcp = (TimedCachePolicy)cache;
            synchronized (timedCachePolicy) {
                tcp.setDefaultLifetime(timeoutInSecs);
                tcp.setResolution(resInSecs);
            }
        } else {
            log.warn("Failed to find cache policy for securityDomain='" + securityDomain + "'");
        }
    }

    public void flushAuthenticationCache(String securityDomain) {
        CachePolicy cache = JaasSecurityManagerService.getCachePolicy(securityDomain);
        if (cache != null) {
            cache.flush();
        } else {
            log.warn("Failed to find cache policy for securityDomain='" + securityDomain + "'");
        }
    }

    public void flushAuthenticationCache(String securityDomain, Principal user) {
        CachePolicy cache = JaasSecurityManagerService.getCachePolicy(securityDomain);
        if (cache != null) {
            cache.remove(user);
        } else {
            log.warn("Failed to find cache policy for securityDomain='" + securityDomain + "'");
        }
    }

    public List getAuthenticationCachePrincipals(String securityDomain) {
        CachePolicy cache = JaasSecurityManagerService.getCachePolicy(securityDomain);
        List validPrincipals = null;
        if (cache instanceof TimedCachePolicy) {
            TimedCachePolicy tcache = (TimedCachePolicy)cache;
            validPrincipals = tcache.getValidKeys();
        }
        return validPrincipals;
    }

    public boolean isValid(String securityDomain, Principal principal, Object credential) {
        boolean isValid = false;
        try {
            SecurityDomainContext sdc = JaasSecurityManagerService.lookupSecurityDomain(securityDomain);
            isValid = sdc.getSecurityManager().isValid(principal, credential, null);
        }
        catch (NamingException e) {
            log.debug("isValid(" + securityDomain + ") failed", e);
        }
        return isValid;
    }

    public Principal getPrincipal(String securityDomain, Principal principal) {
        Principal realmPrincipal = null;
        try {
            SecurityDomainContext sdc = JaasSecurityManagerService.lookupSecurityDomain(securityDomain);
            realmPrincipal = sdc.getRealmMapping().getPrincipal(principal);
        }
        catch (NamingException e) {
            log.debug("getPrincipal(" + securityDomain + ") failed", e);
        }
        return realmPrincipal;
    }

    public boolean doesUserHaveRole(String securityDomain, Principal principal, Object credential, Set roles) {
        boolean doesUserHaveRole = false;
        try {
            SecurityDomainContext sdc = JaasSecurityManagerService.lookupSecurityDomain(securityDomain);
            Subject subject = new Subject();
            boolean isValid = sdc.getSecurityManager().isValid(principal, credential, subject);
            if (isValid) {
                SubjectActions.pushSubjectContext(principal, credential, subject);
                doesUserHaveRole = sdc.getRealmMapping().doesUserHaveRole(principal, roles);
                SubjectActions.popSubjectContext();
            }
        }
        catch (NamingException e) {
            log.debug("doesUserHaveRole(" + securityDomain + ") failed", e);
        }
        return doesUserHaveRole;
    }

    public Set getUserRoles(String securityDomain, Principal principal, Object credential) {
        Set userRoles = null;
        try {
            SecurityDomainContext sdc = JaasSecurityManagerService.lookupSecurityDomain(securityDomain);
            Subject subject = new Subject();
            boolean isValid = sdc.getSecurityManager().isValid(principal, credential, subject);
            if (isValid) {
                SubjectActions.pushSubjectContext(principal, credential, subject);
                userRoles = sdc.getRealmMapping().getUserRoles(principal);
                SubjectActions.popSubjectContext();
            }
        }
        catch (NamingException e) {
            log.debug("getUserRoles(" + securityDomain + ") failed", e);
        }
        return userRoles;
    }

    protected void startService() throws Exception {
        if (this.serverMode) {
            SecurityAssociation.setServer();
        }
        SubjectPolicyContextHandler handler = new SubjectPolicyContextHandler();
        PolicyContext.registerHandler("javax.security.auth.Subject.container", handler, true);
        CallbackHandlerPolicyContextHandler chandler = new CallbackHandlerPolicyContextHandler();
        PolicyContext.registerHandler("org.jboss.security.auth.spi.CallbackHandler", chandler, false);
        InitialContext ctx = new InitialContext();
        parser = ctx.getNameParser("");
        StringRefAddr refAddr = new StringRefAddr("nns", "JSM");
        String factoryName = SecurityDomainObjectFactory.class.getName();
        Reference ref = new Reference("javax.naming.Context", refAddr, factoryName, null);
        ctx.rebind(SECURITY_MGR_PATH, (Object)ref);
        log.debug("securityMgrCtxPath=java:/jaas");
        refAddr = new StringRefAddr("nns", "JSMCachePolicy");
        factoryName = DefaultCacheObjectFactory.class.getName();
        ref = new Reference("javax.naming.Context", refAddr, factoryName, null);
        ctx.rebind(DEFAULT_CACHE_POLICY_PATH, (Object)ref);
        log.debug("cachePolicyCtxPath=" + cacheJndiName);
        SecurityProxyFactory proxyFactory = (SecurityProxyFactory)securityProxyFactoryClass.newInstance();
        ctx.bind("java:/SecurityProxyFactory", (Object)proxyFactory);
        log.debug("SecurityProxyFactory=" + proxyFactory);
        PropertyEditorManager.registerEditor(Principal.class, PrincipalEditor.class);
        PropertyEditorManager.registerEditor(SecurityDomain.class, SecurityDomainEditor.class);
        log.debug("Registered PrincipalEditor, SecurityDomainEditor");
        log.debug("ServerMode=" + this.serverMode);
        log.debug("SecurityMgrClass=" + securityMgrClass);
        log.debug("CallbackHandlerClass=" + callbackHandlerClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        InitialContext ic = new InitialContext();
        try {
            ic.unbind(SECURITY_MGR_PATH);
        }
        catch (CommunicationException communicationException) {
        }
        finally {
            ic.close();
        }
    }

    public synchronized void registerSecurityDomain(String securityDomain, SecurityDomain instance) {
        log.debug("Added " + securityDomain + ", " + instance + " to map");
        CachePolicy authCache = JaasSecurityManagerService.lookupCachePolicy(securityDomain);
        SecurityDomainContext sdc = new SecurityDomainContext(instance, authCache);
        sdc.setAuthorizationManager(AuthorizationManagerService.newAuthorizationManager(securityDomain));
        securityDomainCtxMap.put((Object)securityDomain, (Object)sdc);
        JaasSecurityManagerService.setSecurityDomainCache(instance, authCache);
    }

    private static CachePolicy getCachePolicy(String securityDomain) {
        if (securityDomain.startsWith(SECURITY_MGR_PATH)) {
            securityDomain = securityDomain.substring(SECURITY_MGR_PATH.length() + 1);
        }
        CachePolicy cache = null;
        try {
            SecurityDomainContext sdc = JaasSecurityManagerService.lookupSecurityDomain(securityDomain);
            if (sdc != null) {
                cache = sdc.getAuthenticationCache();
            }
        }
        catch (NamingException e) {
            log.debug("getCachePolicy(" + securityDomain + ") failure", e);
        }
        return cache;
    }

    static CachePolicy lookupCachePolicy(String securityDomain) {
        CachePolicy authCache = null;
        String domainCachePath = cacheJndiName + '/' + securityDomain;
        try {
            InitialContext iniCtx = new InitialContext();
            authCache = (CachePolicy)iniCtx.lookup(domainCachePath);
        }
        catch (Exception e) {
            try {
                InitialContext iniCtx = new InitialContext();
                authCache = (CachePolicy)iniCtx.lookup(cacheJndiName);
            }
            catch (Exception e2) {
                log.warn("Failed to locate auth CachePolicy at: " + cacheJndiName + " for securityDomain=" + securityDomain);
            }
        }
        return authCache;
    }

    private static void setSecurityDomainCache(AuthenticationManager securityMgr, CachePolicy cachePolicy) {
        block2: {
            try {
                Class[] setCachePolicyTypes = new Class[]{CachePolicy.class};
                Method m = securityMgrClass.getMethod("setCachePolicy", setCachePolicyTypes);
                Object[] setCachePolicyArgs = new Object[]{cachePolicy};
                m.invoke((Object)securityMgr, setCachePolicyArgs);
                log.debug("setCachePolicy, c=" + setCachePolicyArgs[0]);
            }
            catch (Exception e2) {
                if (!log.isTraceEnabled()) break block2;
                log.trace("Optional setCachePolicy failed" + e2.getLocalizedMessage());
            }
        }
    }

    private static void setDeepCopySubjectOption(AuthenticationManager securityMgr, boolean flag) {
        Boolean bValue = flag ? Boolean.TRUE : Boolean.FALSE;
        try {
            Class[] setDeepCopySubjTypes = new Class[]{Boolean.class};
            Method m = securityMgrClass.getMethod("setDeepCopySubjectOption", setDeepCopySubjTypes);
            Object[] setDeepCopySubjectOptionArgs = new Object[]{bValue};
            m.invoke((Object)securityMgr, setDeepCopySubjectOptionArgs);
            log.debug("setDeepCopySubjectOption, c=" + setDeepCopySubjectOptionArgs[0]);
        }
        catch (Exception e2) {
            log.debug("setDeepCopySubjectOption failed", e2);
        }
    }

    private static synchronized SecurityDomainContext lookupSecurityDomain(String securityDomain) throws NamingException {
        SecurityDomainContext securityDomainCtx = (SecurityDomainContext)securityDomainCtxMap.get((Object)securityDomain);
        if (securityDomainCtx == null) {
            securityDomainCtx = JaasSecurityManagerService.newSecurityDomainCtx(securityDomain);
            securityDomainCtxMap.put((Object)securityDomain, (Object)securityDomainCtx);
            log.debug("Added " + securityDomain + ", " + securityDomainCtx + " to map");
        }
        return securityDomainCtx;
    }

    private static synchronized SecurityDomainContext newSecurityDomainCtx(String securityDomain) throws NamingException {
        SecurityDomainContext sdc = null;
        try {
            Class[] parameterTypes = new Class[]{String.class, CallbackHandler.class};
            Constructor ctor = securityMgrClass.getConstructor(parameterTypes);
            CallbackHandler handler = (CallbackHandler)callbackHandlerClass.newInstance();
            Object[] args = new Object[]{securityDomain, handler};
            AuthenticationManager securityMgr = (AuthenticationManager)ctor.newInstance(args);
            log.debug("Created securityMgr=" + securityMgr);
            CachePolicy cachePolicy = JaasSecurityManagerService.lookupCachePolicy(securityDomain);
            sdc = new SecurityDomainContext(securityMgr, cachePolicy);
            JaasSecurityManagerService.setSecurityDomainCache(securityMgr, cachePolicy);
            if (deepCopySubjectMode) {
                JaasSecurityManagerService.setDeepCopySubjectOption(securityMgr, true);
            }
            AuthorizationManager am = AuthorizationManagerService.newAuthorizationManager(securityDomain);
            sdc.setAuthorizationManager(am);
        }
        catch (Exception e2) {
            String msg = "Failed to create sec mgr('" + securityDomain + "'), securityMgrClass=" + securityMgrClass + ", callbackHandlerClass=" + callbackHandlerClass;
            NamingException ne = new NamingException(msg);
            ne.setRootCause(e2);
            throw ne;
        }
        return sdc;
    }

    public String getDefaultUnauthenticatedPrincipal() {
        return defaultUnauthenticatedPrincipal;
    }

    public void setDefaultUnauthenticatedPrincipal(String principal) {
        defaultUnauthenticatedPrincipal = principal;
    }

    static {
        securityMgrClassName = "org.jboss.security.plugins.JaasSecurityManager";
        securityMgrClass = JaasSecurityManager.class;
        callbackHandlerClassName = "org.jboss.security.auth.callback.SecurityAssociationHandler";
        callbackHandlerClass = SecurityAssociationHandler.class;
        cacheJndiName = DEFAULT_CACHE_POLICY_PATH;
        defaultCacheTimeout = 1800;
        defaultCacheResolution = 60;
        securityProxyFactoryClassName = "org.jboss.security.SubjectSecurityProxyFactory";
        securityProxyFactoryClass = SubjectSecurityProxyFactory.class;
        securityDomainCtxMap = new ConcurrentReaderHashMap();
        deepCopySubjectMode = false;
        defaultUnauthenticatedPrincipal = "Unauthenticated Principal";
        log = Logger.getLogger(JaasSecurityManagerService.class);
    }

    public static class DefaultCacheObjectFactory
    implements InvocationHandler,
    ObjectFactory {
        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class[] interfaces = new Class[]{Context.class};
            Context ctx = (Context)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)this);
            return ctx;
        }

        public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
            TimedCachePolicy cachePolicy = new TimedCachePolicy(defaultCacheTimeout, true, defaultCacheResolution);
            cachePolicy.create();
            cachePolicy.start();
            return cachePolicy;
        }
    }

    static class DomainEnumeration
    implements NamingEnumeration {
        Enumeration domains;
        Map ctxMap;

        DomainEnumeration(Enumeration domains, Map ctxMap) {
            this.domains = domains;
            this.ctxMap = ctxMap;
        }

        public void close() {
        }

        public boolean hasMoreElements() {
            return this.domains.hasMoreElements();
        }

        public boolean hasMore() {
            return this.domains.hasMoreElements();
        }

        public Object next() {
            String name = (String)this.domains.nextElement();
            Object value = this.ctxMap.get(name);
            String className = value.getClass().getName();
            NameClassPair pair = new NameClassPair(name, className);
            return pair;
        }

        public Object nextElement() {
            return this.domains.nextElement();
        }
    }

    public static class SecurityDomainObjectFactory
    implements InvocationHandler,
    ObjectFactory {
        public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
            ClassLoader loader = SubjectActions.getContextClassLoader();
            Class[] interfaces = new Class[]{Context.class};
            Context ctx = (Context)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)this);
            return ctx;
        }

        public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("toString")) {
                return "java:/jaas Context proxy";
            }
            if (methodName.equals("list")) {
                return new DomainEnumeration(securityDomainCtxMap.keys(), (Map)securityDomainCtxMap);
            }
            if (!methodName.equals("lookup")) {
                throw new OperationNotSupportedException("Only lookup is supported, op=" + method);
            }
            String securityDomain = null;
            Name name = null;
            name = args[0] instanceof String ? parser.parse((String)args[0]) : (Name)args[0];
            securityDomain = name.get(0);
            SecurityDomainContext securityDomainCtx = JaasSecurityManagerService.lookupSecurityDomain(securityDomain);
            Object binding = securityDomainCtx.getSecurityManager();
            if (name.size() == 2) {
                String request = name.get(1);
                binding = securityDomainCtx.lookup(request);
            }
            return binding;
        }
    }
}

