/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.security.Principal;
import javax.security.auth.Subject;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SubjectInfo;
import org.jboss.security.plugins.JBossSecurityContext;
import org.jboss.security.plugins.JBossSecurityContextUtil;

public class SecurityContextFactory {
    public static SecurityContext createSecurityContext(String securityDomain) {
        JBossSecurityContext jsc = new JBossSecurityContext(securityDomain);
        return jsc;
    }

    public static SecurityContext createSecurityContext(Principal p, Object cred, Subject s, String securityDomain) {
        JBossSecurityContext jsc = new JBossSecurityContext(securityDomain);
        jsc.setSubjectInfo(SecurityContextFactory.createSubjectInfo(p, cred, s));
        return jsc;
    }

    public static SubjectInfo createSubjectInfo(Principal p, Object cred, Subject s) {
        SubjectInfo si = new SubjectInfo();
        si.setAuthenticatedSubject(s);
        si.setAuthenticationPrincipal(p);
        si.setAuthenticationCredential(cred);
        return si;
    }

    public static SecurityContextUtil createUtil() {
        return new JBossSecurityContextUtil();
    }
}

