/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.plugins.deployers.helpers.JAXPDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.system.deployers.SARArchiveFilter;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceDeploymentClassPath;
import org.jboss.system.metadata.ServiceDeploymentParser;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SARDeployer
extends JAXPDeployer<ServiceDeployment> {
    public SARDeployer() {
        super(ServiceDeployment.class);
    }

    @Override
    protected ServiceDeployment parse(DeploymentUnit unit, VirtualFile file, Document document) throws Exception {
        LoaderRepositoryFactory.LoaderRepositoryConfig config;
        ServiceDeploymentParser parser = new ServiceDeploymentParser(document);
        ServiceDeployment parsed = parser.parse();
        String name = file.toURI().toString();
        parsed.setName(name);
        List<ServiceDeploymentClassPath> classPaths = parsed.getClassPaths();
        if (classPaths != null) {
            this.processXMLClasspath(unit.getDeploymentContext(), classPaths);
        }
        if ((config = parsed.getLoaderRepositoryConfig()) != null) {
            unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class.getName(), config);
        }
        return parsed;
    }

    @Override
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        this.createMetaData(unit, null, "-service.xml");
    }

    private void processXMLClasspath(DeploymentContext context, List<ServiceDeploymentClassPath> classpaths) throws Exception {
        ArrayList<VirtualFile> classpath = new ArrayList<VirtualFile>();
        for (ServiceDeploymentClassPath path : classpaths) {
            String codebase = path.getCodeBase();
            String archives = path.getArchives();
            this.log.debug("Processing classpath: " + context.getName() + " codebase=" + codebase + " archives=" + archives);
            VirtualFile codebaseFile = context.getRoot();
            if (!".".equals(codebase)) {
                ServerConfig config = ServerConfigLocator.locate();
                URL codeBaseURL = new URL(config.getServerHomeURL(), codebase);
                codebaseFile = VFS.getVirtualFile(codeBaseURL, "");
            }
            if (codebaseFile == null) {
                throw new DeploymentException("Cannot use classpath without a root: " + context.getName());
            }
            if (archives == null) {
                classpath.add(codebaseFile);
                this.log.debug("Using codebase as classpath: " + context.getName());
                continue;
            }
            SARArchiveFilter filter = new SARArchiveFilter(archives);
            List<VirtualFile> archiveFiles = codebaseFile.getChildren(filter);
            classpath.addAll(archiveFiles);
        }
        List<VirtualFile> origClassPath = context.getClassPath();
        if (origClassPath != null) {
            classpath.addAll(origClassPath);
        }
        context.setClassPath(classpath);
    }
}

