/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.tm.CoordinatorFactory;
import org.jboss.tm.GlobalId;
import org.jboss.tm.JBossXAException;
import org.jboss.tm.JBossXATerminator;
import org.jboss.tm.LocalId;
import org.jboss.tm.OTSContextFactory;
import org.jboss.tm.ResourceFactory;
import org.jboss.tm.StringRemoteRefConverter;
import org.jboss.tm.TransactionImpl;
import org.jboss.tm.TransactionLocal;
import org.jboss.tm.TransactionLocalDelegate;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.TransactionPropagationContextImporter;
import org.jboss.tm.TransactionTimeoutConfiguration;
import org.jboss.tm.TxUtils;
import org.jboss.tm.XidImpl;
import org.jboss.tm.integrity.TransactionIntegrity;
import org.jboss.tm.recovery.LogRecord;
import org.jboss.tm.recovery.RecoveryLogger;
import org.jboss.tm.recovery.TxCompletionHandler;
import org.jboss.tm.remoting.interfaces.Coordinator;
import org.jboss.tm.remoting.interfaces.RecoveryCoordinator;
import org.jboss.tm.remoting.interfaces.Resource;
import org.jboss.tm.remoting.interfaces.TxPropagationContext;
import org.jboss.util.NotImplementedException;
import org.jboss.util.UnexpectedThrowable;
import org.jboss.util.UnreachableStatementException;

public class TxManager
implements TransactionManager,
TransactionPropagationContextImporter,
TransactionPropagationContextFactory,
TransactionLocalDelegate,
TransactionTimeoutConfiguration,
JBossXATerminator,
StringRemoteRefConverter {
    private boolean globalIdsEnabled = false;
    private boolean dtmEnabled = false;
    private boolean interruptThreads = false;
    private Logger log = Logger.getLogger(this.getClass());
    private boolean trace = this.log.isTraceEnabled();
    private long timeOut = 300000L;
    private volatile int commitCount;
    private volatile int rollbackCount;
    private RecoveryLogger recoveryLogger;
    private boolean recoveryPending = true;
    private TransactionIntegrity integrity;
    private int completionRetryLimit = 0;
    private int completionRetryTimeout = 1000;
    private int xaRetryTimeout = 60000;
    private int preparedTimeout = 60000;
    private boolean rootBranchRemembersHeuristicDecisions = true;
    private boolean reportHeuristicHazardAsHeuristicMixed = false;
    private static TxManager singleton = new TxManager();
    private ThreadLocal threadTx = new ThreadLocal();
    private Map localIdTx = Collections.synchronizedMap(new HashMap());
    private Map globalIdTx = Collections.synchronizedMap(new HashMap());

    public static TxManager getInstance() {
        return singleton;
    }

    private TxManager() {
        TransactionImpl.defaultXidFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Collection txCollection = this.localIdTx.values();
        Map map = this.localIdTx;
        synchronized (map) {
            for (TransactionImpl tx : txCollection) {
                tx.deactivate();
            }
        }
        this.localIdTx.clear();
        if (this.globalIdsEnabled) {
            this.globalIdTx.clear();
        }
    }

    public void setGlobalIdsEnabled(boolean newValue) {
        this.trace = this.log.isTraceEnabled();
        XidImpl.setTrulyGlobalIdsEnabled(newValue);
        this.globalIdsEnabled = newValue;
    }

    public boolean getGlobalIdsEnabled() {
        return this.globalIdsEnabled;
    }

    public void setInterruptThreads(boolean interruptThreads) {
        this.interruptThreads = interruptThreads;
    }

    public boolean isInterruptThreads() {
        return this.interruptThreads;
    }

    public void setRecoveryLogger(RecoveryLogger recoveryLogger) {
        this.recoveryLogger = recoveryLogger;
    }

    public RecoveryLogger getRecoveryLogger() {
        return this.recoveryLogger;
    }

    public void clearRecoveryPending() {
        this.recoveryPending = false;
    }

    public boolean isRecoveryPending() {
        return this.recoveryPending;
    }

    public void setTransactionIntegrity(TransactionIntegrity integrity) {
        this.integrity = integrity;
    }

    public TransactionIntegrity getTransactionIntegrity() {
        return this.integrity;
    }

    public void setCompletionRetryLimit(int maxCompletionRetries) {
        this.completionRetryLimit = maxCompletionRetries;
    }

    public int getCompletionRetryLimit() {
        return this.completionRetryLimit;
    }

    public void setCompletionRetryTimeout(int seconds) {
        this.completionRetryTimeout = 1000 * seconds;
    }

    public int getCompletionRetryTimeout() {
        return this.completionRetryTimeout / 1000;
    }

    public int getCompletionRetryTimeoutMillis() {
        return this.xaRetryTimeout;
    }

    public void setXARetryTimeout(int seconds) {
        this.xaRetryTimeout = 1000 * seconds;
    }

    public int getXARetryTimeout() {
        return this.xaRetryTimeout / 1000;
    }

    public int getXARetryTimeoutMillis() {
        return this.xaRetryTimeout;
    }

    public void setPreparedTimeout(int seconds) {
        this.preparedTimeout = 1000 * seconds;
    }

    public int getPreparedTimeout() {
        return this.preparedTimeout / 1000;
    }

    public int getPreparedTimeoutMillis() {
        return this.preparedTimeout;
    }

    public void setRootBranchRemembersHeuristicDecisions(boolean newValue) {
        this.rootBranchRemembersHeuristicDecisions = newValue;
    }

    public boolean isRootBranchRemembersHeuristicDecisions() {
        return this.rootBranchRemembersHeuristicDecisions;
    }

    public void setReportHeuristicHazardAsHeuristicMixed(boolean newValue) {
        this.reportHeuristicHazardAsHeuristicMixed = newValue;
    }

    public boolean isReportHeuristicHazardAsHeuristicMixed() {
        return this.reportHeuristicHazardAsHeuristicMixed;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.trace = this.log.isTraceEnabled();
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (current.isDone()) {
                this.disassociateThread(ti);
            } else {
                throw new NotSupportedException("Transaction already active, cannot nest transactions.");
            }
        }
        long timeout = ti.timeout == 0L ? this.timeOut : ti.timeout;
        TransactionImpl tx = new TransactionImpl(timeout);
        this.associateThread(ti, tx);
        this.localIdTx.put(tx.getLocalId(), tx);
        if (this.globalIdsEnabled) {
            this.globalIdTx.put(tx.getGlobalId(), tx);
        }
        if (this.trace) {
            this.log.trace("began tx: " + tx);
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            current.commit();
            this.disassociateThread(ti);
            if (this.trace) {
                this.log.trace("commited tx: " + current);
            }
        } else {
            throw new IllegalStateException("No transaction.");
        }
    }

    public int getStatus() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (current.isDone()) {
                this.disassociateThread(ti);
            } else {
                return current.getStatus();
            }
        }
        return 6;
    }

    public Transaction getTransaction() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null && current.isDone()) {
            current = null;
            this.disassociateThread(ti);
        }
        return current;
    }

    public void resume(Transaction transaction) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (transaction != null && !(transaction instanceof TransactionImpl)) {
            throw new RuntimeException("Not a TransactionImpl, but a " + transaction.getClass().getName());
        }
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (current.isDone()) {
                ti.tx = null;
                current = null;
            } else {
                throw new IllegalStateException("Already associated with a tx");
            }
        }
        if (current != transaction) {
            this.associateThread(ti, (TransactionImpl)transaction);
        }
        if (this.trace) {
            this.log.trace("resumed tx: " + ti.tx);
        }
    }

    public Transaction suspend() throws SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            current.disassociateCurrentThread();
            ti.tx = null;
            if (this.trace) {
                this.log.trace("suspended tx: " + current);
            }
            if (current.isDone()) {
                current = null;
            }
        }
        return current;
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (!current.isDone()) {
                current.rollback();
                if (this.trace) {
                    this.log.trace("rolled back tx: " + current);
                }
                return;
            }
            this.disassociateThread(ti);
        }
        throw new IllegalStateException("No transaction.");
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        ThreadInfo ti = this.getThreadInfo();
        TransactionImpl current = ti.tx;
        if (current != null) {
            if (!current.isDone()) {
                current.setRollbackOnly();
                if (this.trace) {
                    this.log.trace("tx marked for rollback only: " + current);
                }
                return;
            }
            ti.tx = null;
        }
        throw new IllegalStateException("No transaction.");
    }

    public int getTransactionTimeout() {
        return (int)(this.getThreadInfo().timeout / 1000L);
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getThreadInfo().timeout = 1000 * seconds;
        if (this.trace) {
            this.log.trace("tx timeout is now: " + seconds + "s");
        }
    }

    public void setDefaultTransactionTimeout(int seconds) {
        this.timeOut = 1000L * (long)seconds;
        if (this.trace) {
            this.log.trace("default tx timeout is now: " + seconds + "s");
        }
    }

    public int getDefaultTransactionTimeout() {
        return (int)(this.timeOut / 1000L);
    }

    public long getTimeLeftBeforeTransactionTimeout(boolean errorRollback) throws RollbackException {
        try {
            ThreadInfo ti = this.getThreadInfo();
            TransactionImpl current = ti.tx;
            if (current != null && current.isDone()) {
                this.disassociateThread(ti);
                return -1L;
            }
            return current.getTimeLeftBeforeTimeout(errorRollback);
        }
        catch (RollbackException e) {
            throw e;
        }
        catch (Exception ignored) {
            return -1L;
        }
    }

    public Transaction disassociateThread() {
        return this.disassociateThread(this.getThreadInfo());
    }

    private Transaction disassociateThread(ThreadInfo ti) {
        TransactionImpl current = ti.tx;
        ti.tx = null;
        current.disassociateCurrentThread();
        return current;
    }

    public void associateThread(Transaction transaction) {
        if (transaction != null && !(transaction instanceof TransactionImpl)) {
            throw new RuntimeException("Not a TransactionImpl, but a " + transaction.getClass().getName());
        }
        TransactionImpl transactionImpl = (TransactionImpl)transaction;
        ThreadInfo ti = this.getThreadInfo();
        ti.tx = transactionImpl;
        transactionImpl.associateCurrentThread();
    }

    private void associateThread(ThreadInfo ti, TransactionImpl transaction) {
        ti.tx = transaction;
        transaction.associateCurrentThread();
    }

    public int getTransactionCount() {
        return this.localIdTx.size();
    }

    public long getCommitCount() {
        return this.commitCount;
    }

    public long getRollbackCount() {
        return this.rollbackCount;
    }

    public String listInDoubtTransactions() {
        throw new NotImplementedException();
    }

    public void heuristicallyCommit(long localTransactionId) {
        throw new NotImplementedException();
    }

    public void heuristicallyCommitAll() {
        throw new NotImplementedException();
    }

    public void heuristicallyRollback(long localTransactionId) {
        throw new NotImplementedException();
    }

    public void heuristicallyRollbackAll() {
        throw new NotImplementedException();
    }

    public String listHeuristicallyCompletedTransactions() {
        throw new NotImplementedException();
    }

    public void forget(long localTransactionId) {
        throw new NotImplementedException();
    }

    public void forgetAll() {
        throw new NotImplementedException();
    }

    public Transaction importTransactionPropagationContext(Object tpc) {
        if (tpc instanceof LocalId) {
            LocalId id = (LocalId)tpc;
            return (Transaction)this.localIdTx.get(id);
        }
        if (tpc instanceof GlobalId && this.globalIdsEnabled) {
            GlobalId id = (GlobalId)tpc;
            Transaction tx = (Transaction)this.globalIdTx.get(id);
            if (this.trace) {
                if (tx != null) {
                    this.log.trace("Successfully imported transaction context " + tpc);
                } else {
                    this.log.trace("Could not import transaction context " + tpc);
                }
            }
            return tx;
        }
        if (tpc instanceof TxPropagationContext && this.dtmEnabled) {
            TxPropagationContext fullTpc = (TxPropagationContext)tpc;
            TransactionImpl tx = this.importExternalTransaction(fullTpc.formatId, fullTpc.globalId, fullTpc.coordinator, fullTpc.timeout * 1000);
            if (this.trace) {
                if (tx != null) {
                    this.log.trace("Successfully imported transaction context " + tpc);
                } else {
                    this.log.trace("Could not import transaction context " + tpc);
                }
            }
            return tx;
        }
        this.log.warn("Cannot import transaction propagation context: " + tpc);
        return null;
    }

    public Object getTransactionPropagationContext() {
        return this.getTransactionPropagationContext(this.getThreadInfo().tx);
    }

    public Object getTransactionPropagationContext(Transaction t) {
        if (t == null) {
            return null;
        }
        if (!(t instanceof TransactionImpl)) {
            this.log.warn("Cannot export transaction propagation context: " + t);
            return null;
        }
        TransactionImpl tx = (TransactionImpl)t;
        if (!this.dtmEnabled) {
            return tx.getLocalId();
        }
        return tx.getPropagationContext();
    }

    public void registerWork(Work work, Xid xid, long timeout) throws WorkCompletedException {
        if (this.trace) {
            this.log.trace("registering work=" + work + " xid=" + xid + " timeout=" + timeout);
        }
        try {
            TransactionImpl tx = this.importExternalTransaction(xid, timeout);
            tx.setWork(work);
        }
        catch (WorkCompletedException e) {
            throw e;
        }
        catch (Throwable t) {
            WorkCompletedException e = new WorkCompletedException("Error registering work", t);
            e.setErrorCode("3");
            throw e;
        }
        if (this.trace) {
            this.log.trace("registered work= " + work + " xid=" + xid + " timeout=" + timeout);
        }
    }

    public void startWork(Work work, Xid xid) throws WorkCompletedException {
        if (this.trace) {
            this.log.trace("starting work=" + work + " xid=" + xid);
        }
        TransactionImpl tx = this.getExternalTransaction(xid);
        this.associateThread(tx);
        if (this.trace) {
            this.log.trace("started work= " + work + " xid=" + xid);
        }
    }

    public void endWork(Work work, Xid xid) {
        if (this.trace) {
            this.log.trace("ending work=" + work + " xid=" + xid);
        }
        try {
            TransactionImpl tx = this.getExternalTransaction(xid);
            tx.setWork(null);
            this.disassociateThread();
        }
        catch (WorkCompletedException e) {
            this.log.error("Unexpected error from endWork ", e);
            throw new UnexpectedThrowable(e.toString());
        }
        if (this.trace) {
            this.log.trace("ended work=" + work + " xid=" + xid);
        }
    }

    public void cancelWork(Work work, Xid xid) {
        if (this.trace) {
            this.log.trace("cancling work=" + work + " xid=" + xid);
        }
        try {
            TransactionImpl tx = this.getExternalTransaction(xid);
            tx.setWork(null);
        }
        catch (WorkCompletedException e) {
            this.log.error("Unexpected error from cancelWork ", e);
            throw new UnexpectedThrowable(e.toString());
        }
        if (this.trace) {
            this.log.trace("cancled work=" + work + " xid=" + xid);
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (this.trace) {
            this.log.trace("preparing xid=" + xid);
        }
        try {
            TransactionImpl tx = this.getExternalTransaction(xid);
            this.resume(tx);
            int result = tx.prepare(xid);
            if (this.trace) {
                this.log.trace("prepared xid=" + xid + " result=" + result);
            }
            int n = result;
            return n;
        }
        catch (Throwable t) {
            JBossXAException.rethrowAsXAException("Error during prepare", t);
            throw new UnreachableStatementException();
        }
        finally {
            try {
                this.suspend();
            }
            catch (SystemException e) {
                JBossXAException.rethrowAsXAException("Error during prepare", e);
                throw new UnreachableStatementException();
            }
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (this.trace) {
            this.log.trace("rolling back xid=" + xid);
        }
        try {
            TransactionImpl tx = this.getExternalTransaction(xid);
            tx.rollback();
        }
        catch (Throwable t) {
            JBossXAException.rethrowAsXAException("Error during rollback", t);
        }
        if (this.trace) {
            this.log.trace("rolled back xid=" + xid);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (this.trace) {
            this.log.trace("committing xid=" + xid + " onePhase=" + onePhase);
        }
        try {
            TransactionImpl tx = this.getExternalTransaction(xid);
            tx.commit(onePhase);
        }
        catch (Throwable t) {
            JBossXAException.rethrowAsXAException("Error during commit", t);
        }
        if (this.trace) {
            this.log.trace("committed xid=" + xid);
        }
    }

    public void forget(Xid xid) throws XAException {
        if (this.trace) {
            this.log.trace("forgetting xid=" + xid);
        }
        try {
            TransactionImpl tx = this.getExternalTransaction(xid);
            tx.forget();
        }
        catch (Throwable t) {
            JBossXAException.rethrowAsXAException("Error during forget", t);
        }
        if (this.trace) {
            this.log.trace("forgot xid=" + xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int flag) throws XAException {
        ArrayList<Xid> xidList = new ArrayList<Xid>();
        Collection txCollection = this.localIdTx.values();
        Map map = this.localIdTx;
        synchronized (map) {
            for (TransactionImpl tx : txCollection) {
                if (!tx.isPreparedOrHeuristicallyCompletedJCAInboundTx()) continue;
                xidList.add(tx.getInboundXid());
            }
        }
        return xidList.toArray(new Xid[xidList.size()]);
    }

    public TransactionImpl importExternalTransaction(int formatId, byte[] globalId, Coordinator coordinator, long txTimeOut) {
        GlobalId gid = new GlobalId(formatId, globalId);
        TransactionImpl tx = (TransactionImpl)this.globalIdTx.get(gid);
        if (tx != null) {
            if (this.trace) {
                this.log.trace("imported existing transaction gid: " + gid + " tx=" + tx);
            }
        } else {
            ThreadInfo ti = this.getThreadInfo();
            long timeout = ti.timeout == 0L ? txTimeOut : ti.timeout;
            tx = new TransactionImpl(gid, coordinator, timeout);
            this.localIdTx.put(tx.getLocalId(), tx);
            if (this.globalIdsEnabled) {
                this.globalIdTx.put(gid, tx);
            }
            if (this.trace) {
                this.log.trace("imported new transaction gid: " + gid + " tx=" + tx + " timeout=" + timeout);
            }
        }
        return tx;
    }

    TransactionImpl importExternalTransaction(Xid xid, long txTimeOut) {
        GlobalId gid = new GlobalId(xid.getFormatId(), xid.getGlobalTransactionId());
        TransactionImpl tx = (TransactionImpl)this.globalIdTx.get(gid);
        if (tx != null) {
            if (this.trace) {
                this.log.trace("imported existing transaction gid: " + gid + " tx=" + tx);
            }
        } else {
            ThreadInfo ti = this.getThreadInfo();
            long timeout = ti.timeout == 0L ? txTimeOut : ti.timeout;
            tx = new TransactionImpl(gid, xid.getBranchQualifier(), timeout);
            this.localIdTx.put(tx.getLocalId(), tx);
            if (this.globalIdsEnabled) {
                this.globalIdTx.put(gid, tx);
            }
            if (this.trace) {
                this.log.trace("imported new transaction gid: " + gid + " tx=" + tx + " timeout=" + timeout);
            }
        }
        return tx;
    }

    TransactionImpl getExternalTransaction(Xid xid) throws WorkCompletedException {
        GlobalId gid = new GlobalId(xid);
        TransactionImpl tx = (TransactionImpl)this.globalIdTx.get(gid);
        if (tx == null) {
            throw new WorkCompletedException("Xid not found " + xid, "3");
        }
        return tx;
    }

    public void recreateTransaction(long localId, List pendingXAWorkList, TxCompletionHandler completionHandler, LogRecord.HeurData heurData) {
        LocalId localIdObject = new LocalId(localId);
        TransactionImpl tx = (TransactionImpl)this.localIdTx.get(localIdObject);
        if (tx != null) {
            if (this.trace) {
                this.log.trace("recreateTransaction called for existing transaction, localId=" + localId + ", tx=" + tx, new Throwable("[Stack trace]"));
            }
        } else {
            tx = new TransactionImpl(localId, pendingXAWorkList, completionHandler, heurData);
            this.localIdTx.put(tx.getLocalId(), tx);
            if (this.globalIdsEnabled) {
                this.globalIdTx.put(tx.getGlobalId(), tx);
            }
            if (this.trace) {
                this.log.trace("recreated transaction with localId=" + localId + ", tx=" + tx + ", status=" + TxUtils.getStatusAsString(tx.getStatus()));
            }
        }
    }

    public void recreateTransaction(long localId, List pendingXAWorkList, String[] resources, TxCompletionHandler completionHandler, LogRecord.HeurData heurData) {
        LocalId localIdObject = new LocalId(localId);
        TransactionImpl tx = (TransactionImpl)this.localIdTx.get(localIdObject);
        if (tx != null) {
            if (this.trace) {
                this.log.trace("recreateTransaction called for existing transaction, localId=" + localId + ", tx=" + tx, new Throwable("[Stack trace]"));
            }
        } else {
            tx = new TransactionImpl(localId, pendingXAWorkList, resources, completionHandler, heurData);
            this.localIdTx.put(tx.getLocalId(), tx);
            if (this.globalIdsEnabled) {
                this.globalIdTx.put(tx.getGlobalId(), tx);
            }
            if (this.trace) {
                this.log.trace("recreated transaction with localId=" + localId + ", tx=" + tx + ", status=" + TxUtils.getStatusAsString(tx.getStatus()));
            }
        }
    }

    public void recreateTransaction(long localId, int inboundFormatId, byte[] globalTransactionId, String recoveryCoord, List pendingXAWorkList, String[] resources, TxCompletionHandler completionHandler, LogRecord.HeurData heurData) {
        LocalId localIdObject = new LocalId(localId);
        TransactionImpl tx = (TransactionImpl)this.localIdTx.get(localIdObject);
        if (tx != null) {
            if (this.trace) {
                this.log.trace("recreateTransaction called for existing transaction, localId=" + localId + ", tx=" + tx, new Throwable("[Stack trace]"));
            }
        } else {
            tx = new TransactionImpl(localId, inboundFormatId, globalTransactionId, recoveryCoord, pendingXAWorkList, resources, completionHandler, heurData);
            this.localIdTx.put(tx.getLocalId(), tx);
            if (this.globalIdsEnabled) {
                this.globalIdTx.put(tx.getGlobalId(), tx);
            }
            if (this.trace) {
                this.log.trace("recreated transaction with localId=" + localId + " tx=" + tx + ", status=" + TxUtils.getStatusAsString(tx.getStatus()));
            }
        }
    }

    public void recreateTransaction(long localId, int inboundFormatId, byte[] globalTransactionId, byte[] inboundBranchQualifier, List pendingXAWorkList, String[] resources, TxCompletionHandler completionHandler, LogRecord.HeurData heurData) {
        LocalId localIdObject = new LocalId(localId);
        TransactionImpl tx = (TransactionImpl)this.localIdTx.get(localIdObject);
        if (tx != null) {
            if (this.trace) {
                this.log.trace("recreateTransaction called for existing transaction, localId=" + localId + ", tx=" + tx, new Throwable("[Stack trace]"));
            }
        } else {
            tx = new TransactionImpl(localId, inboundFormatId, globalTransactionId, inboundBranchQualifier, pendingXAWorkList, resources, completionHandler, heurData);
            this.localIdTx.put(tx.getLocalId(), tx);
            if (this.globalIdsEnabled) {
                this.globalIdTx.put(tx.getGlobalId(), tx);
            }
            if (this.trace) {
                this.log.trace("recreated transaction with localId=" + localId + ", tx=" + tx + ", status=" + TxUtils.getStatusAsString(tx.getStatus()));
            }
        }
    }

    public void recreateTransaction(LogRecord.HeurData heurData, List xaResourcesWithHeuristics, TxCompletionHandler completionHandler) {
        LocalId localIdObject = new LocalId(heurData.localTransactionId);
        TransactionImpl tx = (TransactionImpl)this.localIdTx.get(localIdObject);
        if (tx != null) {
            if (this.trace) {
                this.log.trace("recreateTransaction called for existing transaction, localId=" + heurData.localTransactionId + ", tx=" + tx + ", status=" + TxUtils.getStatusAsString(tx.getStatus()) + ", heuristicStatus=" + TxUtils.getXAErrorCodeAsString(heurData.heuristicStatusCode), new Throwable("[Stack trace]"));
            }
        } else {
            tx = new TransactionImpl(heurData, xaResourcesWithHeuristics, completionHandler);
            this.localIdTx.put(tx.getLocalId(), tx);
            if (this.globalIdsEnabled) {
                this.globalIdTx.put(tx.getGlobalId(), tx);
            }
            if (this.trace) {
                this.log.trace("recreated transaction with localId=" + heurData.localTransactionId + ", tx=" + tx + ", status=" + TxUtils.getStatusAsString(tx.getStatus()) + ", heuristicStatus=" + TxUtils.getXAErrorCodeAsString(heurData.heuristicStatusCode));
            }
        }
    }

    public void lock(TransactionLocal local, Transaction tx) throws InterruptedException {
        TransactionImpl tximpl = (TransactionImpl)tx;
        tximpl.lock();
    }

    public void unlock(TransactionLocal local, Transaction tx) {
        TransactionImpl tximpl = (TransactionImpl)tx;
        tximpl.unlock();
    }

    public Object getValue(TransactionLocal local, Transaction tx) {
        TransactionImpl tximpl = (TransactionImpl)tx;
        return tximpl.getTransactionLocalValue(local);
    }

    public void storeValue(TransactionLocal local, Transaction tx, Object value) {
        TransactionImpl tximpl = (TransactionImpl)tx;
        tximpl.putTransactionLocalValue(local, value);
    }

    public boolean containsValue(TransactionLocal local, Transaction tx) {
        TransactionImpl tximpl = (TransactionImpl)tx;
        return tximpl.containsTransactionLocal(local);
    }

    public Resource stringToResource(String strResource) {
        return TransactionImpl.stringToResource(strResource);
    }

    public RecoveryCoordinator stringToRecoveryCoordinator(String strRecCoordinator) {
        return TransactionImpl.stringToRecoveryCoordinator(strRecCoordinator);
    }

    public String resourceToString(Resource res) {
        return TransactionImpl.resourceToString(res);
    }

    public String recoveryCoordinatorToString(RecoveryCoordinator recoveryCoord) {
        return TransactionImpl.recoveryCoordinatorToString(recoveryCoord);
    }

    public void setDTMEnabled(boolean newValue) {
        if (newValue && !this.globalIdsEnabled) {
            this.setGlobalIdsEnabled(newValue);
        }
        this.dtmEnabled = newValue;
    }

    public void setDTMCoordinatorFactory(CoordinatorFactory dtmCoordinatorFactory) {
        TransactionImpl.setDTMCoordinatorFactory(dtmCoordinatorFactory);
    }

    public void setDTMResourceFactory(ResourceFactory dtmResourceFactory) {
        TransactionImpl.setDTMResourceFactory(dtmResourceFactory);
    }

    public void setOTSResourceFactory(ResourceFactory otsResourceFactory) {
        TransactionImpl.setOTSResourceFactory(otsResourceFactory);
    }

    public void setOTSContextFactory(OTSContextFactory otsContextFactory) {
        TransactionImpl.setOTSContextFactory(otsContextFactory);
    }

    public void setInterpositionEnabled(boolean newValue) {
        TransactionImpl.setInterpositionEnabled(newValue);
    }

    public boolean getInterpositionEnabled() {
        return TransactionImpl.getInterpositionEnabled();
    }

    public void setDTMStringRemoteRefConverter(StringRemoteRefConverter otsStrRemoteRefConverter) {
        TransactionImpl.setDTMStrRemoteRefConverter(otsStrRemoteRefConverter);
    }

    public void setOTSStringRemoteRefConverter(StringRemoteRefConverter otsStrRemoteRefConverter) {
        TransactionImpl.setOTSStrRemoteRefConverter(otsStrRemoteRefConverter);
    }

    void releaseTransactionImpl(TransactionImpl tx) {
        this.localIdTx.remove(tx.getLocalId());
        if (this.globalIdsEnabled) {
            this.globalIdTx.remove(tx.getGlobalId());
        }
    }

    void incCommitCount() {
        ++this.commitCount;
    }

    void incRollbackCount() {
        ++this.rollbackCount;
    }

    private ThreadInfo getThreadInfo() {
        ThreadInfo ret = (ThreadInfo)this.threadTx.get();
        if (ret == null) {
            ret = new ThreadInfo();
            ret.timeout = this.timeOut;
            this.threadTx.set(ret);
        }
        return ret;
    }

    static class ThreadInfo {
        long timeout;
        TransactionImpl tx;

        ThreadInfo() {
        }
    }
}

