/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.collection.temp;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakValueHashMap<K, V>
extends AbstractMap<K, V> {
    private Map<K, WeakValueRef<K, V>> hash;
    private ReferenceQueue<V> queue = new ReferenceQueue();

    public WeakValueHashMap(int initialCapacity, float loadFactor) {
        this.hash = new HashMap<K, WeakValueRef<K, V>>(initialCapacity, loadFactor);
    }

    public WeakValueHashMap(int initialCapacity) {
        this.hash = new HashMap<K, WeakValueRef<K, V>>(initialCapacity);
    }

    public WeakValueHashMap() {
        this.hash = new HashMap<K, WeakValueRef<K, V>>();
    }

    public WeakValueHashMap(Map<K, V> t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.hash.containsKey(key);
    }

    @Override
    public V get(Object key) {
        this.processQueue();
        WeakValueRef<K, V> ref = this.hash.get(key);
        if (ref != null) {
            return (V)ref.get();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        WeakValueRef ref = WeakValueRef.create(key, value, this.queue);
        WeakValueRef result = this.hash.put(key, ref);
        if (result != null) {
            return (V)result.get();
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        WeakValueRef<K, V> result = this.hash.remove(key);
        if (result != null) {
            return (V)result.get();
        }
        return null;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.processQueue();
        return new EntrySet();
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    private void processQueue() {
        WeakValueRef ref = (WeakValueRef)this.queue.poll();
        while (ref != null) {
            if (ref == this.hash.get(ref.key)) {
                this.hash.remove(ref.key);
            }
            ref = (WeakValueRef)this.queue.poll();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakValueRef<K, V>
    extends WeakReference<V>
    implements Map.Entry<K, V> {
        public K key;

        private static <K, V> WeakValueRef<K, V> create(K key, V val, ReferenceQueue<V> q) {
            if (val == null) {
                return null;
            }
            return new WeakValueRef<K, V>(key, val, q);
        }

        private WeakValueRef(K key, V val, ReferenceQueue<V> q) {
            super(val, q);
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return (V)this.get();
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("setValue");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySetIterator
    implements Iterator<Map.Entry<K, V>> {
        private Iterator<Map.Entry<K, WeakValueRef<K, V>>> delegate;

        public EntrySetIterator(Iterator<Map.Entry<K, WeakValueRef<K, V>>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry next = this.delegate.next();
            return next.getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator(WeakValueHashMap.this.hash.entrySet().iterator());
        }

        @Override
        public int size() {
            return WeakValueHashMap.this.size();
        }
    }
}

