/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import org.jboss.util.file.ArchiveBrowser;
import org.jboss.util.file.ArchiveBrowserFactory;
import org.jboss.util.file.DirectoryArchiveBrowser;
import org.jboss.util.file.JarArchiveBrowser;

public class FileProtocolArchiveBrowserFactory
implements ArchiveBrowserFactory {
    public Iterator create(URL url, ArchiveBrowser.Filter filter) {
        File f = null;
        try {
            f = new File(new URI(url.toString()));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Not a valid URL: " + url, e);
        }
        if (f.isDirectory()) {
            return new DirectoryArchiveBrowser(f, filter);
        }
        return new JarArchiveBrowser(f, filter);
    }
}

