/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployers.plugins.deployers.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployers.spi.deployment.MainDeployer;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.deployment.security.JaccPolicyUtil;
import org.jboss.metadata.WebMetaData;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDependencyMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.server.ServerConfig;
import org.jboss.system.server.ServerConfigLocator;
import org.jboss.util.file.Files;
import org.jboss.util.file.JarUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.web.WebApplication;
import org.jboss.web.deployers.AbstractWarDeployment;
import org.jboss.web.deployers.WebModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWarDeployer
extends AbstractSimpleRealDeployer<WebMetaData> {
    public static final String DEPLOYER = "org.jboss.web.AbstractWebContainer.deployer";
    public static final String WEB_APP = "org.jboss.web.AbstractWebContainer.webApp";
    public static final String WEB_MODULE = "org.jboss.web.AbstractWebContainer.webModule";
    public static final String ERROR = "org.jboss.web.AbstractWebContainer.error";
    protected HashMap deploymentMap = new HashMap();
    protected boolean java2ClassLoadingCompliance = false;
    protected boolean unpackWars = true;
    protected boolean acceptNonWarDirs = false;
    protected boolean lenientEjbLink = false;
    protected String defaultSecurityDomain = "java:/jaas/other";
    private String subjectAttributeName = null;
    private MBeanServer server;
    private MainDeployer mainDeployer;

    public AbstractWarDeployer() {
        super(WebMetaData.class);
        this.setRelativeOrder(7001);
    }

    public boolean getJava2ClassLoadingCompliance() {
        return this.java2ClassLoadingCompliance;
    }

    public void setJava2ClassLoadingCompliance(boolean flag) {
        this.java2ClassLoadingCompliance = flag;
    }

    public boolean getUnpackWars() {
        return this.unpackWars;
    }

    public void setUnpackWars(boolean flag) {
        this.unpackWars = flag;
    }

    public boolean getAcceptNonWarDirs() {
        return this.acceptNonWarDirs;
    }

    public void setAcceptNonWarDirs(boolean flag) {
        this.acceptNonWarDirs = flag;
    }

    public boolean getLenientEjbLink() {
        return this.lenientEjbLink;
    }

    public void setLenientEjbLink(boolean flag) {
        this.lenientEjbLink = flag;
    }

    public String getDefaultSecurityDomain() {
        return this.defaultSecurityDomain;
    }

    public void setDefaultSecurityDomain(String defaultSecurityDomain) {
        this.defaultSecurityDomain = defaultSecurityDomain;
    }

    public String getSubjectAttributeName() {
        return this.subjectAttributeName;
    }

    public void setSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeName = subjectAttributeName;
    }

    public void start() throws Exception {
        this.server = MBeanServerLocator.locateJBoss();
    }

    public void stop() throws Exception {
    }

    public abstract AbstractWarDeployment getDeployment(DeploymentUnit var1, WebMetaData var2) throws Exception;

    @Override
    public void deploy(DeploymentUnit unit, WebMetaData metaData) throws DeploymentException {
        this.log.debug("Begin deploy, " + metaData);
        try {
            File file;
            VirtualFile altDD;
            String altDDPath;
            String warName = unit.getName();
            if (warName.startsWith("jboss:") && warName.contains("id=")) {
                return;
            }
            URL expWarUrl = unit.getDeploymentContext().getRoot().toURL();
            if (!warName.endsWith("/") || warName.endsWith("!/")) {
                List<VirtualFile> classpathVFs;
                int dotWar;
                if (warName.startsWith("jar:")) {
                    warName = warName.endsWith("!/") ? warName.substring(4, warName.length() - 2) : warName.substring(4, warName.length());
                }
                URL warURL = new URL(warName);
                ServerConfig config = ServerConfigLocator.locate();
                String prefix = warURL.getFile();
                int lastSlash = prefix.lastIndexOf(47);
                if (lastSlash > 0) {
                    prefix = prefix.substring(lastSlash + 1);
                }
                if ((dotWar = prefix.lastIndexOf(".war")) > 0) {
                    prefix = prefix.substring(0, dotWar);
                }
                File expWarFile = File.createTempFile(prefix, "-exp.war", config.getServerTempDeployDir());
                expWarFile.delete();
                if (!expWarFile.mkdir()) {
                    throw new DeploymentException("Was unable to mkdir: " + expWarFile);
                }
                this.log.debug("Unpacking war to: " + expWarFile);
                VirtualFile root = unit.getDeploymentContext().getRoot();
                InputStream is = root.openStream();
                JarUtils.unjar(is, expWarFile);
                is.close();
                expWarUrl = expWarFile.toURL();
                DeploymentContext ctx = unit.getDeploymentContext();
                VirtualFile warVF = ctx.getRoot();
                String warPathName = warVF.getPathName();
                if (!warPathName.endsWith("/")) {
                    warPathName = warPathName + "/";
                }
                if ((classpathVFs = ctx.getClassPath()) != null) {
                    ArrayList<URL> classpath = new ArrayList<URL>();
                    for (VirtualFile vf : classpathVFs) {
                        try {
                            String path = vf.getPathName();
                            path = path.substring(warPathName.length());
                            URL pathURL = new URL(expWarUrl, path);
                            classpath.add(pathURL);
                        }
                        catch (Exception e) {
                            this.log.debug("Ignoring path element: " + vf, e);
                        }
                    }
                    unit.addAttachment("org.jboss.web.expandedWarClasspath", classpath);
                }
                unit.addAttachment("org.jboss.web.expandedWarURL", expWarUrl, URL.class);
            }
            if (!((altDDPath = metaData.getAltDDPath()) == null || (altDD = unit.getMetaDataFile(altDDPath)) != null || (file = new File(altDDPath)).exists() && file.isAbsolute())) {
                DeploymentUnit topUnit = unit.getDeploymentContext().getTopLevel().getDeploymentUnit();
                if (topUnit == unit) {
                    throw new DeploymentException("Unable to resolve " + altDDPath + " as WEB-INF path");
                }
                altDD = topUnit.getFile(altDDPath);
                if (altDD == null) {
                    throw new DeploymentException("Unable to resolve " + altDDPath + " as a deployment path");
                }
                File webInf = new File(expWarUrl.toURI());
                File altDDFile = new File(webInf, "WEB-INF/" + altDD.getName());
                this.log.debug("Copying the altDD to: " + altDDFile);
                Files.copy(altDD.toURL(), altDDFile);
                metaData.setAltDDPath(altDDFile.getAbsolutePath());
            }
            metaData.setJava2ClassLoadingCompliance(this.java2ClassLoadingCompliance);
            String webContext = metaData.getContextRoot();
            webContext = this.buildWebContext(webContext, warName, metaData, unit);
            metaData.setContextRoot(webContext);
            AbstractWarDeployment deployment = this.getDeployment(unit, metaData);
            deployment.setMainDeployer(this.mainDeployer);
            this.deployWebModule(unit, metaData, deployment);
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to create web module", e);
        }
    }

    @Override
    public void undeploy(DeploymentUnit unit, WebMetaData metaData) {
        try {
            URL warURL = unit.getAttachment("org.jboss.web.expandedWarURL", URL.class);
            if (warURL != null) {
                File war = new File(warURL.toURI());
                Files.delete(war);
            }
        }
        catch (Exception e) {
            this.log.debug("Failed to remove expanded war", e);
        }
        metaData.setContextLoader(null);
        metaData.setResourceClassLoader(null);
        metaData.setENCLoader(null);
    }

    public void addDeployedApp(String warURL, WebApplication webApp) {
        this.deploymentMap.put(warURL, webApp);
    }

    public WebApplication getDeployedApp(String warUrl) {
        WebApplication appInfo = (WebApplication)this.deploymentMap.get(warUrl);
        return appInfo;
    }

    public WebApplication removeDeployedApp(String warURL) {
        WebApplication appInfo = (WebApplication)this.deploymentMap.remove(warURL);
        return appInfo;
    }

    public Iterator getDeployedApplications() {
        return this.deploymentMap.values().iterator();
    }

    public static URL[] getClassLoaderURLs(ClassLoader cl) {
        URL[] urls = new URL[]{};
        try {
            Object[] args;
            Class<?> returnType = urls.getClass();
            Class[] parameterTypes = new Class[]{};
            Method getURLs = cl.getClass().getMethod("getURLs", parameterTypes);
            if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
            if ((urls == null || urls.length == 0) && returnType.isAssignableFrom((getURLs = cl.getClass().getMethod("getAllURLs", parameterTypes)).getReturnType())) {
                args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }

    protected String buildWebContext(String ctxPath, String warName, WebMetaData metaData, DeploymentUnit unit) {
        String webContext = ctxPath;
        if (webContext == null) {
            char c;
            int index;
            int suffix;
            int prefix;
            webContext = warName;
            if ((webContext = webContext.replace('\\', '/')).endsWith("/")) {
                webContext = webContext.substring(0, webContext.length() - 1);
            }
            if ((prefix = webContext.lastIndexOf(47)) > 0) {
                webContext = webContext.substring(prefix + 1);
            }
            if ((suffix = webContext.lastIndexOf(".war")) > 0) {
                webContext = webContext.substring(0, suffix);
            }
            for (index = 0; index < webContext.length() && (Character.isDigit(c = webContext.charAt(index)) || c == '.'); ++index) {
            }
            webContext = webContext.substring(index);
        }
        if (webContext.length() > 0 && webContext.charAt(0) != '/') {
            webContext = "/" + webContext;
        } else if (webContext.equals("/")) {
            webContext = "";
        }
        return webContext;
    }

    @Deprecated
    protected MBeanServer getServer() {
        return this.server;
    }

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    protected String getObjectName(WebMetaData metaData) {
        String ctxPath = metaData.getContextRoot();
        if (ctxPath == null || ctxPath.length() == 0) {
            ctxPath = "/";
        }
        String objectName = "jboss.web.deployment:war=" + ctxPath;
        return objectName;
    }

    protected void deployWebModule(DeploymentUnit unit, WebMetaData metaData, AbstractWarDeployment deployment) throws Exception {
        this.log.debug("deployWebModule");
        try {
            ServiceMetaData webModule = new ServiceMetaData();
            String name = this.getObjectName(metaData);
            ObjectName objectName = new ObjectName(name);
            webModule.setObjectName(objectName);
            webModule.setCode(WebModule.class.getName());
            ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
            constructor.setSignature(new String[]{DeploymentUnit.class.getName(), AbstractWarDeployer.class.getName(), AbstractWarDeployment.class.getName()});
            constructor.setParameters(new Object[]{unit, this, deployment});
            webModule.setConstructor(constructor);
            Collection<String> depends = metaData.getDependencies();
            ArrayList<ServiceDependencyMetaData> dependencies = new ArrayList<ServiceDependencyMetaData>();
            for (String iDependOn : depends) {
                ServiceDependencyMetaData sdmd = new ServiceDependencyMetaData();
                sdmd.setIDependOn(iDependOn);
            }
            webModule.setDependencies(dependencies);
            ArrayList<ServiceAttributeMetaData> attrs = new ArrayList<ServiceAttributeMetaData>();
            JaccPolicyUtil.getServiceAttributeMetaData(unit, attrs);
            webModule.setAttributes(attrs);
            unit.addAttachment(ServiceMetaData.class, webModule);
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException("Error creating rar deployment " + unit.getName(), e);
        }
    }
}

