/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URL;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.jboss.logging.Logger;
import org.jboss.ws.core.jaxrpc.client.ServiceObjectFactory;
import org.jboss.ws.core.server.ServiceEndpointManager;
import org.jboss.ws.core.server.ServiceEndpointManagerFactory;
import org.jboss.ws.integration.UnifiedVirtualFile;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;
import org.jboss.ws.metadata.j2ee.serviceref.UnifiedServiceRefMetaData;
import org.jboss.ws.metadata.wsse.WSSecurityConfiguration;
import org.jboss.ws.metadata.wsse.WSSecurityOMFactory;

public class ServiceReferenceable
implements Referenceable {
    private static Logger log = Logger.getLogger(ServiceReferenceable.class);
    public static final String SERVICE_REF_META_DATA = "SERVICE_REF_META_DATA";
    public static final String SECURITY_CONFIG = "SECURITY_CONFIG";
    public static final String PORT_COMPONENT_LINK = "PORT_COMPONENT_LINK";
    public static final String PORT_COMPONENT_LINK_SERVLET = "PORT_COMPONENT_LINK_SERVLET";
    private UnifiedServiceRefMetaData refMetaData;
    private UnifiedVirtualFile vfsRoot;

    public ServiceReferenceable(UnifiedServiceRefMetaData refMetaData) {
        this.refMetaData = refMetaData;
        this.vfsRoot = refMetaData.getVfsRoot();
    }

    public Reference getReference() throws NamingException {
        Reference myRef = new Reference(ServiceReferenceable.class.getName(), ServiceObjectFactory.class.getName(), null);
        myRef.add(new BinaryRefAddr(SERVICE_REF_META_DATA, this.marshallServiceRef()));
        if (this.getSecurityConfig() != null) {
            myRef.add(new BinaryRefAddr(SECURITY_CONFIG, this.marshallSecurityConfig()));
        }
        for (UnifiedPortComponentRefMetaData pcr : this.refMetaData.getPortComponentRefs()) {
            String pcLink = pcr.getPortComponentLink();
            if (pcLink == null) continue;
            myRef.add(new StringRefAddr(PORT_COMPONENT_LINK, pcLink));
            try {
                ServiceEndpointManagerFactory factory = ServiceEndpointManagerFactory.getInstance();
                ServiceEndpointManager epManager = factory.getServiceEndpointManager();
                String host = epManager.getWebServiceHost();
                int port = epManager.getWebServicePort();
                String servletURL = "http://" + host + ":" + port + "/jbossws/pclink";
                myRef.add(new StringRefAddr(PORT_COMPONENT_LINK_SERVLET, servletURL));
            }
            catch (Exception ex) {
                throw new NamingException("Cannot obtain path to PortComponentLinkServlet: " + ex);
            }
        }
        return myRef;
    }

    private byte[] marshallServiceRef() throws NamingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.refMetaData);
            oos.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot marshall service ref meta data, cause: " + e.toString());
        }
        return baos.toByteArray();
    }

    private byte[] marshallSecurityConfig() throws NamingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            WSSecurityOMFactory factory = WSSecurityOMFactory.newInstance();
            WSSecurityConfiguration securityConfig = factory.parse(this.getSecurityConfig());
            oos.writeObject(securityConfig);
            oos.close();
        }
        catch (IOException e) {
            throw new NamingException("Cannot marshall security config, cause: " + e.toString());
        }
        return baos.toByteArray();
    }

    private URL getSecurityConfig() {
        UnifiedVirtualFile vfConfig;
        URL securityConfigURL = null;
        try {
            vfConfig = this.vfsRoot.findChild("WEB-INF/" + WSSecurityOMFactory.CLIENT_RESOURCE_NAME);
            securityConfigURL = vfConfig.toURL();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            vfConfig = this.vfsRoot.findChild("META-INF/" + WSSecurityOMFactory.CLIENT_RESOURCE_NAME);
            securityConfigURL = vfConfig.toURL();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return securityConfigURL;
    }
}

