/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import java.util.List;
import java.util.SortedMap;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.ConstPool;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxws.AbstractWrapperGenerator;
import org.jboss.ws.core.utils.JavaUtils;
import org.jboss.ws.core.utils.JavassistUtils;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.TypeMappingMetaData;
import org.jboss.ws.metadata.umdm.TypesMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;

public class DynamicWrapperGenerator
extends AbstractWrapperGenerator {
    private static Logger log = Logger.getLogger(DynamicWrapperGenerator.class);
    protected ClassPool pool;
    protected boolean prune = true;

    public DynamicWrapperGenerator(ClassLoader loader) {
        super(loader);
        this.init(loader);
    }

    private void init(ClassLoader loader) {
        this.pool = new ClassPool(true);
        this.pool.appendClassPath((ClassPath)new LoaderClassPath(loader));
    }

    public void reset(ClassLoader loader) {
        super.reset(loader);
        this.init(loader);
    }

    public void generate(ParameterMetaData pmd) {
        String wrapperName = pmd.getJavaTypeName();
        List<WrappedParameter> wrappedParameters = pmd.getWrappedParameters();
        OperationMetaData opMetaData = pmd.getOperationMetaData();
        if (!opMetaData.isDocumentWrapped()) {
            throw new WSException("Operation is not document/literal (wrapped)");
        }
        if (wrappedParameters == null) {
            throw new WSException("Cannot generate a type when their is no wrapper parameters");
        }
        if (log.isDebugEnabled()) {
            log.debug("Generating wrapper: " + wrapperName);
        }
        QName xmlName = pmd.getXmlName();
        QName xmlType = pmd.getXmlType();
        try {
            CtClass clazz = this.pool.makeClass(wrapperName);
            clazz.getClassFile().setVersionToJava5();
            DynamicWrapperGenerator.addClassAnnotations(clazz, xmlName, xmlType, null);
            for (WrappedParameter parameter : wrappedParameters) {
                this.addProperty(clazz, parameter.getType(), parameter.getName(), parameter.getVariable(), parameter.getTypeArguments());
            }
            clazz.stopPruning(!this.prune);
            this.pool.toClass(clazz, this.loader);
            JavaUtils.clearBlacklists(this.loader);
        }
        catch (Exception e) {
            throw new WSException("Could not generate wrapper type: " + wrapperName, e);
        }
        TypesMetaData types = opMetaData.getEndpointMetaData().getServiceMetaData().getTypesMetaData();
        types.addTypeMapping(new TypeMappingMetaData(types, xmlType, wrapperName));
    }

    public void generate(FaultMetaData fmd) {
        String faultBeanName = fmd.getFaultBeanName();
        if (log.isDebugEnabled()) {
            log.debug("Generating fault bean: " + faultBeanName);
        }
        QName xmlType = fmd.getXmlType();
        Class exception = fmd.getJavaType();
        try {
            SortedMap<String, Class<?>> properties = this.getExceptionProperties(exception);
            String[] propertyOrder = properties.keySet().toArray(new String[0]);
            CtClass clazz = this.pool.makeClass(faultBeanName);
            clazz.getClassFile().setVersionToJava5();
            DynamicWrapperGenerator.addClassAnnotations(clazz, fmd.getXmlName(), fmd.getXmlType(), propertyOrder);
            for (String property : propertyOrder) {
                this.addProperty(clazz, ((Class)properties.get(property)).getName(), new QName(property), property, null);
            }
            clazz.stopPruning(!this.prune);
            this.pool.toClass(clazz, this.loader);
            JavaUtils.clearBlacklists(this.loader);
        }
        catch (Exception e) {
            throw new WSException("Could not generate fault wrapper bean: " + faultBeanName, e);
        }
        TypesMetaData types = fmd.getOperationMetaData().getEndpointMetaData().getServiceMetaData().getTypesMetaData();
        types.addTypeMapping(new TypeMappingMetaData(types, xmlType, faultBeanName));
    }

    private static String getterPrefix(CtClass type) {
        return type == CtClass.booleanType || "java.lang.Boolean".equals(type.getName()) ? "is" : "get";
    }

    private String typeSignature(String type, String[] arguments) {
        StringBuilder ret = new StringBuilder(JavaUtils.toSignature(type));
        ret.deleteCharAt(ret.length() - 1).append('<');
        for (String arg : arguments) {
            ret.append(JavaUtils.toSignature(arg));
        }
        return ret.append(">;").toString();
    }

    private String getterSignature(String type) {
        return "()" + type;
    }

    private String setterSignature(String type) {
        return "(" + type + ")V";
    }

    private void addProperty(CtClass clazz, String typeName, QName name, String variable, String[] typeArguments) throws CannotCompileException, NotFoundException {
        ConstPool constPool = clazz.getClassFile().getConstPool();
        String fieldName = JavaUtils.isReservedKeyword(variable) ? "_" + variable : variable;
        CtField field = new CtField(this.pool.get(typeName), fieldName, clazz);
        field.setModifiers(2);
        String typeSignature = null;
        if (typeArguments != null) {
            typeSignature = this.typeSignature(typeName, typeArguments);
            JavassistUtils.addSignature(field, typeSignature);
        }
        JavassistUtils.Annotation annotation = JavassistUtils.createAnnotation(XmlElement.class, constPool);
        if (name.getNamespaceURI() != null) {
            annotation.addParameter("namespace", name.getNamespaceURI());
        }
        annotation.addParameter("name", name.getLocalPart());
        annotation.markField(field);
        clazz.addField(field);
        CtMethod getter = CtNewMethod.getter((String)(DynamicWrapperGenerator.getterPrefix(field.getType()) + JavaUtils.capitalize(variable)), (CtField)field);
        CtMethod setter = CtNewMethod.setter((String)("set" + JavaUtils.capitalize(variable)), (CtField)field);
        if (typeSignature != null) {
            JavassistUtils.addSignature(getter, this.getterSignature(typeSignature));
            JavassistUtils.addSignature(setter, this.setterSignature(typeSignature));
        }
        clazz.addMethod(getter);
        clazz.addMethod(setter);
    }

    private static void addClassAnnotations(CtClass clazz, QName xmlName, QName xmlType, String[] propertyOrder) {
        ConstPool constPool = clazz.getClassFile().getConstPool();
        JavassistUtils.Annotation annotation = JavassistUtils.createAnnotation(XmlRootElement.class, constPool);
        if (xmlName.getNamespaceURI() != null && xmlName.getNamespaceURI().length() > 0) {
            annotation.addParameter("namespace", xmlName.getNamespaceURI());
        }
        annotation.addParameter("name", xmlName.getLocalPart());
        annotation.markClass(clazz);
        annotation = JavassistUtils.createAnnotation(XmlType.class, constPool);
        if (xmlType.getNamespaceURI() != null & xmlType.getNamespaceURI().length() > 0) {
            annotation.addParameter("namespace", xmlType.getNamespaceURI());
        }
        annotation.addParameter("name", xmlType.getLocalPart());
        if (propertyOrder != null) {
            annotation.addParameter("propOrder", propertyOrder);
        }
        annotation.markClass(clazz);
        annotation = JavassistUtils.createAnnotation(XmlAccessorType.class, constPool);
        annotation.addParameter("value", (Enum)XmlAccessType.FIELD);
        annotation.markClass(clazz);
    }
}

