/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.handler;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxws.handler.MessageContextJAXWS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPMessageContextJAXWS
extends MessageContextJAXWS
implements SOAPMessageContext {
    private Set<String> roles = new HashSet<String>();

    public SOAPMessageContextJAXWS() {
    }

    public SOAPMessageContextJAXWS(CommonMessageContext msgContext) {
        super(msgContext);
    }

    @Override
    public SOAPMessage getMessage() {
        return this.getSOAPMessage();
    }

    @Override
    public void setMessage(SOAPMessage soapMessage) {
        this.setSOAPMessage(soapMessage);
    }

    @Override
    public Object[] getHeaders(QName qname, JAXBContext context, boolean allRoles) {
        ArrayList<SOAPHeaderElement> headers = new ArrayList<SOAPHeaderElement>();
        if (this.getSOAPMessage() != null) {
            try {
                SOAPHeader soapHeader = this.getSOAPMessage().getSOAPHeader();
                Iterator headerElements = soapHeader.examineAllHeaderElements();
                while (headerElements.hasNext()) {
                    URI actor;
                    SOAPHeaderElement hElement = (SOAPHeaderElement)headerElements.next();
                    Name hName = hElement.getElementName();
                    if (!qname.equals(new QName(hName.getURI(), hName.getLocalName())) || !this.roles.contains(actor = new URI(hElement.getActor())) && !allRoles) continue;
                    headers.add(hElement);
                }
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new WebServiceException("Cannot get headers", ex);
            }
        }
        Object[] arr = new Object[headers.size()];
        headers.toArray(arr);
        return arr;
    }

    @Override
    public Set<String> getRoles() {
        return this.roles;
    }
}

