/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.eventing.mgmt;

import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.utils.DefaultErrorHandler;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;
import org.jboss.ws.WSException;
import org.jboss.ws.core.utils.DOMUtils;
import org.jboss.ws.core.utils.DOMWriter;
import org.jboss.ws.core.utils.ObjectNameFactory;
import org.jboss.ws.core.utils.UUIDGenerator;
import org.jboss.ws.extensions.eventing.deployment.EventingEndpointDI;
import org.jboss.ws.extensions.eventing.jaxws.AttributedURIType;
import org.jboss.ws.extensions.eventing.jaxws.EndpointReferenceType;
import org.jboss.ws.extensions.eventing.jaxws.ReferenceParametersType;
import org.jboss.ws.extensions.eventing.mgmt.DispatchException;
import org.jboss.ws.extensions.eventing.mgmt.DispatchJob;
import org.jboss.ws.extensions.eventing.mgmt.DispatcherDelegate;
import org.jboss.ws.extensions.eventing.mgmt.EventDispatcher;
import org.jboss.ws.extensions.eventing.mgmt.EventSource;
import org.jboss.ws.extensions.eventing.mgmt.EventingBuilder;
import org.jboss.ws.extensions.eventing.mgmt.Filter;
import org.jboss.ws.extensions.eventing.mgmt.NotificationFailure;
import org.jboss.ws.extensions.eventing.mgmt.Subscription;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionError;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerMBean;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionTicket;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionManager
implements SubscriptionManagerMBean,
EventDispatcher {
    private static final Logger log = Logger.getLogger(SubscriptionManager.class);
    public static final ObjectName OBJECT_NAME = ObjectNameFactory.create("jboss.ws:service=SubscriptionManager,module=eventing");
    private ConcurrentMap<URI, EventSource> eventSourceMapping = new ConcurrentHashMap<URI, EventSource>();
    private ConcurrentMap<URI, List<Subscription>> subscriptionMapping = new ConcurrentHashMap<URI, List<Subscription>>();
    private BlockingQueue<Runnable> eventQueue = new LinkedBlockingQueue<Runnable>();
    private ThreadPoolExecutor threadPool;
    private boolean isDispatcherBound = false;
    private WatchDog watchDog;
    private static EventingBuilder builder = EventingBuilder.createEventingBuilder();
    private List<NotificationFailure> notificationFailures = new ArrayList<NotificationFailure>();
    private boolean validateNotifications = false;

    public void create() throws Exception {
        MBeanServer server = this.getJMXServer();
        if (server != null) {
            if (log.isDebugEnabled()) {
                log.debug("Create subscription manager");
            }
            server.registerMBean(this, OBJECT_NAME);
        }
    }

    public void destroy() throws Exception {
        MBeanServer server = this.getJMXServer();
        if (server != null) {
            if (log.isDebugEnabled()) {
                log.debug("Destroy subscription manager");
            }
            server.unregisterMBean(OBJECT_NAME);
        }
    }

    public void start() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Start subscription manager");
        }
        this.threadPool = new ThreadPoolExecutor(5, 15, 5000L, TimeUnit.MILLISECONDS, this.eventQueue);
        this.watchDog = new WatchDog(this.subscriptionMapping);
        this.watchDog.startup();
    }

    public void stop() {
        if (log.isDebugEnabled()) {
            log.debug("Stop subscription manager");
        }
        try {
            Util.unbind((Context)new InitialContext(), "EventDispatcher");
            this.threadPool.shutdown();
            this.watchDog.shutdown();
            for (URI eventSourceNS : this.eventSourceMapping.keySet()) {
                this.removeEventSource(eventSourceNS);
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private static URI generateSubscriptionID() {
        try {
            return new URI("urn:jbwse:" + UUIDGenerator.generateRandomUUIDString());
        }
        catch (URISyntaxException e) {
            throw new WSException(e.getMessage());
        }
    }

    @Override
    public void registerEventSource(EventingEndpointDI deploymentInfo) {
        this.lazyBindEventDispatcher();
        EventSource eventSource = builder.newEventSource(deploymentInfo);
        if (!this.eventSourceMapping.containsKey(eventSource.getNameSpace())) {
            this.eventSourceMapping.put(eventSource.getNameSpace(), eventSource);
            SubscriptionManager.updateManagerAddress(deploymentInfo, eventSource);
            eventSource.setState(EventSource.State.CREATED);
            if (log.isDebugEnabled()) {
                log.debug("Created: " + eventSource);
            }
        } else {
            eventSource = (EventSource)this.eventSourceMapping.get(eventSource.getNameSpace());
            SubscriptionManager.updateManagerAddress(deploymentInfo, eventSource);
            this.subscriptionMapping.put(eventSource.getNameSpace(), new CopyOnWriteArrayList());
            eventSource.setState(EventSource.State.STARTED);
            if (log.isDebugEnabled()) {
                log.debug("Started: " + eventSource);
            }
        }
    }

    private void lazyBindEventDispatcher() {
        if (!this.isDispatcherBound) {
            try {
                Util.rebind((Context)new InitialContext(), "EventDispatcher", (Object)new DispatcherDelegate("localhost"));
                log.info("Bound event dispatcher to java:/EventDispatcher");
                this.isDispatcherBound = true;
            }
            catch (NamingException e) {
                throw new WSException("Unable to bind EventDispatcher ", e);
            }
        }
    }

    private static void updateManagerAddress(EventingEndpointDI deploymentInfo, EventSource eventSource) {
        String addr = null;
        if (deploymentInfo.getPortName().getLocalPart().equals("SubscriptionManagerPort")) {
            addr = deploymentInfo.getEndpointAddress();
        }
        if (addr != null) {
            eventSource.setManagerAddress(addr);
        }
    }

    @Override
    public void removeEventSource(URI eventSourceNS) {
        if (this.eventSourceMapping.containsKey(eventSourceNS)) {
            List subscriptions = (List)this.subscriptionMapping.get(eventSourceNS);
            for (Subscription s : subscriptions) {
                s.end("http://schemas.xmlsoap.org/ws/2004/08/eventing/SourceShuttingDown");
            }
            subscriptions.clear();
            this.eventSourceMapping.remove(eventSourceNS);
            if (log.isDebugEnabled()) {
                log.debug("Event source " + eventSourceNS + " removed");
            }
        }
    }

    @Override
    public SubscriptionTicket subscribe(URI eventSourceNS, EndpointReferenceType notifyTo, EndpointReferenceType endTo, Date expires, Filter filter) throws SubscriptionError {
        EventSource eventSource;
        if (log.isDebugEnabled()) {
            log.debug("Subscription request for " + eventSourceNS);
        }
        if (null == (eventSource = (EventSource)this.eventSourceMapping.get(eventSourceNS))) {
            throw new SubscriptionError("EventSourceUnableToProcess", "EventSource '" + eventSourceNS + "' not registered");
        }
        if (expires != null) {
            this.assertLeaseConstraints(expires);
        } else {
            expires = new Date(System.currentTimeMillis() + 300000L);
        }
        if (filter != null) {
            if (eventSource.getSupportedFilterDialects().isEmpty()) {
                throw new SubscriptionError("FilteringNotSupported", "Filtering is not supported.");
            }
            boolean filterAvailable = false;
            for (URI supportedDialect : eventSource.getSupportedFilterDialects()) {
                if (!filter.getDialect().equals(supportedDialect)) continue;
                filterAvailable = true;
                break;
            }
            if (!filterAvailable) {
                throw new SubscriptionError("FilteringRequestedUnavailable", "The requested filter dialect is not supported.");
            }
        }
        EndpointReferenceType epr = new EndpointReferenceType();
        AttributedURIType attrURI = new AttributedURIType();
        attrURI.setValue(eventSource.getManagerAddress().toString());
        epr.setAddress(attrURI);
        ReferenceParametersType refParam = new ReferenceParametersType();
        JAXBElement idqn = new JAXBElement(new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Identifier"), String.class, (Object)SubscriptionManager.generateSubscriptionID().toString());
        refParam.getAny().add(idqn);
        epr.setReferenceParameters(refParam);
        Subscription subscription = new Subscription(eventSource.getNameSpace(), epr, notifyTo, endTo, expires, filter);
        ((List)this.subscriptionMapping.get(eventSourceNS)).add(subscription);
        if (log.isDebugEnabled()) {
            log.debug("Registered subscription " + subscription.getIdentifier());
        }
        return new SubscriptionTicket(epr, subscription.getExpires());
    }

    private void assertLeaseConstraints(Date expireDate) throws SubscriptionError {
        long expires = expireDate.getTime() - System.currentTimeMillis();
        if (expires < 0L || 600000L < expires) {
            throw new SubscriptionError("InvalidExpirationTime", "The expiration time requested is invalid: " + expires + "ms");
        }
    }

    @Override
    public Date renew(URI identifier, Date lease) throws SubscriptionError {
        Subscription subscription = this.subscriberForID(identifier);
        if (null == subscription) {
            throw new SubscriptionError("UnableToRenew", "Subscription " + identifier + " does not exist");
        }
        if (lease != null) {
            this.assertLeaseConstraints(lease);
        } else {
            lease = new Date(System.currentTimeMillis() + 300000L);
        }
        subscription.setExpires(lease);
        return lease;
    }

    @Override
    public final Date getStatus(URI identifier) throws SubscriptionError {
        Subscription subscription = this.subscriberForID(identifier);
        if (null == subscription) {
            throw new SubscriptionError("EventSourceUnableToProcess", "Subscription " + identifier + " does not exist");
        }
        return subscription.getExpires();
    }

    @Override
    public void unsubscribe(URI identifier) throws SubscriptionError {
        block0: for (List subscriptions : this.subscriptionMapping.values()) {
            for (Subscription s : subscriptions) {
                if (!identifier.equals(s.getIdentifier())) continue;
                subscriptions.remove(s);
                if (!log.isDebugEnabled()) continue block0;
                log.debug("Removed subscription " + s);
                continue block0;
            }
        }
    }

    @Override
    public String showEventsourceTable() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<h3>Deployed Eventsources</h3>");
        pw.println("<table>");
        pw.println("<tr><td>Name</td><td>NS</td></tr>");
        for (EventSource source : this.eventSourceMapping.values()) {
            pw.println("<tr><td>" + source.getName() + "</td><td>" + source.getNameSpace() + "</td></tr>");
        }
        pw.println("</table>");
        pw.close();
        return sw.toString();
    }

    @Override
    public String showSubscriptionTable() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<h3>Registered Subscriptions</h3>");
        pw.println("<table>");
        pw.println("<tr><td>Identifier</td><td>Expires</td><td>Filter</td></tr>");
        for (List subscriptions : this.subscriptionMapping.values()) {
            for (Subscription s : subscriptions) {
                pw.println("<tr><td>" + s.getIdentifier() + "</td><td>" + s.getExpires() + "</td><td>" + s.getFilter().getExpression() + "</td></tr>");
            }
        }
        pw.println("</table>");
        pw.close();
        return sw.toString();
    }

    private Subscription subscriberForID(URI id) {
        Subscription subscription = null;
        block0: for (List subscriptions : this.subscriptionMapping.values()) {
            for (Subscription s : subscriptions) {
                if (!id.equals(s.getIdentifier())) continue;
                subscription = s;
                continue block0;
            }
        }
        return subscription;
    }

    @Override
    public void dispatch(URI eventSourceNS, Element payload) {
        DispatchJob dispatchJob = new DispatchJob(eventSourceNS, payload, this.subscriptionMapping);
        if (this.validateNotifications && !this.validateMessage(DOMWriter.printNode(payload, false), eventSourceNS)) {
            throw new DispatchException("Notification message validation failed!");
        }
        this.threadPool.execute(dispatchJob);
    }

    @Override
    public void addNotificationFailure(NotificationFailure failure) {
        this.notificationFailures.add(failure);
    }

    @Override
    public List<NotificationFailure> showNotificationFailures() {
        return this.notificationFailures;
    }

    private boolean validateMessage(String msg, URI eventSourceNS) {
        try {
            EventSource es = (EventSource)this.eventSourceMapping.get(eventSourceNS);
            log.info(new StringBuffer("Validating message: \n\n").append(msg).append("\n\nagainst the following schema(s): \n").toString());
            for (int i = 0; i < es.getNotificationSchema().length; ++i) {
                log.info(es.getNotificationSchema()[i]);
            }
            Element rootElement = DOMUtils.parse(msg);
            if (!es.getNotificationRootElementNS().equalsIgnoreCase(rootElement.getNamespaceURI())) {
                log.error("Root element expected namespace: " + es.getNotificationRootElementNS());
                return false;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            String[] notificationSchemas = es.getNotificationSchema();
            InputSource[] is = new InputSource[notificationSchemas.length];
            for (int i = 0; i < notificationSchemas.length; ++i) {
                is[i] = new InputSource(new StringReader(notificationSchemas[notificationSchemas.length - 1 - i]));
            }
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", is);
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Validator errorHandler = new Validator();
            docBuilder.setErrorHandler((ErrorHandler)((Object)errorHandler));
            docBuilder.parse(new InputSource(new StringReader(msg)));
            log.info("Document validated!");
            return true;
        }
        catch (Exception e) {
            log.error(e);
            log.info("Cannot validate and/or parse the document!");
            return false;
        }
    }

    @Override
    public int getCorePoolSize() {
        return this.threadPool.getCorePoolSize();
    }

    @Override
    public int getMaximumPoolSize() {
        return this.threadPool.getMaximumPoolSize();
    }

    @Override
    public int getLargestPoolSize() {
        return this.threadPool.getLargestPoolSize();
    }

    @Override
    public int getActiveCount() {
        return this.threadPool.getActiveCount();
    }

    @Override
    public long getCompletedTaskCount() {
        return this.threadPool.getCompletedTaskCount();
    }

    @Override
    public void setCorePoolSize(int corePoolSize) {
        this.threadPool.setCorePoolSize(corePoolSize);
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) {
        this.threadPool.setMaximumPoolSize(maxPoolSize);
    }

    @Override
    public void setEventKeepAlive(long millies) {
        this.threadPool.setKeepAliveTime(millies, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isValidateNotifications() {
        return this.validateNotifications;
    }

    @Override
    public void setValidateNotifications(boolean validateNotifications) {
        this.validateNotifications = validateNotifications;
    }

    private MBeanServer getJMXServer() {
        MBeanServer server = null;
        ArrayList servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.size() > 0) {
            server = (MBeanServer)servers.get(0);
        }
        return server;
    }

    private class Validator
    extends DefaultErrorHandler {
        private Validator() {
        }

        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(exception);
        }

        public void warning(SAXParseException exception) throws SAXException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WatchDog
    implements Runnable {
        private ConcurrentMap<URI, List<Subscription>> subscriptions;
        private boolean active = true;
        private Thread worker;

        public WatchDog(ConcurrentMap<URI, List<Subscription>> subscriptions) {
            this.subscriptions = subscriptions;
        }

        @Override
        public void run() {
            while (this.active) {
                for (List subscriptions : SubscriptionManager.this.subscriptionMapping.values()) {
                    for (Subscription s : subscriptions) {
                        if (!s.isExpired()) continue;
                        s.end("http://schemas.xmlsoap.org/ws/2004/08/eventing/SourceCanceling");
                        subscriptions.remove(s);
                    }
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    log.error(e);
                }
            }
        }

        public void startup() {
            this.worker = new Thread((Runnable)this, "SubscriptionWatchDog");
            this.worker.start();
        }

        public void shutdown() {
            this.active = false;
        }
    }
}

