/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import javax.xml.soap.FactoryLoader;
import org.jboss.ws.extensions.security.SecurityAssociationAdaptor;
import org.jboss.ws.extensions.security.SecurityAssociationAdaptorFactory;
import org.jboss.ws.extensions.security.SecurityStore;
import org.jboss.ws.extensions.security.SimplePrincipal;
import org.jboss.ws.extensions.security.TokenOperation;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.element.SecurityHeader;
import org.jboss.ws.extensions.security.element.Token;
import org.jboss.ws.extensions.security.element.UsernameToken;
import org.w3c.dom.Document;

public class ReceiveUsernameOperation
implements TokenOperation {
    private SecurityHeader header;
    private SecurityStore store;

    public ReceiveUsernameOperation(SecurityHeader header, SecurityStore store) {
        this.header = header;
        this.store = store;
    }

    public void process(Document message, Token token) throws WSSecurityException {
        UsernameToken user = (UsernameToken)token;
        String propName = SecurityAssociationAdaptorFactory.class.getName();
        SecurityAssociationAdaptorFactory factory = (SecurityAssociationAdaptorFactory)FactoryLoader.loadFactory((String)propName, null);
        if (factory == null) {
            throw new WSSecurityException("Cannot load: " + propName);
        }
        SecurityAssociationAdaptor securityAdaptor = factory.getSecurityAssociationAdaptor();
        securityAdaptor.setPrincipal(new SimplePrincipal(user.getUsername()));
        securityAdaptor.setCredential(user.getPassword());
    }
}

