/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.tools.Configuration;
import org.jboss.ws.tools.config.ToolsSchemaConfigReader;
import org.jboss.ws.tools.helpers.ToolsHelper;

public class WSTools {
    private static Logger log = Logger.getLogger(WSTools.class);

    public static void main(String[] args) throws IOException {
        WSTools tools = new WSTools();
        tools.generate(args);
    }

    public boolean generate(String configLocation, String outputDir) throws IOException {
        ToolsSchemaConfigReader configReader = new ToolsSchemaConfigReader();
        Configuration config = configReader.readConfig(configLocation);
        return this.process(config, outputDir);
    }

    public boolean generate(String[] args) throws IOException {
        String configLocation = null;
        String outputDir = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("-config".equals(arg)) {
                configLocation = args[i + 1];
                ++i;
                continue;
            }
            if ("-dest".equals(arg)) {
                outputDir = args[i + 1];
                ++i;
                continue;
            }
            if ("-classpath".equals(arg) || "-cp".equals(arg)) {
                StringTokenizer st = new StringTokenizer(args[i + 1], File.pathSeparator);
                int tokens = st.countTokens();
                URL[] urls = new URL[tokens];
                for (int j = 0; j < tokens; ++j) {
                    String token = st.nextToken();
                    urls[j] = new File(token).toURL();
                }
                ClassLoader ctxLoader = Thread.currentThread().getContextClassLoader();
                URLClassLoader urlLoader = new URLClassLoader(urls, ctxLoader);
                Thread.currentThread().setContextClassLoader(urlLoader);
                ++i;
                continue;
            }
            System.out.println("Usage: wstools (-classpath|-cp) <classpath> -config <config> [-dest <destination path>]");
            System.exit(1);
        }
        return this.generate(configLocation, outputDir);
    }

    private boolean process(Configuration config, String outputDir) throws IOException {
        if (config == null) {
            throw new IllegalArgumentException("Configuration is null");
        }
        if (outputDir == null) {
            outputDir = ".";
        }
        ToolsHelper helper = new ToolsHelper();
        if (config.getJavaToWSDLConfig(false) != null) {
            helper.handleJavaToWSDLGeneration(config, outputDir);
        } else if (config.getWSDLToJavaConfig(false) != null) {
            helper.handleWSDLToJavaGeneration(config, outputDir);
        } else {
            throw new WSException("Nothing done, Configuration source must have JavaToWSDL or WSDLToJava specified");
        }
        return true;
    }
}

