/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.lang.reflect.Array;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.Constants;
import org.jboss.xb.binding.JBossXBRuntimeException;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TypeBinding;

public abstract class CharactersHandler {
    public static CharactersHandler NOOP = new CharactersHandler(){

        public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
            return value;
        }
    };
    public static CharactersHandler DEFAULT = new CharactersHandler(){};

    public Object unmarshalEmpty(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData) {
        Object result = null;
        QName typeQName = typeBinding.getQName();
        if (Constants.QNAME_STRING.equals(typeQName)) {
            result = "";
        } else if (Constants.QNAME_BASE64BINARY.equals(typeQName)) {
            result = new byte[0];
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object unmarshal(QName qName, TypeBinding typeBinding, NamespaceContext nsCtx, ValueMetaData valueMetaData, String value) {
        QName typeQName = typeBinding.getQName();
        TypeBinding itemType = typeBinding.getItemType();
        if (itemType != null) {
            QName itemTypeQName = itemType.getQName();
            if (itemTypeQName == null) throw new JBossXBRuntimeException("Only list types with item type from http://www.w3.org/2001/XMLSchema namespace are supported currently.");
            if (!"http://www.w3.org/2001/XMLSchema".equals(itemTypeQName.getNamespaceURI())) throw new JBossXBRuntimeException("Only list types with item type from http://www.w3.org/2001/XMLSchema namespace are supported currently.");
            List list2 = SimpleTypeBindings.unmarshalList(itemTypeQName.getLocalPart(), value, nsCtx);
            if (!typeBinding.getSchemaBinding().isUnmarshalListsToArrays()) return list2;
            if (list2.isEmpty()) {
                Class compType = SimpleTypeBindings.classForType(itemTypeQName.getLocalPart(), true);
                return Array.newInstance(compType, 0);
            }
            Class<?> compType = list2.get(0).getClass();
            return list2.toArray((Object[])Array.newInstance(compType, list2.size()));
        }
        if (typeQName == null || !"http://www.w3.org/2001/XMLSchema".equals(typeQName.getNamespaceURI())) TypeBinding baseType;
        return (baseType = typeBinding.getBaseType()) == null ? value : this.unmarshal(qName, baseType, nsCtx, valueMetaData, value);
        try {
            return SimpleTypeBindings.unmarshal(typeQName.getLocalPart(), value, nsCtx);
        }
        catch (IllegalStateException e) {
            throw new JBossXBRuntimeException("Characters are not allowed here", e);
        }
    }

    public void setValue(QName qName, ElementBinding element, Object owner, Object value) {
    }
}

