//$Id: WorkType.java 14300 2008-01-30 22:47:58Z epbernard $
package org.hibernate.search.backend;

/**
 * Enumeration of the different types of Lucene work. This enumeration is used to specify the type
 * of index operation to be executed. 
 * 
 * @author Emmanuel Bernard
 * @author Hardy Ferentschik
 * @author John Griffin
 */
public enum WorkType {
	ADD,
	UPDATE,
	DELETE,
	COLLECTION,
	/**
	 * Used to remove a specific instance
	 * of a class from an index.
	 */
	PURGE,
	/**
	 * Used to remove all instances of a
	 * class from an index.
	 */
	PURGE_ALL,
	
	/**
	 * This type is used for batch indexing.
	 */
	INDEX 
}
