// $Id: FilterCachingStrategy.java 14012 2007-09-16 19:57:36Z hardy.ferentschik $
package org.hibernate.search.filter;

import java.util.Properties;

import org.apache.lucene.search.Filter;

/**
 * Defines the caching filter strategy
 *
 * @author Emmanuel Bernard
 */
public interface FilterCachingStrategy {
	/**
	 * initialize the strategy from the properties
	 * The Properties must not be changed
	 */
	void initialize(Properties properties);
	/**
	 * Retrieve the cached filter for a given key or null if not cached
	 */
	Filter getCachedFilter(FilterKey key);

	/**
	 * Propose a candidate filter for caching
	 */
	void addCachedFilter(FilterKey key, Filter filter);
}
