// $Id: MRUFilterCachingStrategy.java 14012 2007-09-16 19:57:36Z hardy.ferentschik $
package org.hibernate.search.filter;

import java.util.Properties;

import org.apache.lucene.search.Filter;
import org.hibernate.search.Environment;
import org.hibernate.search.SearchException;
import org.hibernate.util.SoftLimitMRUCache;

/**
 * Keep the most recently used Filters in the cache
 * The cache is at least as big as <code>hibernate.search.filter.cache_strategy.size</code>
 * Above this limit, Filters are kept as soft references
 *
 * @author Emmanuel Bernard
 */
public class MRUFilterCachingStrategy implements FilterCachingStrategy {
	private static final String DEFAULT_SIZE = "128";
	private SoftLimitMRUCache cache;
	private static final String SIZE = Environment.FILTER_CACHING_STRATEGY + ".size";

	public void initialize(Properties properties) {
		int size;
		try {
			size = Integer.parseInt(
					properties.getProperty( SIZE, DEFAULT_SIZE )
			);
		}
		catch (NumberFormatException nfe) {
			throw new SearchException(
					"Unable to parse " + SIZE + ": " + properties.getProperty( SIZE, DEFAULT_SIZE ), nfe
			);
		}

		cache = new SoftLimitMRUCache( size );
	}

	public Filter getCachedFilter(FilterKey key) {
		return (Filter) cache.get( key );
	}

	public void addCachedFilter(FilterKey key, Filter filter) {
		cache.put( key, filter );
	}
}
