//$Id: Tower.java 11625 2007-06-04 16:21:54Z epbernard $
package org.hibernate.search.test.embedded;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.ManyToOne;

import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;

/**
 * @author Emmanuel Bernard
 */
@Entity
@Indexed
public class Tower {
	@Id
	@GeneratedValue
	@DocumentId
	private Long id;

	@Field( index = Index.TOKENIZED )
	private String name;

	@ManyToOne( cascade = { CascadeType.PERSIST, CascadeType.REMOVE } )
	@IndexedEmbedded
	private Address address;


	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Address getAddress() {
		return address;
	}

	public void setAddress(Address address) {
		this.address = address;
	}
}
