//$Id: $
package org.hibernate.search.test.query;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;

import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;

@Entity
@Indexed()
public class Music {
	protected Long id;
	protected String title;
	protected Set<Author> authors = new HashSet<Author>();

	@Id
	@GeneratedValue
	@DocumentId
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	/**
	 * @return the singers
	 */
	@ManyToMany( cascade = CascadeType.ALL,
			fetch = FetchType.EAGER,
			targetEntity = Author.class )
	@IndexedEmbedded( depth = 1 )
	public Set<Author> getAuthors() {
		return authors;
	}

	/**
	 * @param authors the authors to set
	 */
	public void setAuthors(Set<Author> authors) {
		this.authors = authors;
	}

	public void addAuthor(Author author) {
		this.getAuthors().add( author );
	}

	/**
	 * @return the title
	 */
	@Column( name = "title",
			length = 255,
			nullable = false )
	@Field( name = "title",
			index = Index.TOKENIZED,
			store = Store.YES )
	public String getTitle() {
		return title;
	}

	/**
	 * @param title the title to set
	 */
	public void setTitle(String title) {
		this.title = title;
	}
}
