/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.action.EntityAction;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.PostInsertEvent;
import org.hibernate.event.PostInsertEventListener;
import org.hibernate.event.PreInsertEvent;
import org.hibernate.event.PreInsertEventListener;
import org.hibernate.persister.entity.EntityPersister;

public final class EntityIdentityInsertAction
extends EntityAction {
    private final Object[] state;
    private Serializable generatedId;

    public EntityIdentityInsertAction(Object[] state, Object instance, EntityPersister persister, SessionImplementor session) throws HibernateException {
        super(session, null, instance, persister);
        this.state = state;
    }

    public void execute() throws HibernateException {
        EntityPersister persister = this.getPersister();
        SessionImplementor session = this.getSession();
        Object instance = this.getInstance();
        boolean veto = this.preInsert();
        if (!veto) {
            this.generatedId = persister.insert(this.state, instance, session);
            if (persister.hasGeneratedProperties()) {
                persister.retrieveGeneratedProperties(this.generatedId, instance, this.state, session);
            }
        }
        this.postInsert();
        if (session.getFactory().getStatistics().isStatisticsEnabled() && !veto) {
            session.getFactory().getStatisticsImplementor().insertEntity(this.getPersister().getEntityName());
        }
    }

    private void postInsert() {
        PostInsertEventListener[] postListeners = this.getSession().getListeners().getPostInsertEventListeners();
        if (postListeners.length > 0) {
            PostInsertEvent postEvent = new PostInsertEvent(this.getInstance(), this.generatedId, this.state, this.getPersister());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostInsert(postEvent);
            }
        }
    }

    private void postCommitInsert() {
        PostInsertEventListener[] postListeners = this.getSession().getListeners().getPostCommitInsertEventListeners();
        if (postListeners.length > 0) {
            PostInsertEvent postEvent = new PostInsertEvent(this.getInstance(), this.generatedId, this.state, this.getPersister());
            for (int i = 0; i < postListeners.length; ++i) {
                postListeners[i].onPostInsert(postEvent);
            }
        }
    }

    private boolean preInsert() {
        PreInsertEventListener[] preListeners = this.getSession().getListeners().getPreInsertEventListeners();
        boolean veto = false;
        if (preListeners.length > 0) {
            PreInsertEvent preEvent = new PreInsertEvent(this.getInstance(), null, this.state, this.getPersister(), this.getSession());
            for (int i = 0; i < preListeners.length; ++i) {
                veto = preListeners[i].onPreInsert(preEvent) || veto;
            }
        }
        return veto;
    }

    public void afterTransactionCompletion(boolean success) throws HibernateException {
        this.postCommitInsert();
    }

    public boolean hasAfterTransactionCompletion() {
        return this.hasPostCommitEventListeners();
    }

    protected boolean hasPostCommitEventListeners() {
        return this.getSession().getListeners().getPostCommitInsertEventListeners().length > 0;
    }

    public final Serializable getGeneratedId() {
        return this.generatedId;
    }
}

