/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import antlr.RecognitionException;
import antlr.collections.AST;
import java.sql.PreparedStatement;
import org.apache.commons.logging.Log;
import org.hibernate.HibernateException;
import org.hibernate.action.BulkOperationCleanupAction;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.exec.StatementExecutor;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.InsertSelect;
import org.hibernate.sql.Select;
import org.hibernate.sql.SelectFragment;
import org.hibernate.util.StringHelper;

public abstract class AbstractStatementExecutor
implements StatementExecutor {
    private final Log log;
    private final HqlSqlWalker walker;

    public AbstractStatementExecutor(HqlSqlWalker walker, Log log) {
        this.walker = walker;
        this.log = log;
    }

    protected HqlSqlWalker getWalker() {
        return this.walker;
    }

    protected SessionFactoryImplementor getFactory() {
        return this.walker.getSessionFactoryHelper().getFactory();
    }

    protected abstract Queryable[] getAffectedQueryables();

    protected String generateIdInsertSelect(Queryable persister, AST whereClause) {
        Select select = new Select(this.getFactory().getDialect());
        String tableAlias = "del";
        SelectFragment selectFragment = new SelectFragment().addColumns(tableAlias, persister.getIdentifierColumnNames(), persister.getIdentifierColumnNames());
        select.setSelectClause(selectFragment.toFragmentString().substring(2));
        select.setFromClause(persister.getTableName() + ' ' + tableAlias + persister.fromJoinFragment(tableAlias, true, false));
        String userWhereClause = "";
        if (whereClause.getNumberOfChildren() != 0) {
            try {
                SqlGenerator sqlGenerator = new SqlGenerator(this.getFactory());
                sqlGenerator.whereClause(whereClause);
                userWhereClause = sqlGenerator.getSQL().substring(7);
            }
            catch (RecognitionException e) {
                throw new HibernateException("Unable to generate id select for DML operation", e);
            }
        }
        select.setWhereClause(persister.whereJoinFragment(tableAlias, true, false) + userWhereClause);
        InsertSelect insert = new InsertSelect(this.getFactory().getDialect());
        if (this.getFactory().getSettings().isCommentsEnabled() && this.getFactory().getDialect().supportsCommentOn()) {
            insert.setComment("insert-select for " + persister.getEntityName() + " ids");
        }
        insert.setTableName(persister.getTemporaryIdTableName());
        insert.setSelect(select);
        return insert.toStatementString();
    }

    protected String generateIdSubselect(Queryable persister) {
        return "select " + StringHelper.join(", ", persister.getIdentifierColumnNames()) + " from " + persister.getTemporaryIdTableName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void createTemporaryTableIfNecessary(Queryable persister, SessionImplementor session) {
        PreparedStatement ps = null;
        ps = session.getBatcher().prepareStatement(persister.getTemporaryIdTableDDL());
        ps.executeUpdate();
        Object var6_4 = null;
        if (ps == null) return;
        try {
            session.getBatcher().closeStatement(ps);
            return;
        }
        catch (Throwable ignore) {}
        return;
        {
            catch (Throwable t) {
                this.log.debug((Object)("unable to create temporary id table [" + t.getMessage() + "]"));
                Object var6_5 = null;
                if (ps == null) return;
                try {
                    session.getBatcher().closeStatement(ps);
                    return;
                }
                catch (Throwable ignore) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (ps == null) throw throwable;
            try {
                session.getBatcher().closeStatement(ps);
                throw throwable;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void dropTemporaryTableIfNecessary(Queryable persister, SessionImplementor session) {
        if (!this.getFactory().getDialect().dropTemporaryTableAfterUse()) return;
        PreparedStatement ps = null;
        ps = session.getBatcher().prepareStatement("drop table " + persister.getTemporaryIdTableName());
        ps.executeUpdate();
        Object var6_4 = null;
        if (ps == null) return;
        try {
            session.getBatcher().closeStatement(ps);
            return;
        }
        catch (Throwable ignore) {}
        return;
        {
            catch (Throwable t) {
                this.log.warn((Object)"unable to drop temporary id table after use", t);
                Object var6_5 = null;
                if (ps == null) return;
                try {
                    session.getBatcher().closeStatement(ps);
                    return;
                }
                catch (Throwable ignore) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (ps == null) throw throwable;
            try {
                session.getBatcher().closeStatement(ps);
                throw throwable;
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            throw throwable;
        }
    }

    protected void coordinateSharedCacheCleanup(SessionImplementor session) {
        BulkOperationCleanupAction action = new BulkOperationCleanupAction(session, this.getAffectedQueryables());
        action.init();
        if (session.isEventSource()) {
            ((EventSource)session).getActionQueue().addAction(action);
        }
    }
}

