/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.hibernate.EntityMode;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.MetaAttributable;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Value;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class Property
implements Serializable,
MetaAttributable {
    private String name;
    private Value value;
    private String cascade;
    private boolean updateable = true;
    private boolean insertable = true;
    private boolean selectable = true;
    private boolean optimisticLocked = true;
    private boolean generated = false;
    private String propertyAccessorName;
    private boolean lazy;
    private boolean optional;
    private String nodeName;
    private Map metaAttributes;
    private PersistentClass persistentClass;
    private boolean naturalIdentifier;

    public boolean isBackRef() {
        return false;
    }

    public Type getType() throws MappingException {
        return this.value.getType();
    }

    public int getColumnSpan() {
        return this.value.getColumnSpan();
    }

    public Iterator getColumnIterator() {
        return this.value.getColumnIterator();
    }

    public String getName() {
        return this.name;
    }

    public boolean isComposite() {
        return this.value instanceof Component;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean isPrimitive(Class clazz) {
        return this.getGetter(clazz).getReturnType().isPrimitive();
    }

    public CascadeStyle getCascadeStyle() throws MappingException {
        Type type = this.value.getType();
        if (type.isComponentType() && !type.isAnyType()) {
            AbstractComponentType actype = (AbstractComponentType)type;
            int length = actype.getSubtypes().length;
            for (int i = 0; i < length; ++i) {
                if (actype.getCascadeStyle(i) == CascadeStyle.NONE) continue;
                return CascadeStyle.ALL;
            }
            return CascadeStyle.NONE;
        }
        if (this.cascade == null || this.cascade.equals("none")) {
            return CascadeStyle.NONE;
        }
        StringTokenizer tokens = new StringTokenizer(this.cascade, ", ");
        CascadeStyle[] styles = new CascadeStyle[tokens.countTokens()];
        int i = 0;
        while (tokens.hasMoreTokens()) {
            styles[i++] = CascadeStyle.getCascadeStyle(tokens.nextToken());
        }
        return new CascadeStyle.MultipleCascadeStyle(styles);
    }

    public String getCascade() {
        return this.cascade;
    }

    public void setCascade(String cascade) {
        this.cascade = cascade;
    }

    public void setName(String name) {
        this.name = name == null ? null : name.intern();
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public boolean isUpdateable() {
        boolean[] columnUpdateability = this.value.getColumnUpdateability();
        return this.updateable && !ArrayHelper.isAllFalse(columnUpdateability);
    }

    public boolean isInsertable() {
        boolean[] columnInsertability = this.value.getColumnInsertability();
        return this.insertable && (columnInsertability.length == 0 || !ArrayHelper.isAllFalse(columnInsertability));
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public void setUpdateable(boolean mutable) {
        this.updateable = mutable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public String getPropertyAccessorName() {
        return this.propertyAccessorName;
    }

    public void setPropertyAccessorName(String string) {
        this.propertyAccessorName = string;
    }

    boolean isNullable() {
        return this.value == null || this.value.isNullable();
    }

    public boolean isBasicPropertyAccessor() {
        return this.propertyAccessorName == null || "property".equals(this.propertyAccessorName);
    }

    public Map getMetaAttributes() {
        return this.metaAttributes;
    }

    public MetaAttribute getMetaAttribute(String attributeName) {
        return (MetaAttribute)this.metaAttributes.get(attributeName);
    }

    public void setMetaAttributes(Map metas) {
        this.metaAttributes = metas;
    }

    public boolean isValid(Mapping mapping) throws MappingException {
        return this.getValue().isValid(mapping);
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.name + ')';
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public boolean isOptimisticLocked() {
        return this.optimisticLocked;
    }

    public void setOptimisticLocked(boolean optimisticLocked) {
        this.optimisticLocked = optimisticLocked;
    }

    public boolean isOptional() {
        return this.optional || this.isNullable();
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public PersistentClass getPersistentClass() {
        return this.persistentClass;
    }

    public void setPersistentClass(PersistentClass persistentClass) {
        this.persistentClass = persistentClass;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getAccessorPropertyName(EntityMode mode) {
        if (mode == EntityMode.DOM4J) {
            return this.nodeName;
        }
        return this.getName();
    }

    public Getter getGetter(Class clazz) throws PropertyNotFoundException, MappingException {
        return this.getPropertyAccessor(clazz).getGetter(clazz, this.name);
    }

    public Setter getSetter(Class clazz) throws PropertyNotFoundException, MappingException {
        return this.getPropertyAccessor(clazz).getSetter(clazz, this.name);
    }

    public PropertyAccessor getPropertyAccessor(Class clazz) throws MappingException {
        return PropertyAccessorFactory.getPropertyAccessor(clazz, this.getPropertyAccessorName());
    }

    public boolean isNaturalIdentifier() {
        return this.naturalIdentifier;
    }

    public void setNaturalIdentifier(boolean naturalIdentifier) {
        this.naturalIdentifier = naturalIdentifier;
    }
}

