/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import org.hibernate.engine.CascadeStyle;
import org.hibernate.tuple.Property;
import org.hibernate.type.Type;

public class StandardProperty
extends Property {
    private final boolean lazy;
    private final boolean insertable;
    private final boolean updateable;
    private final boolean generated;
    private final boolean nullable;
    private final boolean dirtyCheckable;
    private final boolean versionable;
    private final CascadeStyle cascadeStyle;

    public StandardProperty(String name, String node, Type type, boolean lazy, boolean insertable, boolean updateable, boolean generated, boolean nullable, boolean checkable, boolean versionable, CascadeStyle cascadeStyle) {
        super(name, node, type);
        this.lazy = lazy;
        this.insertable = insertable;
        this.updateable = updateable;
        this.generated = generated;
        this.nullable = nullable;
        this.dirtyCheckable = checkable;
        this.versionable = versionable;
        this.cascadeStyle = cascadeStyle;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isUpdateable() {
        return this.updateable;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isDirtyCheckable(boolean hasUninitializedProperties) {
        return this.isDirtyCheckable() && (!hasUninitializedProperties || !this.isLazy());
    }

    public boolean isDirtyCheckable() {
        return this.dirtyCheckable;
    }

    public boolean isVersionable() {
        return this.versionable;
    }

    public CascadeStyle getCascadeStyle() {
        return this.cascadeStyle;
    }
}

