/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.ForeignKeys;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;

public class ManyToOneType
extends EntityType {
    private final boolean ignoreNotFound;

    protected boolean isNullable() {
        return this.ignoreNotFound;
    }

    public boolean isAlwaysDirtyChecked() {
        return this.ignoreNotFound;
    }

    public int getColumnSpan(Mapping mapping) throws MappingException {
        return this.getIdentifierOrUniqueKeyType(mapping).getColumnSpan(mapping);
    }

    public int[] sqlTypes(Mapping mapping) throws MappingException {
        return this.getIdentifierOrUniqueKeyType(mapping).sqlTypes(mapping);
    }

    public ManyToOneType(String className) {
        this(className, false);
    }

    public ManyToOneType(String className, boolean lazy) {
        super(className, null, !lazy, true, false);
        this.ignoreNotFound = false;
    }

    public ManyToOneType(String className, String uniqueKeyPropertyName, boolean lazy, boolean unwrapProxy, boolean isEmbeddedInXML, boolean ignoreNotFound) {
        super(className, uniqueKeyPropertyName, !lazy, isEmbeddedInXML, unwrapProxy);
        this.ignoreNotFound = ignoreNotFound;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, boolean[] settable, SessionImplementor session) throws HibernateException, SQLException {
        this.getIdentifierOrUniqueKeyType(session.getFactory()).nullSafeSet(st, this.getIdentifier(value, session), index, settable, session);
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
        this.getIdentifierOrUniqueKeyType(session.getFactory()).nullSafeSet(st, this.getIdentifier(value, session), index, session);
    }

    public boolean isOneToOne() {
        return false;
    }

    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT;
    }

    public Object hydrate(ResultSet rs, String[] names, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        Serializable id = (Serializable)this.getIdentifierOrUniqueKeyType(session.getFactory()).nullSafeGet(rs, names, session, null);
        if (id != null) {
            this.scheduleBatchLoad(id, session);
        }
        return id;
    }

    private void scheduleBatchLoad(Serializable id, SessionImplementor session) throws MappingException {
        if (this.uniqueKeyPropertyName == null) {
            EntityPersister persister = session.getFactory().getEntityPersister(this.getAssociatedEntityName());
            EntityKey entityKey = new EntityKey(id, persister, session.getEntityMode());
            session.getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(entityKey);
        }
    }

    public boolean useLHSPrimaryKey() {
        return false;
    }

    public boolean isModified(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        if (current == null) {
            return old != null;
        }
        if (old == null) {
            return current != null;
        }
        return this.getIdentifierOrUniqueKeyType(session.getFactory()).isDirty(old, this.getIdentifier(current, session), session);
    }

    public Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (this.isNotEmbedded(session)) {
            return this.getIdentifierType(session).disassemble(value, session, owner);
        }
        if (value == null) {
            return null;
        }
        Serializable id = ForeignKeys.getEntityIdentifierIfNotUnsaved(this.getAssociatedEntityName(), value, session);
        if (id == null) {
            throw new AssertionFailure("cannot cache a reference to an object with a null id: " + this.getAssociatedEntityName());
        }
        return this.getIdentifierType(session).disassemble(id, session, owner);
    }

    public Object assemble(Serializable oid, SessionImplementor session, Object owner) throws HibernateException {
        Serializable id = this.assembleId(oid, session);
        if (this.isNotEmbedded(session)) {
            return id;
        }
        if (id == null) {
            return null;
        }
        return this.resolveIdentifier(id, session);
    }

    private Serializable assembleId(Serializable oid, SessionImplementor session) {
        return (Serializable)this.getIdentifierType(session).assemble(oid, session, null);
    }

    public void beforeAssemble(Serializable oid, SessionImplementor session) {
        if (this.uniqueKeyPropertyName == null && oid != null) {
            EntityPersister persister = session.getFactory().getEntityPersister(this.getAssociatedEntityName());
            EntityKey key = new EntityKey(this.assembleId(oid, session), persister, session.getEntityMode());
            session.getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(key);
        }
    }

    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        boolean[] result = new boolean[this.getColumnSpan(mapping)];
        if (value != null) {
            Arrays.fill(result, true);
        }
        return result;
    }

    public boolean isDirty(Object old, Object current, SessionImplementor session) throws HibernateException {
        if (this.isSame(old, current, session.getEntityMode())) {
            return false;
        }
        Object oldid = this.getIdentifier(old, session);
        Object newid = this.getIdentifier(current, session);
        return this.getIdentifierType(session).isDirty(oldid, newid, session);
    }

    public boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) throws HibernateException {
        if (this.isAlwaysDirtyChecked()) {
            return this.isDirty(old, current, session);
        }
        if (this.isSame(old, current, session.getEntityMode())) {
            return false;
        }
        Object oldid = this.getIdentifier(old, session);
        Object newid = this.getIdentifier(current, session);
        return this.getIdentifierType(session).isDirty(oldid, newid, checkable, session);
    }
}

