/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.impl.QueryImpl;
import org.hibernate.impl.SQLQueryImpl;
import org.hibernate.impl.SessionFactoryImpl;

public abstract class AbstractSessionImpl
implements SessionImplementor {
    protected transient SessionFactoryImpl factory;

    protected AbstractSessionImpl(SessionFactoryImpl factory) {
        this.factory = factory;
    }

    public Query getNamedQuery(String queryName) throws MappingException {
        AbstractQueryImpl query;
        NamedQueryDefinition nqd = this.factory.getNamedQuery(queryName);
        if (nqd != null) {
            String queryString = nqd.getQueryString();
            QueryImpl query1 = new QueryImpl(queryString, nqd.getFlushMode(), this);
            query = query1;
            query.setComment("named HQL query " + queryName);
        } else {
            NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
            if (nsqlqd == null) {
                throw new MappingException("Named query not known: " + queryName);
            }
            query = new SQLQueryImpl(nsqlqd, (SessionImplementor)this);
            query.setComment("named native SQL query " + queryName);
            nqd = nsqlqd;
        }
        this.initQuery(query, nqd);
        return query;
    }

    public Query getNamedSQLQuery(String queryName) throws MappingException {
        NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
        if (nsqlqd == null) {
            throw new MappingException("Named SQL query not known: " + queryName);
        }
        SQLQueryImpl query = new SQLQueryImpl(nsqlqd, (SessionImplementor)this);
        query.setComment("named native SQL query " + queryName);
        this.initQuery(query, nsqlqd);
        return query;
    }

    private void initQuery(Query query, NamedQueryDefinition nqd) {
        query.setCacheable(nqd.isCacheable());
        query.setCacheRegion(nqd.getCacheRegion());
        if (nqd.getTimeout() != null) {
            query.setTimeout(nqd.getTimeout());
        }
        if (nqd.getFetchSize() != null) {
            query.setFetchSize(nqd.getFetchSize());
        }
        if (nqd.getCacheMode() != null) {
            query.setCacheMode(nqd.getCacheMode());
        }
        query.setReadOnly(nqd.isReadOnly());
        if (nqd.getComment() != null) {
            query.setComment(nqd.getComment());
        }
    }
}

