// $Id: EntityMode.java,v 1.3 2005/08/08 23:24:42 oneovthafew Exp $
package org.hibernate;

import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;

/**
 * Defines the representation modes available for entities.
 *
 * @author Steve Ebersole
 */
public class EntityMode implements Serializable {

	private static final Map INSTANCES = new HashMap();

	public static final EntityMode POJO = new EntityMode( "POJO" );
	public static final EntityMode DOM4J = new EntityMode( "DOM4J" );
	public static final EntityMode MAP = new EntityMode( "MAP" );

	static {
		INSTANCES.put( POJO.name, POJO );
		INSTANCES.put( DOM4J.name, DOM4J );
		INSTANCES.put( MAP.name, MAP );
	}

	private final String name;

	public EntityMode(String name) {
		this.name = name;
	}

	public String toString() {
		return name;
	}

	private Object readResolve() {
		return INSTANCES.get( name );
	}

	public static EntityMode parse(String name) {
		EntityMode rtn = ( EntityMode ) INSTANCES.get( name );
		if ( rtn == null ) {
			// default is POJO
			rtn = POJO;
		}
		return rtn;
	}
}
