package org.hibernate.mapping;

import java.io.Serializable;

/**
 * Indicates whether given properties are generated by the database and, if
 * so, at what time(s) they are generated.
 *
 * @author <a href="mailto:steve@hibernate.org">Steve Ebersole </a>
 */
public class PropertyGeneration implements Serializable {

	/**
	 * Values for this property are never generated by the database.
	 */
	public static final PropertyGeneration NEVER = new PropertyGeneration( "never" );
	/**
	 * Values for this property are generated by the database on insert.
	 */
	public static final PropertyGeneration INSERT = new PropertyGeneration( "insert" );
	/**
	 * Values for this property are generated by the database on both insert and update.
	 */
	public static final PropertyGeneration ALWAYS = new PropertyGeneration( "always" );

	private final String name;

	private PropertyGeneration(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public static PropertyGeneration parse(String name) {
		if ( "insert".equalsIgnoreCase( name ) ) {
			return INSERT;
		}
		else if ( "always".equalsIgnoreCase( name ) ) {
			return ALWAYS;
		}
		else {
			return NEVER;
		}
	}

	private Object readResolve() {
		return parse( name );
	}
}
