// $Id: VersionTypeSeedParameterSpecification.java,v 1.3 2005/10/14 17:20:55 steveebersole Exp $
package org.hibernate.param;

import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.VersionType;
import org.hibernate.type.Type;
import org.hibernate.param.ParameterSpecification;

import java.sql.PreparedStatement;
import java.sql.SQLException;

/**
 * Implementation of VersionTypeSeedParameterSpecification.
 *
 * @author Steve Ebersole
 */
public class VersionTypeSeedParameterSpecification implements ParameterSpecification {

	private VersionType type;

	public VersionTypeSeedParameterSpecification(VersionType type) {
		this.type = type;
	}

	/**
	 * @see org.hibernate.param.ParameterSpecification#bind
	 */
	public int bind(PreparedStatement statement, QueryParameters qp, SessionImplementor session, int position)
	        throws SQLException {
		type.nullSafeSet( statement, type.seed( session ), position, session );
		return 1;
	}

	public Type getExpectedType() {
		return type;
	}

	public void setExpectedType(Type expectedType) {
		// expected type is intrinsic here...
	}
}
