/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.User;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.WrapperIterator;

final class DINameSpace {
    private Database database;
    private String catalogName;
    private static HashSet builtin = new HashSet();

    public DINameSpace(Database database) throws HsqlException {
        try {
            this.database = database;
            this.catalogName = database.getURI();
        }
        catch (Exception exception) {
            Trace.throwerror(40, exception.toString());
        }
    }

    Class classForMethodFQN(String string) {
        try {
            return this.classForName(string.substring(0, string.lastIndexOf(46)));
        }
        catch (Exception exception) {
            return null;
        }
    }

    Class classForName(String string) throws ClassNotFoundException {
        try {
            if (this.database.classLoader == null) {
                return Class.forName(string);
            }
            if (string != null) {
                return this.database.classLoader.loadClass(string);
            }
            throw new ClassNotFoundException();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new ClassNotFoundException(noClassDefFoundError.toString());
        }
    }

    Iterator iterateCatalogNames() throws HsqlException {
        return this.isReportCatalogs() ? new WrapperIterator(this.catalogName) : new WrapperIterator();
    }

    String getCatalogName(Object object) {
        return this.isReportCatalogs() ? this.catalogName : null;
    }

    HashMap getInverseAliasMap() {
        HashMap hashMap = this.database.getAliasMap();
        HashMap hashMap2 = new HashMap();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Object object2 = hashMap.get(object);
            HsqlArrayList hsqlArrayList = (HsqlArrayList)hashMap2.get(object2);
            if (hsqlArrayList == null) {
                hsqlArrayList = new HsqlArrayList();
                hashMap2.put(object2, hsqlArrayList);
            }
            hsqlArrayList.add(object);
        }
        return hashMap2;
    }

    static String getMethodFQN(Method method) {
        return method == null ? null : method.getDeclaringClass().getName() + '.' + method.getName();
    }

    static String getMethodSpecificName(Method method) {
        return method == null ? null : method.getDeclaringClass().getName() + '.' + DINameSpace.getSignature(method);
    }

    static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = n - 1;
        stringBuffer.append(method.getName()).append('(');
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(classArray[n3].getName());
            if (n3 < n2) {
                stringBuffer.append(',');
            }
            ++n3;
        }
        stringBuffer.append(')');
        String string = stringBuffer.toString();
        return string;
    }

    String getSchemaName(Object object) {
        return "PUBLIC";
    }

    void addBuiltinToSet(HashSet hashSet) {
        hashSet.addAll(builtin.toArray(new String[builtin.size()]));
    }

    boolean isBuiltin(Class clazz) {
        return clazz == null ? false : builtin.contains(clazz.getName());
    }

    boolean isBuiltin(String string) {
        return string == null ? false : builtin.contains(string);
    }

    Iterator iterateRoutineMethods(String string, boolean bl) throws HsqlException {
        Method[] methodArray;
        Class clazz;
        try {
            clazz = this.classForName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return new WrapperIterator();
        }
        HashMap hashMap = bl ? this.getInverseAliasMap() : null;
        try {
            methodArray = clazz.getDeclaredMethods();
        }
        catch (Exception exception) {
            methodArray = clazz.getMethods();
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList(methodArray.length);
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            int n2 = method.getModifiers();
            if (Modifier.isPublic(n2) && Modifier.isStatic(n2)) {
                Object[] objectArray = new Object[]{method, null, "ROUTINE"};
                if (bl) {
                    objectArray[1] = hashMap.get(DINameSpace.getMethodFQN(method));
                }
                hsqlArrayList.add(objectArray);
            }
            ++n;
        }
        return hsqlArrayList.iterator();
    }

    Iterator iterateAccessibleTriggerClassNames(User user) throws HsqlException {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.database.schemaManager.userSchemaNameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = this.database.schemaManager.tablesIterator(string);
            while (iterator2.hasNext()) {
                HsqlArrayList[] hsqlArrayListArray;
                Table table = (Table)iterator2.next();
                if (!user.isAccessible(table.getName()) || (hsqlArrayListArray = table.triggerLists) == null) continue;
                int n = 0;
                while (n < hsqlArrayListArray.length) {
                    HsqlArrayList hsqlArrayList = hsqlArrayListArray[n];
                    if (hsqlArrayList != null) {
                        int n2 = hsqlArrayList.size();
                        int n3 = 0;
                        while (n3 < n2) {
                            TriggerDef triggerDef = (TriggerDef)hsqlArrayList.get(n3);
                            if (triggerDef != null && triggerDef.valid && triggerDef.trigger != null && user.isAccessible(table, TriggerDef.indexToRight(n3))) {
                                hashSet.add(triggerDef.trigger.getClass().getName());
                            }
                            ++n3;
                        }
                    }
                    ++n;
                }
            }
        }
        return hashSet.iterator();
    }

    Iterator iterateAllAccessibleMethods(Session session, boolean bl) throws HsqlException {
        WrapperIterator wrapperIterator = new WrapperIterator();
        HashSet hashSet = session.getUser().getGrantedClassNames(true);
        this.addBuiltinToSet(hashSet);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = this.iterateRoutineMethods(string, bl);
            wrapperIterator = new WrapperIterator(wrapperIterator, iterator2);
        }
        return wrapperIterator;
    }

    Session[] listVisibleSessions(Session session) {
        return this.database.sessionManager.getVisibleSessions(session);
    }

    boolean isReportCatalogs() {
        return this.database.getProperties().isPropertyTrue("hsqldb.catalogs");
    }

    static {
        builtin.add("org.hsqldb.Library");
        builtin.add("java.lang.Math");
    }
}

