/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Constructor;
import org.hsqldb.Collation;
import org.hsqldb.CompiledStatementManager;
import org.hsqldb.DatabaseInformation;
import org.hsqldb.DatabaseManager;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Library;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.SessionManager;
import org.hsqldb.Trace;
import org.hsqldb.TransactionManager;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.Logger;

public class Database {
    int databaseID;
    private String sType;
    private String sName;
    private HsqlProperties urlProperties;
    private String sPath;
    DatabaseInformation dbInfo;
    ClassLoader classLoader;
    private int dbState;
    public Logger logger;
    boolean databaseReadOnly;
    private boolean filesReadOnly;
    private boolean filesInJar;
    public boolean sqlEnforceStrictSize;
    public int firstIdentity;
    private boolean bIgnoreCase;
    private boolean bReferentialIntegrity;
    private HsqlDatabaseProperties databaseProperties;
    private boolean shutdownOnNoConnection;
    private HashMap hAlias;
    private UserManager userManager;
    private GranteeManager granteeManager;
    HsqlNameManager nameManager;
    public SessionManager sessionManager;
    public TransactionManager txManager;
    CompiledStatementManager compiledStatementManager;
    public SchemaManager schemaManager;
    public Collation collation;
    public static final int DATABASE_ONLINE = 1;
    public static final int DATABASE_OPENING = 4;
    public static final int DATABASE_CLOSING = 8;
    public static final int DATABASE_SHUTDOWN = 16;
    public static final int CLOSEMODE_IMMEDIATELY = -1;
    public static final int CLOSEMODE_NORMAL = 0;
    public static final int CLOSEMODE_COMPACT = 1;
    public static final int CLOSEMODE_SCRIPT = 2;
    private long dbSCN = 0L;
    private long ddlSCN = 0L;
    private long dmlSCN = 0L;
    private FileAccess fileaccess;
    private boolean isStoredFileAccess;
    static /* synthetic */ Class class$java$lang$Object;

    Database(String string, String string2, String string3, HsqlProperties hsqlProperties) throws HsqlException {
        this.urlProperties = hsqlProperties;
        this.setState(16);
        this.sName = string3;
        this.sType = string;
        this.sPath = string2;
        if (this.sType == "res:") {
            this.filesInJar = true;
            this.filesReadOnly = true;
        }
        try {
            this.classLoader = this.getClass().getClassLoader();
        }
        catch (Exception exception) {
            this.classLoader = null;
        }
        String string4 = this.urlProperties.getProperty("fileaccess_class_name");
        if (string4 != null) {
            String string5 = this.urlProperties.getProperty("storage_key");
            try {
                Class<?> clazz = Class.forName(string4);
                Constructor<?> constructor = clazz.getConstructor(class$java$lang$Object == null ? (class$java$lang$Object = Database.class$("java.lang.Object")) : class$java$lang$Object);
                this.fileaccess = (FileAccess)constructor.newInstance(string5);
                this.isStoredFileAccess = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("ClassNotFoundException");
            }
            catch (InstantiationException instantiationException) {
                System.out.println("InstantiationException");
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("IllegalAccessException");
            }
            catch (Exception exception) {
                System.out.println("Exception");
            }
        } else {
            this.fileaccess = new FileUtil();
        }
        this.shutdownOnNoConnection = this.urlProperties.getProperty("shutdown", "false").equals("true");
        this.logger = new Logger();
        this.compiledStatementManager = new CompiledStatementManager(this);
    }

    synchronized void open() throws HsqlException {
        if (!this.isShutdown()) {
            return;
        }
        this.reopen();
    }

    void reopen() throws HsqlException {
        this.setState(4);
        try {
            boolean bl;
            this.databaseProperties = new HsqlDatabaseProperties(this);
            boolean bl2 = bl = this.sType == "mem:" || !this.databaseProperties.checkFileExists();
            if (bl && this.urlProperties.isPropertyTrue("ifexists")) {
                throw Trace.error(94, this.sType + this.sPath);
            }
            this.databaseProperties.load();
            this.databaseProperties.setURLProperties(this.urlProperties);
            this.compiledStatementManager.reset();
            this.granteeManager = new GranteeManager(this);
            this.userManager = new UserManager(this);
            this.hAlias = Library.getAliasMap();
            this.nameManager = new HsqlNameManager();
            this.schemaManager = new SchemaManager(this);
            this.bReferentialIntegrity = true;
            User user = this.userManager.getSysUser();
            this.sessionManager = new SessionManager(this, user);
            this.txManager = new TransactionManager(this);
            this.collation = new Collation();
            this.dbInfo = DatabaseInformation.newDatabaseInformation(this);
            this.databaseProperties.setDatabaseVariables();
            if (this.sType != "mem:") {
                this.logger.openLog(this);
            }
            if (bl) {
                this.sessionManager.getSysSession(null, false).sqlExecuteDirectNoPreChecks("CREATE USER SA PASSWORD \"\" ADMIN");
                this.logger.synchLogForce();
            }
            this.dbInfo.setWithContent(true);
        }
        catch (Throwable throwable) {
            HsqlException hsqlException;
            this.logger.closeLog(-1);
            this.logger.releaseLock();
            this.setState(16);
            this.clearStructures();
            DatabaseManager.removeDatabase(this);
            if (!(throwable instanceof HsqlException)) {
                hsqlException = Trace.error(40, throwable.toString());
            }
            throw (HsqlException)hsqlException;
        }
        this.setState(1);
    }

    void clearStructures() {
        if (this.schemaManager != null) {
            this.schemaManager.clearStructures();
        }
        this.granteeManager = null;
        this.userManager = null;
        this.hAlias = null;
        this.nameManager = null;
        this.schemaManager = null;
        this.sessionManager = null;
        this.dbInfo = null;
    }

    public String getType() {
        return this.sType;
    }

    public String getPath() {
        return this.sPath;
    }

    public HsqlDatabaseProperties getProperties() {
        return this.databaseProperties;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    synchronized boolean isShutdown() {
        return this.dbState == 16;
    }

    synchronized Session connect(String string, String string2) throws HsqlException {
        User user = this.userManager.getUser(string, string2);
        Session session = this.sessionManager.newSession(this, user, this.databaseReadOnly, false);
        this.logger.logConnectUser(session);
        return session;
    }

    public void setReadOnly() {
        this.databaseReadOnly = true;
        this.filesReadOnly = true;
    }

    public void setFilesReadOnly() {
        this.filesReadOnly = true;
    }

    public boolean isFilesReadOnly() {
        return this.filesReadOnly;
    }

    public boolean isFilesInJar() {
        return this.filesInJar;
    }

    UserManager getUserManager() {
        return this.userManager;
    }

    GranteeManager getGranteeManager() {
        return this.granteeManager;
    }

    public void setReferentialIntegrity(boolean bl) {
        this.bReferentialIntegrity = bl;
    }

    boolean isReferentialIntegrity() {
        return this.bReferentialIntegrity;
    }

    HashMap getAliasMap() {
        return this.hAlias;
    }

    String getJavaName(String string) {
        String string2 = (String)this.hAlias.get(string);
        return string2 == null ? string : string2;
    }

    void setIgnoreCase(boolean bl) {
        this.bIgnoreCase = bl;
    }

    boolean isIgnoreCase() {
        return this.bIgnoreCase;
    }

    int getDefaultTableType() {
        String string = this.getProperties().getProperty("hsqldb.default_table_type");
        return "CACHED".equalsIgnoreCase(string) ? 4 : 3;
    }

    protected void finalize() {
        if (this.getState() != 1) {
            return;
        }
        try {
            this.close(-1);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    void closeIfLast() {
        if (this.shutdownOnNoConnection && this.sessionManager.isEmpty() && this.dbState == 1) {
            try {
                this.close(0);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
        }
    }

    void close(int n) throws HsqlException {
        HsqlException hsqlException = null;
        this.setState(8);
        this.sessionManager.closeAllSessions();
        this.sessionManager.clearAll();
        if (this.filesReadOnly) {
            n = -1;
        }
        this.logger.closeLog(n);
        try {
            if (n == 1) {
                this.clearStructures();
                this.reopen();
                this.setState(8);
                this.logger.closeLog(0);
            }
        }
        catch (Throwable throwable) {
            hsqlException = throwable instanceof HsqlException ? (HsqlException)throwable : Trace.error(40, throwable.toString());
        }
        this.classLoader = null;
        this.logger.releaseLock();
        this.setState(16);
        this.clearStructures();
        DatabaseManager.removeDatabase(this);
        if (hsqlException != null) {
            throw hsqlException;
        }
    }

    public void setMetaDirty(boolean bl) {
        if (this.dbInfo != null) {
            this.dbInfo.setDirty();
        }
        if (bl) {
            this.compiledStatementManager.resetStatements();
        }
    }

    synchronized long getSCN() {
        return this.dbSCN;
    }

    private synchronized void setSCN(long l) {
        this.dbSCN = l;
    }

    private synchronized long nextSCN() {
        ++this.dbSCN;
        return this.dbSCN;
    }

    synchronized long getDMLSCN() {
        return this.dmlSCN;
    }

    synchronized long nextDMLSCN() {
        this.dmlSCN = this.nextSCN();
        return this.dmlSCN;
    }

    private synchronized void setState(int n) {
        this.dbState = n;
    }

    synchronized int getState() {
        return this.dbState;
    }

    String getStateString() {
        int n = this.getState();
        switch (n) {
            case 8: {
                return "DATABASE_CLOSING";
            }
            case 1: {
                return "DATABASE_ONLINE";
            }
            case 4: {
                return "DATABASE_OPENING";
            }
            case 16: {
                return "DATABASE_SHUTDOWN";
            }
        }
        return "UNKNOWN";
    }

    public String getURI() {
        return this.sName;
    }

    public HsqlProperties getURLProperties() {
        return this.urlProperties;
    }

    public synchronized FileAccess getFileAccess() {
        return this.fileaccess;
    }

    public synchronized boolean isStoredFileAccess() {
        return this.isStoredFileAccess;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

