/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.Grantee;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Index;
import org.hsqldb.Library;
import org.hsqldb.NumberSequence;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.Types;
import org.hsqldb.User;
import org.hsqldb.View;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringConverter;

public class DatabaseScript {
    public static Result getScript(Database database, boolean bl) {
        String string;
        String string2;
        Result result = Result.newSingleColumnResult("COMMAND", 12);
        result.metaData.tableNames[0] = "SYSTEM_SCRIPT";
        if (database.collation.name != null) {
            string2 = StringConverter.toQuotedString(database.collation.name, '\"', true);
            DatabaseScript.addRow(result, "SET DATABASE COLLATION " + string2);
        }
        Iterator iterator = database.getGranteeManager().getRoleNames().iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            if ("DBA".equals(string2)) continue;
            DatabaseScript.addRow(result, "CREATE ROLE " + string2);
        }
        HashMap hashMap = database.getAliasMap();
        HashMap hashMap2 = Library.getAliasMap();
        iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            String string4 = (String)hashMap.get(string3);
            string = (String)hashMap2.get(string3);
            if (string != null && string.equals(string4)) continue;
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("CREATE").append(' ').append("ALIAS").append(' ');
            stringBuffer.append(string3);
            stringBuffer.append(" FOR \"");
            stringBuffer.append(string4);
            stringBuffer.append('\"');
            DatabaseScript.addRow(result, stringBuffer.toString());
        }
        DatabaseScript.addSchemaStatements(database, result, bl);
        DatabaseScript.addRightsStatements(database, result);
        if (database.logger.hasLog()) {
            boolean bl2;
            int n = database.logger.getWriteDelay();
            boolean bl3 = bl2 = n < 1000;
            if (bl2) {
                if (n != 0 && n < 20) {
                    n = 20;
                }
            } else {
                n /= 1000;
            }
            string = "SET WRITE_DELAY " + n + (bl2 ? " MILLIS" : "");
            DatabaseScript.addRow(result, string);
        }
        return result;
    }

    static void addSchemaStatements(Database database, Result result, boolean bl) {
        Iterator iterator = database.schemaManager.userSchemaNameIterator();
        while (iterator.hasNext()) {
            int n;
            Object object;
            int n2;
            int n3;
            Object object2;
            HsqlNameManager.HsqlName hsqlName = database.schemaManager.toSchemaHsqlName((String)iterator.next());
            HashMappedList hashMappedList = database.schemaManager.getTables(hsqlName.name);
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append("CREATE").append(' ');
            stringBuffer.append("SCHEMA").append(' ');
            stringBuffer.append(hsqlName.statementName).append(' ');
            stringBuffer.append("AUTHORIZATION").append(' ');
            stringBuffer.append("DBA");
            DatabaseScript.addRow(result, stringBuffer.toString());
            Iterator iterator2 = database.schemaManager.sequenceIterator(hsqlName.name);
            while (iterator2.hasNext()) {
                NumberSequence numberSequence = (NumberSequence)iterator2.next();
                StringBuffer stringBuffer2 = new StringBuffer(128);
                stringBuffer2.append("CREATE").append(' ');
                stringBuffer2.append("SEQUENCE").append(' ');
                stringBuffer2.append(numberSequence.getName().statementName).append(' ');
                stringBuffer2.append("AS").append(' ');
                stringBuffer2.append(Types.getTypeString(numberSequence.getType())).append(' ');
                stringBuffer2.append("START").append(' ');
                stringBuffer2.append("WITH").append(' ');
                stringBuffer2.append(numberSequence.peek()).append(' ');
                if (numberSequence.getIncrement() != 1L) {
                    stringBuffer2.append("INCREMENT").append(' ');
                    stringBuffer2.append("BY").append(' ');
                    stringBuffer2.append(numberSequence.getIncrement()).append(' ');
                }
                DatabaseScript.addRow(result, stringBuffer2.toString());
            }
            int n4 = 0;
            int n5 = hashMappedList.size();
            while (n4 < n5) {
                Table table = (Table)hashMappedList.get(n4);
                if (!table.isView()) {
                    Object object3;
                    StringBuffer stringBuffer3 = new StringBuffer(128);
                    DatabaseScript.getTableDDL(database, table, n4, hsqlArrayList, false, stringBuffer3);
                    DatabaseScript.addRow(result, stringBuffer3.toString());
                    int n6 = 1;
                    while (n6 < table.getIndexCount()) {
                        object2 = table.getIndex(n6);
                        if (!HsqlNameManager.HsqlName.isReservedIndexName(((Index)object2).getName().name)) {
                            stringBuffer3 = new StringBuffer(64);
                            stringBuffer3.append("CREATE").append(' ');
                            if (((Index)object2).isUnique()) {
                                stringBuffer3.append("UNIQUE").append(' ');
                            }
                            stringBuffer3.append("INDEX").append(' ');
                            stringBuffer3.append(((Index)object2).getName().statementName);
                            stringBuffer3.append(' ').append("ON").append(' ');
                            stringBuffer3.append(table.getName().statementName);
                            object3 = ((Index)object2).getColumns();
                            n3 = ((Index)object2).getVisibleColumns();
                            DatabaseScript.getColumnList(table, (int[])object3, n3, stringBuffer3);
                            DatabaseScript.addRow(result, stringBuffer3.toString());
                        }
                        ++n6;
                    }
                    if (table.isText() && table.isDataReadOnly()) {
                        stringBuffer3 = new StringBuffer(64);
                        stringBuffer3.append("SET").append(' ').append("TABLE").append(' ');
                        stringBuffer3.append(table.getName().statementName);
                        stringBuffer3.append(' ').append("READONLY").append(' ').append("TRUE");
                        DatabaseScript.addRow(result, stringBuffer3.toString());
                    }
                    if ((object2 = DatabaseScript.getDataSource(table)) != null) {
                        DatabaseScript.addRow(result, (String)object2);
                    }
                    object3 = DatabaseScript.getDataSourceHeader(table);
                    if (!bl && object3 != null) {
                        DatabaseScript.addRow(result, (String)object3);
                    }
                    n3 = 12;
                    n2 = 0;
                    while (n2 < n3) {
                        object = table.triggerLists[n2];
                        if (object != null) {
                            n = ((HsqlArrayList)object).size();
                            int n7 = 0;
                            while (n7 < n) {
                                stringBuffer3 = ((TriggerDef)((HsqlArrayList)object).get(n7)).getDDL();
                                DatabaseScript.addRow(result, stringBuffer3.toString());
                                ++n7;
                            }
                        }
                        ++n2;
                    }
                }
                ++n4;
            }
            int n8 = 0;
            int n9 = hsqlArrayList.size();
            while (n8 < n9) {
                Constraint constraint = (Constraint)hsqlArrayList.get(n8);
                object2 = new StringBuffer(128);
                ((StringBuffer)object2).append("ALTER").append(' ').append("TABLE").append(' ');
                ((StringBuffer)object2).append(constraint.getRef().getName().statementName);
                ((StringBuffer)object2).append(' ').append("ADD").append(' ');
                DatabaseScript.getFKStatement(constraint, (StringBuffer)object2);
                DatabaseScript.addRow(result, ((StringBuffer)object2).toString());
                ++n8;
            }
            Session session = database.sessionManager.getSysSession();
            int n10 = 0;
            int n11 = hashMappedList.size();
            while (n10 < n11) {
                Table table = (Table)hashMappedList.get(n10);
                if (bl && table.isIndexCached() && !table.isEmpty(session)) {
                    DatabaseScript.addRow(result, DatabaseScript.getIndexRootsDDL((Table)hashMappedList.get(n10)));
                }
                ++n10;
            }
            n3 = 0;
            n2 = hashMappedList.size();
            while (n3 < n2) {
                object = (Table)hashMappedList.get(n3);
                if (!((Table)object).isCached()) {
                    String string = DatabaseScript.getIdentityUpdateDDL((Table)object);
                    DatabaseScript.addRow(result, string);
                }
                ++n3;
            }
            int n12 = 0;
            n = hashMappedList.size();
            while (n12 < n) {
                Table table = (Table)hashMappedList.get(n12);
                if (table.isView()) {
                    View view = (View)hashMappedList.get(n12);
                    StringBuffer stringBuffer4 = new StringBuffer(128);
                    stringBuffer4.append("CREATE").append(' ').append("VIEW").append(' ');
                    stringBuffer4.append(view.getName().statementName).append(' ').append('(');
                    int n13 = view.getColumnCount();
                    int n14 = 0;
                    while (n14 < n13) {
                        stringBuffer4.append(view.getColumn((int)n14).columnName.statementName);
                        if (n14 < n13 - 1) {
                            stringBuffer4.append(',');
                        }
                        ++n14;
                    }
                    stringBuffer4.append(')').append(' ').append("AS").append(' ');
                    stringBuffer4.append(view.getStatement());
                    DatabaseScript.addRow(result, stringBuffer4.toString());
                }
                ++n12;
            }
        }
    }

    static String getIdentityUpdateDDL(Table table) {
        if (table.identityColumn == -1) {
            return "";
        }
        String string = table.getName().statementName;
        String string2 = table.getColumn((int)table.identityColumn).columnName.statementName;
        long l = table.identitySequence.peek();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("ALTER").append(' ').append("TABLE").append(' ').append(string).append(' ').append("ALTER").append(' ').append("COLUMN").append(' ').append(string2).append(' ').append("RESTART").append(' ').append("WITH").append(' ').append(l);
        return stringBuffer.toString();
    }

    static String getIndexRootsDDL(Table table) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("INDEX").append('\'');
        stringBuffer.append(table.getIndexRoots());
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    static void getTableDDL(Database database, Table table, int n, HsqlArrayList hsqlArrayList, boolean bl, StringBuffer stringBuffer) {
        Object object;
        Constraint[] constraintArray;
        stringBuffer.append("CREATE").append(' ');
        if (table.isTemp) {
            stringBuffer.append("GLOBAL").append(' ');
            stringBuffer.append("TEMPORARY").append(' ');
        }
        if (table.isText()) {
            stringBuffer.append("TEXT").append(' ');
        } else if (table.isCached()) {
            stringBuffer.append("CACHED").append(' ');
        } else {
            stringBuffer.append("MEMORY").append(' ');
        }
        stringBuffer.append("TABLE").append(' ');
        if (bl) {
            stringBuffer.append(table.getName().schema.statementName).append('.');
        }
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append('(');
        int n2 = table.getColumnCount();
        Index index = table.getIndex(0);
        int[] nArray = index.getColumns();
        int n3 = 0;
        while (n3 < n2) {
            constraintArray = table.getColumn(n3);
            String string = constraintArray.columnName.statementName;
            stringBuffer.append(string);
            stringBuffer.append(' ');
            String string2 = Types.getTypeString(constraintArray.getType());
            stringBuffer.append(string2);
            boolean bl2 = false;
            if (constraintArray.getType() == 93) {
                if (constraintArray.getSize() != 6) {
                    bl2 = true;
                }
            } else {
                boolean bl3 = bl2 = constraintArray.getSize() > 0;
            }
            if (bl2) {
                stringBuffer.append('(');
                stringBuffer.append(constraintArray.getSize());
                if (constraintArray.getScale() > 0) {
                    stringBuffer.append(',');
                    stringBuffer.append(constraintArray.getScale());
                }
                stringBuffer.append(')');
            }
            if ((object = constraintArray.getDefaultDDL()) != null) {
                stringBuffer.append(' ').append("DEFAULT").append(' ');
                stringBuffer.append((String)object);
            }
            if (n3 == table.getIdentityColumn()) {
                stringBuffer.append(" GENERATED BY DEFAULT AS IDENTITY(START WITH ");
                stringBuffer.append(constraintArray.identityStart);
                if (constraintArray.identityIncrement != 1L) {
                    stringBuffer.append(",").append("INCREMENT").append(' ').append("BY").append(' ');
                    stringBuffer.append(constraintArray.identityIncrement);
                }
                stringBuffer.append(")");
            }
            if (!constraintArray.isNullable()) {
                stringBuffer.append(' ').append("NOT").append(' ').append("NULL");
            }
            if (nArray.length == 1 && n3 == nArray[0] && index.getName().isReservedIndexName()) {
                stringBuffer.append(' ').append("PRIMARY").append(' ').append("KEY");
            }
            if (n3 < n2 - 1) {
                stringBuffer.append(',');
            }
            ++n3;
        }
        if (nArray.length > 1 || nArray.length == 1 && !index.getName().isReservedIndexName()) {
            stringBuffer.append(',');
            if (!index.getName().isReservedIndexName()) {
                stringBuffer.append("CONSTRAINT").append(' ');
                stringBuffer.append(index.getName().statementName).append(' ');
            }
            stringBuffer.append("PRIMARY").append(' ').append("KEY");
            DatabaseScript.getColumnList(table, nArray, nArray.length, stringBuffer);
        }
        constraintArray = table.getConstraints();
        int n4 = 0;
        int n5 = constraintArray.length;
        while (n4 < n5) {
            Constraint constraint = constraintArray[n4];
            switch (constraint.getType()) {
                case 2: {
                    stringBuffer.append(',').append("CONSTRAINT").append(' ');
                    stringBuffer.append(constraint.getName().statementName);
                    stringBuffer.append(' ').append("UNIQUE");
                    object = constraint.getMainColumns();
                    DatabaseScript.getColumnList(constraint.getMain(), (int[])object, ((Object)object).length, stringBuffer);
                    break;
                }
                case 0: {
                    Table table2 = constraint.getMain();
                    int n6 = database.schemaManager.getTableIndex(table2);
                    if (n6 > n) {
                        hsqlArrayList.add(constraint);
                        break;
                    }
                    stringBuffer.append(',');
                    DatabaseScript.getFKStatement(constraint, stringBuffer);
                    break;
                }
                case 3: {
                    try {
                        stringBuffer.append(',').append("CONSTRAINT").append(' ');
                        stringBuffer.append(constraint.getName().statementName);
                        stringBuffer.append(' ').append("CHECK").append('(');
                        stringBuffer.append(constraint.core.check.getDDL());
                        stringBuffer.append(')');
                        break;
                    }
                    catch (HsqlException hsqlException) {
                        // empty catch block
                    }
                }
            }
            ++n4;
        }
        stringBuffer.append(')');
        if (table.onCommitPreserve) {
            stringBuffer.append(' ').append("ON").append(' ');
            stringBuffer.append("COMMIT").append(' ').append("PRESERVE");
            stringBuffer.append(' ').append("ROWS");
        }
    }

    static String getDataSource(Table table) {
        String string = table.getDataSource();
        if (string == null) {
            return null;
        }
        boolean bl = table.isDescDataSource();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("SOURCE").append(' ').append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
        if (bl) {
            stringBuffer.append(' ').append("DESC");
        }
        return stringBuffer.toString();
    }

    static String getDataSourceHeader(Table table) {
        String string = table.getHeader();
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET").append(' ').append("TABLE").append(' ');
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(' ').append("SOURCE").append(' ');
        stringBuffer.append("HEADER").append(' ');
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    private static void getColumnList(Table table, int[] nArray, int n, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(table.getColumn((int)nArray[n2]).columnName.statementName);
            if (n2 < n - 1) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        stringBuffer.append(')');
    }

    private static void getFKStatement(Constraint constraint, StringBuffer stringBuffer) {
        stringBuffer.append("CONSTRAINT").append(' ');
        stringBuffer.append(constraint.getName().statementName);
        stringBuffer.append(' ').append("FOREIGN").append(' ').append("KEY");
        int[] nArray = constraint.getRefColumns();
        DatabaseScript.getColumnList(constraint.getRef(), nArray, nArray.length, stringBuffer);
        stringBuffer.append(' ').append("REFERENCES").append(' ');
        stringBuffer.append(constraint.getMain().getName().statementName);
        nArray = constraint.getMainColumns();
        DatabaseScript.getColumnList(constraint.getMain(), nArray, nArray.length, stringBuffer);
        if (constraint.getDeleteAction() != 3) {
            stringBuffer.append(' ').append("ON").append(' ').append("DELETE").append(' ');
            stringBuffer.append(DatabaseScript.getFKAction(constraint.getDeleteAction()));
        }
        if (constraint.getUpdateAction() != 3) {
            stringBuffer.append(' ').append("ON").append(' ').append("UPDATE").append(' ');
            stringBuffer.append(DatabaseScript.getFKAction(constraint.getUpdateAction()));
        }
    }

    private static String getFKAction(int n) {
        switch (n) {
            case 0: {
                return "CASCADE";
            }
            case 4: {
                return "SET DEFAULT";
            }
            case 2: {
                return "SET NULL";
            }
        }
        return "NO ACTION";
    }

    private static void addRow(Result result, String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        Object[] objectArray = new String[]{string};
        result.add(objectArray);
    }

    private static void addRightsStatements(Database database, Result result) {
        String string;
        Object object;
        HashMappedList hashMappedList = database.getUserManager().getUsers();
        Iterator iterator = hashMappedList.values().iterator();
        GranteeManager granteeManager = database.getGranteeManager();
        Iterator iterator2 = granteeManager.getGrantees().iterator();
        while (iterator.hasNext()) {
            object = (User)iterator.next();
            string = ((User)object).getName();
            if (string.equals("PUBLIC")) continue;
            DatabaseScript.addRow(result, ((User)object).getCreateUserDDL());
        }
        while (iterator2.hasNext()) {
            IntValueHashMap intValueHashMap;
            object = (Grantee)iterator2.next();
            string = ((Grantee)object).getName();
            if (string.equals("_SYSTEM") || string.equals("DBA")) continue;
            String string2 = ((Grantee)object).allRolesString();
            if (string2 != null) {
                DatabaseScript.addRow(result, "GRANT " + string2 + " TO " + string);
            }
            if ((intValueHashMap = ((Grantee)object).getRights()) == null) continue;
            Iterator iterator3 = intValueHashMap.keySet().iterator();
            while (iterator3.hasNext()) {
                Object object2 = iterator3.next();
                int n = intValueHashMap.get(object2, 0);
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append("GRANT").append(' ');
                stringBuffer.append(GranteeManager.getRightsList(n));
                stringBuffer.append(' ').append("ON").append(' ');
                if (object2 instanceof String) {
                    if (object2.equals("java.lang.Math") || object2.equals("org.hsqldb.Library")) continue;
                    stringBuffer.append("CLASS \"");
                    stringBuffer.append((String)object2);
                    stringBuffer.append('\"');
                } else {
                    HsqlNameManager.HsqlName hsqlName = (HsqlNameManager.HsqlName)object2;
                    Table table = database.schemaManager.findUserTable(null, hsqlName.name, hsqlName.schema.name);
                    if (table == null) continue;
                    stringBuffer.append(hsqlName.schema.statementName).append('.').append(hsqlName.statementName);
                }
                stringBuffer.append(' ').append("TO").append(' ');
                stringBuffer.append(((Grantee)object).getName());
                DatabaseScript.addRow(result, stringBuffer.toString());
            }
        }
    }
}

