/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Random;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.store.ValuePool;

public class Library {
    static final SimpleDateFormat tocharFormat = new SimpleDateFormat();
    static final SimpleDateFormat daynameFormat = new SimpleDateFormat("EEEE", Locale.ENGLISH);
    static final SimpleDateFormat monthnameFormat = new SimpleDateFormat("MMMM", Locale.ENGLISH);
    static final StringBuffer daynameBuffer = new StringBuffer();
    static final StringBuffer monthnameBuffer = new StringBuffer();
    static final FieldPosition monthPosition = new FieldPosition(2);
    static final FieldPosition dayPosition = new FieldPosition(9);
    public static final String[][] sNumeric = new String[][]{{"ABS", "org.hsqldb.Library.abs"}, {"ACOS", "java.lang.Math.acos"}, {"ASIN", "java.lang.Math.asin"}, {"ATAN", "java.lang.Math.atan"}, {"ATAN2", "java.lang.Math.atan2"}, {"CEILING", "java.lang.Math.ceil"}, {"COS", "java.lang.Math.cos"}, {"COT", "org.hsqldb.Library.cot"}, {"DEGREES", "java.lang.Math.toDegrees"}, {"EXP", "java.lang.Math.exp"}, {"FLOOR", "java.lang.Math.floor"}, {"LOG", "java.lang.Math.log"}, {"LOG10", "org.hsqldb.Library.log10"}, {"MOD", "org.hsqldb.Library.mod"}, {"PI", "org.hsqldb.Library.pi"}, {"POWER", "java.lang.Math.pow"}, {"RADIANS", "java.lang.Math.toRadians"}, {"RAND", "java.lang.Math.random"}, {"ROUND", "org.hsqldb.Library.round"}, {"SIGN", "org.hsqldb.Library.sign"}, {"SIN", "java.lang.Math.sin"}, {"SQRT", "java.lang.Math.sqrt"}, {"TAN", "java.lang.Math.tan"}, {"TRUNCATE", "org.hsqldb.Library.truncate"}, {"BITAND", "org.hsqldb.Library.bitand"}, {"BITOR", "org.hsqldb.Library.bitor"}, {"BITXOR", "org.hsqldb.Library.bitxor"}, {"ROUNDMAGIC", "org.hsqldb.Library.roundMagic"}};
    public static final String[][] sString = new String[][]{{"ASCII", "org.hsqldb.Library.ascii"}, {"BIT_LENGTH", "org.hsqldb.Library.bitLength"}, {"CHAR", "org.hsqldb.Library.character"}, {"CHAR_LENGTH", "org.hsqldb.Library.length"}, {"CHARACTER_LENGTH", "org.hsqldb.Library.length"}, {"CONCAT", "org.hsqldb.Library.concat"}, {"DIFFERENCE", "org.hsqldb.Library.difference"}, {"HEXTORAW", "org.hsqldb.Library.hexToRaw"}, {"INSERT", "org.hsqldb.Library.insert"}, {"LCASE", "org.hsqldb.Library.lcase"}, {"LEFT", "org.hsqldb.Library.left"}, {"LENGTH", "org.hsqldb.Library.length"}, {"LOCATE", "org.hsqldb.Library.locate"}, {"LTRIM", "org.hsqldb.Library.ltrim"}, {"OCTET_LENGTH", "org.hsqldb.Library.octetLength"}, {"RAWTOHEX", "org.hsqldb.Library.rawToHex"}, {"REPEAT", "org.hsqldb.Library.repeat"}, {"REPLACE", "org.hsqldb.Library.replace"}, {"RIGHT", "org.hsqldb.Library.right"}, {"RTRIM", "org.hsqldb.Library.rtrim"}, {"SOUNDEX", "org.hsqldb.Library.soundex"}, {"SPACE", "org.hsqldb.Library.space"}, {"SUBSTR", "org.hsqldb.Library.substring"}, {"SUBSTRING", "org.hsqldb.Library.substring"}, {"UCASE", "org.hsqldb.Library.ucase"}, {"LOWER", "org.hsqldb.Library.lcase"}, {"UPPER", "org.hsqldb.Library.ucase"}};
    public static final String[][] sTimeDate = new String[][]{{"CURDATE", "org.hsqldb.Library.curdate"}, {"CURTIME", "org.hsqldb.Library.curtime"}, {"DATEDIFF", "org.hsqldb.Library.datediff"}, {"DAYNAME", "org.hsqldb.Library.dayname"}, {"DAY", "org.hsqldb.Library.dayofmonth"}, {"DAYOFMONTH", "org.hsqldb.Library.dayofmonth"}, {"DAYOFWEEK", "org.hsqldb.Library.dayofweek"}, {"DAYOFYEAR", "org.hsqldb.Library.dayofyear"}, {"HOUR", "org.hsqldb.Library.hour"}, {"MINUTE", "org.hsqldb.Library.minute"}, {"MONTH", "org.hsqldb.Library.month"}, {"MONTHNAME", "org.hsqldb.Library.monthname"}, {"NOW", "org.hsqldb.Library.now"}, {"QUARTER", "org.hsqldb.Library.quarter"}, {"SECOND", "org.hsqldb.Library.second"}, {"WEEK", "org.hsqldb.Library.week"}, {"YEAR", "org.hsqldb.Library.year"}, {"TO_CHAR", "org.hsqldb.Library.to_char"}};
    public static final String[][] sSystem = new String[][]{{"DATABASE", "org.hsqldb.Library.database"}, {"USER", "org.hsqldb.Library.user"}, {"IDENTITY", "org.hsqldb.Library.identity"}};
    private static final Random rRandom = new Random();
    private static final double LOG10_FACTOR = 0.4342944819032518;
    static final int abs = 0;
    static final int ascii = 1;
    static final int bitand = 2;
    static final int bitLength = 3;
    static final int bitor = 4;
    static final int bitxor = 64;
    static final int character = 5;
    static final int concat = 6;
    static final int cot = 7;
    static final int curdate = 8;
    static final int curtime = 9;
    static final int database = 10;
    static final int datediff = 63;
    static final int day = 11;
    static final int dayname = 12;
    static final int dayofmonth = 13;
    static final int dayofweek = 14;
    static final int dayofyear = 15;
    static final int difference = 16;
    static final int getAutoCommit = 17;
    static final int getDatabaseMajorVersion = 18;
    static final int getDatabaseMinorVersion = 19;
    static final int getDatabaseProductName = 20;
    static final int getDatabaseProductVersion = 21;
    static final int hexToRaw = 22;
    static final int hour = 23;
    static final int identity = 24;
    static final int insert = 25;
    static final int isReadOnlyConnection = 26;
    static final int isReadOnlyDatabase = 27;
    static final int isReadOnlyDatabaseFiles = 28;
    static final int lcase = 29;
    static final int left = 30;
    static final int length = 31;
    static final int locate = 32;
    static final int log10 = 33;
    static final int ltrim = 34;
    static final int minute = 35;
    static final int mod = 36;
    static final int month = 37;
    static final int monthname = 38;
    static final int now = 39;
    static final int octetLength = 40;
    static final int pi = 41;
    static final int position = 42;
    static final int quarter = 43;
    static final int rand = 44;
    static final int rawToHex = 45;
    static final int repeat = 46;
    static final int replace = 47;
    static final int right = 48;
    static final int round = 49;
    static final int roundMagic = 50;
    static final int rtrim = 51;
    static final int second = 52;
    static final int sign = 53;
    static final int soundex = 54;
    static final int space = 55;
    static final int substring = 56;
    static final int to_char = 65;
    static final int trim = 57;
    static final int truncate = 58;
    static final int ucase = 59;
    static final int user = 60;
    static final int week = 61;
    static final int year = 62;
    private static final IntValueHashMap functionMap = new IntValueHashMap(67);
    static final Double piValue = new Double(Library.pi());
    static final String prefix = "org.hsqldb.Library.";
    static final int prefixLength;

    private Library() {
    }

    static HashMap getAliasMap() {
        HashMap hashMap = new HashMap(83, 1.0f);
        Library.register(hashMap, sNumeric);
        Library.register(hashMap, sString);
        Library.register(hashMap, sTimeDate);
        Library.register(hashMap, sSystem);
        return hashMap;
    }

    private static void register(HashMap hashMap, String[][] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            hashMap.put(stringArray[n][0], stringArray[n][1]);
            ++n;
        }
    }

    public static double rand(Integer n) {
        Random random = rRandom;
        synchronized (random) {
            if (n != null) {
                rRandom.setSeed(n.intValue());
            }
            double d = rRandom.nextDouble();
            return d;
        }
    }

    public static double abs(double d) {
        return Math.abs(d);
    }

    public static double log10(double d) {
        return Library.roundMagic(Math.log(d) * 0.4342944819032518);
    }

    public static double roundMagic(double d) {
        if (d < 1.0E-13 && d > -1.0E-13) {
            return 0.0;
        }
        if (d > 1.0E12 || d < -1.0E12) {
            return d;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(d);
        int n = stringBuffer.length();
        if (n < 16) {
            return d;
        }
        char c = stringBuffer.charAt(n - 1);
        char c2 = stringBuffer.charAt(n - 2);
        char c3 = stringBuffer.charAt(n - 3);
        char c4 = stringBuffer.charAt(n - 4);
        if (c2 == '0' && c3 == '0' && c4 == '0' && c != '.') {
            stringBuffer.setCharAt(n - 1, '0');
        } else if (c2 == '9' && c3 == '9' && c4 == '9' && c != '.') {
            stringBuffer.setCharAt(n - 1, '9');
            stringBuffer.append('9');
            stringBuffer.append('9');
        }
        return Double.valueOf(stringBuffer.toString());
    }

    public static double cot(double d) {
        return 1.0 / Math.tan(d);
    }

    public static int mod(int n, int n2) {
        return n % n2;
    }

    public static double pi() {
        return Math.PI;
    }

    public static double round(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }

    public static int sign(double d) {
        return d < 0.0 ? -1 : (d > 0.0 ? 1 : 0);
    }

    public static double truncate(double d, int n) {
        double d2 = Math.pow(10.0, n);
        double d3 = d * d2;
        return (d < 0.0 ? Math.ceil(d3) : Math.floor(d3)) / d2;
    }

    public static int bitand(int n, int n2) {
        return n & n2;
    }

    public static int bitor(int n, int n2) {
        return n | n2;
    }

    public static int bitxor(int n, int n2) {
        return n ^ n2;
    }

    public static Integer ascii(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return ValuePool.getInt(string.charAt(0));
    }

    public static String character(int n) {
        return String.valueOf((char)n);
    }

    public static String concat(String string, String string2) {
        if (string == null) {
            if (string2 == null) {
                return null;
            }
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return string.concat(string2);
    }

    public static int difference(String string, String string2) {
        if (string == null || string2 == null) {
            return 0;
        }
        string = Library.soundex(string);
        string2 = Library.soundex(string2);
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            if (string.charAt(n2) != string2.charAt(n2)) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static String hexToRaw(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        if (n % 4 != 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = (char)Integer.parseInt(string.substring(n2, n2 + 4), 16);
            stringBuffer.append(c);
            n2 += 4;
        }
        return stringBuffer.toString();
    }

    public static String insert(String string, int n, int n2, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (--n < 0 || n2 <= 0 || n4 == 0 || n > n3) {
            return string;
        }
        if (n + n2 > n3) {
            n2 = n3 - n;
        }
        return string.substring(0, n) + string2 + string.substring(n + n2);
    }

    public static String lcase(String string) {
        return string == null ? null : string.toLowerCase();
    }

    public static String left(String string, int n) {
        if (string == null) {
            return null;
        }
        return string.substring(0, n < 0 ? 0 : (n < string.length() ? n : string.length()));
    }

    public static Integer length(String string) {
        return string == null ? null : ValuePool.getInt(string.length());
    }

    public static Integer octetLength(String string) {
        return string == null ? null : ValuePool.getInt(string.length() * 2);
    }

    public static Integer bitLength(String string) {
        return string == null ? null : ValuePool.getInt(string.length() * 16);
    }

    public static int locate(String string, String string2, Integer n) {
        if (string2 == null || string == null) {
            return 0;
        }
        int n2 = n == null ? 0 : n - 1;
        return string2.indexOf(string, n2 < 0 ? 0 : n2) + 1;
    }

    public static int position(String string, String string2) {
        return Library.locate(string, string2, null);
    }

    public static String ltrim(String string) {
        if (string == null) {
            return string;
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n && string.charAt(n2) <= ' ') {
            ++n2;
        }
        return n2 == 0 ? string : string.substring(n2);
    }

    public static String rawToHex(String string) {
        if (string == null) {
            return null;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(4 * string.length());
        int n = 0;
        while (n < cArray.length) {
            String string2 = Integer.toHexString(cArray[n] & 0xFFFF);
            int n2 = string2.length();
            while (n2 < 4) {
                stringBuffer.append('0');
                ++n2;
            }
            stringBuffer.append(string2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String repeat(String string, Integer n) {
        if (string == null || n == null || n < 0) {
            return null;
        }
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer(string.length() * n2);
        while (n2-- > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return string;
        }
        if (string3 == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string2.length();
        while (true) {
            int n3;
            if ((n3 = string.indexOf(string2, n)) == -1) break;
            stringBuffer.append(string.substring(n, n3));
            stringBuffer.append(string3);
            n = n3 + n2;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public static String right(String string, int n) {
        if (string == null) {
            return null;
        }
        n = string.length() - n;
        return string.substring(n < 0 ? 0 : (n < string.length() ? n : string.length()));
    }

    public static String rtrim(String string) {
        int n;
        if (string == null) {
            return string;
        }
        int n2 = n = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2) == ' ') {
            --n2;
        }
        return n2 == n ? string : string.substring(0, n2 + 1);
    }

    public static String trim(String string, String string2, boolean bl, boolean bl2) {
        if (string == null) {
            return string;
        }
        char c = string2.charAt(0);
        int n = string.length();
        if (bl2) {
            --n;
            while (n >= 0 && string.charAt(n) == c) {
                --n;
            }
            ++n;
        }
        if (n == 0) {
            return "";
        }
        int n2 = 0;
        if (bl) {
            while (n2 < n && string.charAt(n2) == c) {
                ++n2;
            }
        }
        if (n2 == 0 && n == string.length()) {
            return string;
        }
        return string.substring(n2, n);
    }

    public static String soundex(String string) {
        if (string == null) {
            return string;
        }
        string = string.toUpperCase(Locale.ENGLISH);
        int n = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n2 = 48;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < 4) {
            block19: {
                int n5;
                char c;
                block12: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block11: {
                                                c = string.charAt(n3);
                                                if ("AEIOUY".indexOf(c) == -1) break block11;
                                                n5 = 55;
                                                break block12;
                                            }
                                            if (c != 'H' && c != 'W') break block13;
                                            n5 = 56;
                                            break block12;
                                        }
                                        if ("BFPV".indexOf(c) == -1) break block14;
                                        n5 = 49;
                                        break block12;
                                    }
                                    if ("CGJKQSXZ".indexOf(c) == -1) break block15;
                                    n5 = 50;
                                    break block12;
                                }
                                if (c != 'D' && c != 'T') break block16;
                                n5 = 51;
                                break block12;
                            }
                            if (c != 'L') break block17;
                            n5 = 52;
                            break block12;
                        }
                        if (c != 'M' && c != 'N') break block18;
                        n5 = 53;
                        break block12;
                    }
                    if (c != 'R') break block19;
                    n5 = 54;
                }
                if (n4 == 0) {
                    cArray[n4++] = c;
                    n2 = n5;
                } else if (n5 <= 54) {
                    if (n5 != n2) {
                        cArray[n4++] = n5;
                        n2 = n5;
                    }
                } else if (n5 == 55) {
                    n2 = n5;
                }
            }
            ++n3;
        }
        return new String(cArray, 0, 4);
    }

    public static String space(int n) {
        if (n < 0) {
            return null;
        }
        char[] cArray = new char[n];
        while (n > 0) {
            cArray[--n] = 32;
        }
        return new String(cArray);
    }

    public static String substring(String string, int n, Integer n2) {
        int n3;
        if (string == null) {
            return null;
        }
        int n4 = string.length();
        int n5 = n3 = n2 == null ? n4 : n2;
        if (n3 < 1) {
            return null;
        }
        if (n < 0) {
            n = n4 + n;
        } else if (n > 0) {
            --n;
        }
        if (n < 0 || n >= n4) {
            return null;
        }
        if (n > n4 - n3) {
            n3 = n4 - n;
        }
        return string.substring(n, n + n3);
    }

    public static String ucase(String string) {
        return string == null ? null : string.toUpperCase();
    }

    public static Date curdate(Connection connection) {
        return null;
    }

    public static Time curtime(Connection connection) {
        return null;
    }

    public static String dayname(Date date) {
        if (date == null) {
            return null;
        }
        StringBuffer stringBuffer = daynameBuffer;
        synchronized (stringBuffer) {
            daynameBuffer.setLength(0);
            String string = daynameFormat.format((java.util.Date)date, daynameBuffer, dayPosition).toString();
            return string;
        }
    }

    public static Integer dayofmonth(Date date) {
        if (date == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(date, 5));
    }

    public static Integer dayofweek(Date date) {
        if (date == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(date, 7));
    }

    public static Integer dayofyear(Date date) {
        if (date == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(date, 6));
    }

    public static Integer hour(Time time) {
        if (time == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(time, 11));
    }

    public static Integer minute(Time time) {
        if (time == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(time, 12));
    }

    public static Integer month(Date date) {
        if (date == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(date, 2) + 1);
    }

    public static String monthname(Date date) {
        if (date == null) {
            return null;
        }
        StringBuffer stringBuffer = monthnameBuffer;
        synchronized (stringBuffer) {
            monthnameBuffer.setLength(0);
            String string = monthnameFormat.format((java.util.Date)date, monthnameBuffer, monthPosition).toString();
            return string;
        }
    }

    public static Timestamp now(Connection connection) {
        return null;
    }

    public static Integer quarter(Date date) {
        if (date == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(date, 2) / 3 + 1);
    }

    public static Integer second(Time time) {
        if (time == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(time, 13));
    }

    public static Integer week(Date date) {
        if (date == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(date, 3));
    }

    public static Integer year(Date date) {
        if (date == null) {
            return null;
        }
        return ValuePool.getInt(HsqlDateTime.getDateTimePart(date, 1));
    }

    public static String to_char(java.util.Date date, String string) {
        if (date == null || string == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = tocharFormat;
        synchronized (simpleDateFormat) {
            tocharFormat.applyPattern(HsqlDateTime.toJavaDatePattern(string));
            String string2 = tocharFormat.format(date);
            return string2;
        }
    }

    public static Long datediff(String string, Timestamp timestamp, Timestamp timestamp2) throws HsqlException {
        if (timestamp == null || timestamp2 == null) {
            return null;
        }
        if ("yy".equalsIgnoreCase(string) || "year".equalsIgnoreCase(string)) {
            return ValuePool.getLong(Library.getElapsed(1, timestamp, timestamp2));
        }
        if ("mm".equalsIgnoreCase(string) || "month".equalsIgnoreCase(string)) {
            return ValuePool.getLong(Library.getElapsed(2, timestamp, timestamp2));
        }
        if ("dd".equalsIgnoreCase(string) || "day".equalsIgnoreCase(string)) {
            return ValuePool.getLong(Library.getElapsed(5, timestamp, timestamp2));
        }
        if ("hh".equalsIgnoreCase(string) || "hour".equalsIgnoreCase(string)) {
            return ValuePool.getLong(Library.getElapsed(10, timestamp, timestamp2));
        }
        if ("mi".equalsIgnoreCase(string) || "minute".equalsIgnoreCase(string)) {
            return ValuePool.getLong(Library.getElapsed(12, timestamp, timestamp2));
        }
        if ("ss".equalsIgnoreCase(string) || "second".equalsIgnoreCase(string)) {
            return ValuePool.getLong(Library.getElapsed(13, timestamp, timestamp2));
        }
        if ("ms".equalsIgnoreCase(string) || "millisecond".equalsIgnoreCase(string)) {
            return ValuePool.getLong(Library.getElapsed(14, timestamp, timestamp2));
        }
        throw Trace.error(95);
    }

    private static long getElapsed(int n, java.util.Date date, java.util.Date date2) {
        if (n == 14) {
            return date2.getTime() - date.getTime();
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        calendar.set(14, 0);
        calendar2.set(14, 0);
        if (n == 13) {
            return (calendar2.getTime().getTime() - calendar.getTime().getTime()) / 1000L;
        }
        calendar.set(13, 0);
        calendar2.set(13, 0);
        if (n == 12) {
            return (calendar2.getTime().getTime() - calendar.getTime().getTime()) / 60000L;
        }
        calendar.set(12, 0);
        calendar2.set(12, 0);
        if (n == 10) {
            return (calendar2.getTime().getTime() - calendar.getTime().getTime()) / 3600000L;
        }
        long l = 0L;
        int n2 = 1;
        if (calendar2.before(calendar)) {
            n2 = -1;
            Calendar calendar3 = calendar;
            calendar = calendar2;
            calendar2 = calendar3;
        }
        calendar.set(11, 0);
        calendar2.set(11, 0);
        if (n == 2 || n == 1) {
            calendar.set(5, 1);
            calendar2.set(5, 1);
        }
        if (n == 1) {
            calendar.set(2, 1);
            calendar2.set(2, 1);
        }
        while (calendar.before(calendar2)) {
            calendar.add(n, 1);
            ++l;
        }
        return (long)n2 * l;
    }

    public static String database(Connection connection) throws HsqlException {
        return null;
    }

    public static String user(Connection connection) throws HsqlException {
        return null;
    }

    public static int identity() throws HsqlException {
        return 0;
    }

    public static boolean getAutoCommit(Connection connection) {
        return false;
    }

    public static String getDatabaseProductName() {
        return "HSQL Database Engine";
    }

    public static String getDatabaseProductVersion() {
        return "1.8.0";
    }

    public static int getDatabaseMajorVersion() {
        return 1;
    }

    public static int getDatabaseMinorVersion() {
        return 8;
    }

    public static boolean isReadOnlyConnection(Connection connection) {
        return false;
    }

    public static boolean isReadOnlyDatabase(Connection connection) {
        return false;
    }

    public static boolean isReadOnlyDatabaseFiles(Connection connection) {
        return false;
    }

    static Object invoke(int n, Object[] objectArray) throws HsqlException {
        try {
            switch (n) {
                case 0: {
                    return new Double(Library.abs(((Number)objectArray[0]).doubleValue()));
                }
                case 1: {
                    return Library.ascii((String)objectArray[0]);
                }
                case 2: {
                    return ValuePool.getInt(Library.bitand(((Number)objectArray[0]).intValue(), ((Number)objectArray[1]).intValue()));
                }
                case 3: {
                    return Library.bitLength((String)objectArray[0]);
                }
                case 4: {
                    return ValuePool.getInt(Library.bitor(((Number)objectArray[0]).intValue(), ((Number)objectArray[1]).intValue()));
                }
                case 64: {
                    return ValuePool.getInt(Library.bitxor(((Number)objectArray[0]).intValue(), ((Number)objectArray[1]).intValue()));
                }
                case 5: {
                    return Library.character(((Number)objectArray[0]).intValue());
                }
                case 6: {
                    return Library.concat((String)objectArray[0], (String)objectArray[1]);
                }
                case 7: {
                    return new Double(Library.cot(((Number)objectArray[0]).doubleValue()));
                }
                case 8: {
                    return null;
                }
                case 9: {
                    return null;
                }
                case 10: {
                    return null;
                }
                case 63: {
                    return Library.datediff((String)objectArray[0], (Timestamp)objectArray[1], (Timestamp)objectArray[2]);
                }
                case 12: {
                    return Library.dayname((Date)objectArray[0]);
                }
                case 11: 
                case 13: {
                    return Library.dayofmonth((Date)objectArray[0]);
                }
                case 14: {
                    return Library.dayofweek((Date)objectArray[0]);
                }
                case 15: {
                    return Library.dayofyear((Date)objectArray[0]);
                }
                case 16: {
                    return ValuePool.getInt(Library.difference((String)objectArray[0], (String)objectArray[1]));
                }
                case 17: {
                    return null;
                }
                case 18: {
                    return ValuePool.getInt(Library.getDatabaseMajorVersion());
                }
                case 19: {
                    return ValuePool.getInt(Library.getDatabaseMinorVersion());
                }
                case 20: {
                    return Library.getDatabaseProductName();
                }
                case 21: {
                    return Library.getDatabaseProductVersion();
                }
                case 22: {
                    return Library.hexToRaw((String)objectArray[0]);
                }
                case 23: {
                    return Library.hour((Time)objectArray[0]);
                }
                case 24: {
                    return null;
                }
                case 25: {
                    return Library.insert((String)objectArray[0], ((Number)objectArray[1]).intValue(), ((Number)objectArray[2]).intValue(), (String)objectArray[3]);
                }
                case 26: {
                    return null;
                }
                case 27: {
                    return null;
                }
                case 29: {
                    return Library.lcase((String)objectArray[0]);
                }
                case 30: {
                    return Library.left((String)objectArray[0], ((Number)objectArray[1]).intValue());
                }
                case 31: {
                    return Library.length((String)objectArray[0]);
                }
                case 32: {
                    return ValuePool.getInt(Library.locate((String)objectArray[0], (String)objectArray[1], (Integer)objectArray[2]));
                }
                case 33: {
                    return new Double(Library.log10(((Number)objectArray[0]).doubleValue()));
                }
                case 34: {
                    return Library.ltrim((String)objectArray[0]);
                }
                case 35: {
                    return Library.minute((Time)objectArray[0]);
                }
                case 36: {
                    return ValuePool.getInt(Library.mod(((Number)objectArray[0]).intValue(), ((Number)objectArray[1]).intValue()));
                }
                case 37: {
                    return Library.month((Date)objectArray[0]);
                }
                case 38: {
                    return ValuePool.getString(Library.monthname((Date)objectArray[0]));
                }
                case 39: {
                    return null;
                }
                case 40: {
                    return Library.octetLength((String)objectArray[0]);
                }
                case 42: {
                    return ValuePool.getInt(Library.position((String)objectArray[0], (String)objectArray[1]));
                }
                case 41: {
                    return piValue;
                }
                case 43: {
                    return Library.quarter((Date)objectArray[0]);
                }
                case 44: {
                    return new Double(Library.rand((Integer)objectArray[0]));
                }
                case 45: {
                    return Library.rawToHex((String)objectArray[0]);
                }
                case 46: {
                    return Library.repeat((String)objectArray[0], (Integer)objectArray[1]);
                }
                case 47: {
                    return Library.replace((String)objectArray[0], (String)objectArray[1], (String)objectArray[2]);
                }
                case 48: {
                    return Library.right((String)objectArray[0], ((Number)objectArray[1]).intValue());
                }
                case 49: {
                    return new Double(Library.round(((Number)objectArray[0]).doubleValue(), ((Number)objectArray[1]).intValue()));
                }
                case 50: {
                    return new Double(Library.roundMagic(((Number)objectArray[0]).doubleValue()));
                }
                case 51: {
                    return Library.rtrim((String)objectArray[0]);
                }
                case 52: {
                    return Library.second((Time)objectArray[0]);
                }
                case 53: {
                    return ValuePool.getInt(Library.sign(((Number)objectArray[0]).doubleValue()));
                }
                case 54: {
                    return Library.soundex((String)objectArray[0]);
                }
                case 55: {
                    return Library.space(((Number)objectArray[0]).intValue());
                }
                case 56: {
                    return Library.substring((String)objectArray[0], ((Number)objectArray[1]).intValue(), (Integer)objectArray[2]);
                }
                case 57: {
                    return Library.trim((String)objectArray[0], (String)objectArray[1], (Boolean)objectArray[2], (Boolean)objectArray[3]);
                }
                case 58: {
                    return new Double(Library.truncate(((Number)objectArray[0]).doubleValue(), ((Number)objectArray[1]).intValue()));
                }
                case 59: {
                    return Library.ucase((String)objectArray[0]);
                }
                case 60: {
                    return null;
                }
                case 61: {
                    return Library.week((Date)objectArray[0]);
                }
                case 62: {
                    return Library.year((Date)objectArray[0]);
                }
                case 65: {
                    return Library.to_char((java.util.Date)objectArray[0], (String)objectArray[1]);
                }
                case 28: {
                    return null;
                }
            }
            Trace.doAssert(false);
            return null;
        }
        catch (Exception exception) {
            throw Trace.error(198, exception.getMessage());
        }
    }

    static int functionID(String string) {
        return string.startsWith(prefix) ? functionMap.get((Object)string.substring(prefixLength), -1) : -1;
    }

    static {
        functionMap.put("abs", 0);
        functionMap.put("ascii", 1);
        functionMap.put("bitand", 2);
        functionMap.put("bitlength", 3);
        functionMap.put("bitor", 4);
        functionMap.put("bitxor", 4);
        functionMap.put("character", 5);
        functionMap.put("concat", 6);
        functionMap.put("cot", 7);
        functionMap.put("curdate", 8);
        functionMap.put("curtime", 9);
        functionMap.put("database", 10);
        functionMap.put("datediff", 63);
        functionMap.put("dayname", 12);
        functionMap.put("day", 11);
        functionMap.put("dayofmonth", 13);
        functionMap.put("dayofweek", 14);
        functionMap.put("dayofyear", 15);
        functionMap.put("difference", 16);
        functionMap.put("getAutoCommit", 17);
        functionMap.put("getDatabaseMajorVersion", 18);
        functionMap.put("getDatabaseMinorVersion", 19);
        functionMap.put("getDatabaseProductName", 20);
        functionMap.put("getDatabaseProductVersion", 21);
        functionMap.put("hexToRaw", 22);
        functionMap.put("hour", 23);
        functionMap.put("identity", 24);
        functionMap.put("insert", 25);
        functionMap.put("isReadOnlyConnection", 26);
        functionMap.put("isReadOnlyDatabase", 27);
        functionMap.put("isReadOnlyDatabaseFiles", 28);
        functionMap.put("lcase", 29);
        functionMap.put("left", 30);
        functionMap.put("length", 31);
        functionMap.put("locate", 32);
        functionMap.put("log10", 33);
        functionMap.put("ltrim", 34);
        functionMap.put("minute", 35);
        functionMap.put("mod", 36);
        functionMap.put("month", 37);
        functionMap.put("monthname", 38);
        functionMap.put("now", 39);
        functionMap.put("octetLength", 40);
        functionMap.put("pi", 41);
        functionMap.put("position", 42);
        functionMap.put("quarter", 43);
        functionMap.put("rand", 44);
        functionMap.put("rawToHex", 45);
        functionMap.put("repeat", 46);
        functionMap.put("replace", 47);
        functionMap.put("right", 48);
        functionMap.put("round", 49);
        functionMap.put("roundMagic", 50);
        functionMap.put("rtrim", 51);
        functionMap.put("second", 52);
        functionMap.put("sign", 53);
        functionMap.put("soundex", 54);
        functionMap.put("space", 55);
        functionMap.put("substring", 56);
        functionMap.put("to_char", 65);
        functionMap.put("trim", 57);
        functionMap.put("truncate", 58);
        functionMap.put("ucase", 59);
        functionMap.put("user", 60);
        functionMap.put("week", 61);
        functionMap.put("year", 62);
        prefixLength = prefix.length();
    }
}

