/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.Index;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;

final class TableFilter {
    static final int CONDITION_NONE = -1;
    static final int CONDITION_UNORDERED = 0;
    static final int CONDITION_START_END = 1;
    static final int CONDITION_START = 2;
    static final int CONDITION_END = 3;
    static final int CONDITION_OUTER = 4;
    Table filterTable;
    private String tableAlias;
    Index filterIndex;
    private Object[] emptyData;
    boolean[] usedColumns;
    private Expression eStart;
    private Expression eEnd;
    Expression eAnd;
    boolean isOuterJoin;
    boolean isAssigned;
    boolean isMultiFindFirst;
    Expression[] findFirstExpressions;
    private RowIterator it;
    Object[] currentData;
    Row currentRow;
    Object[] currentJoinData;
    boolean nonJoinIsNull;
    boolean isCurrentOuter;

    TableFilter(Table table, String string, boolean bl) {
        this.filterTable = table;
        this.tableAlias = string == null ? table.getName().name : string;
        this.isOuterJoin = bl;
        this.emptyData = this.filterTable.getEmptyRowData();
        this.usedColumns = this.filterTable.getNewColumnCheckList();
    }

    String getName() {
        return this.tableAlias;
    }

    Table getTable() {
        return this.filterTable;
    }

    static int getConditionType(Expression expression) {
        int n = expression.getType();
        switch (n) {
            case 26: 
            case 27: {
                return 0;
            }
            case 30: {
                return expression.isQueryCorrelated ? -1 : 0;
            }
            case 21: 
            case 34: {
                return 1;
            }
            case 22: 
            case 23: {
                return 2;
            }
            case 24: 
            case 25: {
                return 3;
            }
        }
        return -1;
    }

    void setConditions(Session session, Expression expression) throws HsqlException {
        this.setCondition(session, expression);
        if (this.filterIndex == null) {
            this.filterIndex = this.filterTable.getPrimaryIndex();
        }
        if (this.filterIndex.getVisibleColumns() == 1 || this.eStart == null || this.eAnd == null || this.eStart.exprType != 21) {
            return;
        }
        boolean[] blArray = this.filterTable.getNewColumnCheckList();
        Expression[] expressionArray = new Expression[blArray.length];
        int n = this.eStart.getArg().getColumnNr();
        blArray[n] = true;
        expressionArray[n] = this.eStart.getArg2();
        this.eAnd.getEquiJoinColumns(this, blArray, expressionArray);
        if (ArrayUtil.containsAllTrueElements(blArray, this.filterIndex.colCheck)) {
            this.isMultiFindFirst = true;
            this.findFirstExpressions = expressionArray;
            this.currentJoinData = this.filterTable.getEmptyRowData();
        }
    }

    private void setCondition(Session session, Expression expression) throws HsqlException {
        int n = expression.getType();
        Expression expression2 = expression.getArg();
        Expression expression3 = expression.getArg2();
        this.isAssigned = true;
        if (n == 28) {
            this.setCondition(session, expression2);
            this.setCondition(session, expression3);
            return;
        }
        if (n == 29 && this.isOuterJoin && expression.isInJoin && expression.outerFilter == this) {
            this.addAndCondition(expression);
            expression.setTrue();
            return;
        }
        int n2 = TableFilter.getConditionType(expression);
        if (n2 == -1) {
            return;
        }
        if (expression2.getFilter() == this && expression3.getFilter() == this) {
            n2 = 0;
        } else if (expression2.getFilter() == this) {
            if (!expression.isInJoin && this.isOuterJoin) {
                return;
            }
        } else {
            if (expression3.getFilter() == this && n2 != 0) {
                expression.swapCondition();
                this.setCondition(session, expression);
                return;
            }
            if (expression2.outerFilter == this) {
                n2 = 4;
            } else {
                return;
            }
        }
        if (!expression3.isResolved()) {
            return;
        }
        if (expression2.outerFilter != null && expression2.outerFilter != this) {
            return;
        }
        if (n2 == 0) {
            this.addAndCondition(expression);
            return;
        }
        if (n2 == 4) {
            this.addAndCondition(expression);
            return;
        }
        int n3 = expression2.getColumnNr();
        Index index = this.filterTable.getIndexForColumn(session, n3);
        if (index == null || this.filterIndex != index && this.filterIndex != null) {
            this.addAndCondition(expression);
            return;
        }
        this.filterIndex = index;
        switch (n2) {
            case 1: {
                if (this.eStart != null || this.eEnd != null) {
                    this.addAndCondition(expression);
                    return;
                }
                this.eEnd = this.eStart = new Expression(expression);
                break;
            }
            case 2: {
                if (this.eStart != null) {
                    this.addAndCondition(expression);
                    return;
                }
                this.eStart = new Expression(expression);
                break;
            }
            case 3: {
                if (this.eEnd != null) {
                    this.addAndCondition(expression);
                    return;
                }
                this.eEnd = new Expression(expression);
            }
        }
        expression.setTrue();
    }

    boolean findFirst(Session session) throws HsqlException {
        block10: {
            int n;
            this.nonJoinIsNull = false;
            this.isCurrentOuter = false;
            if (this.filterIndex == null) {
                this.filterIndex = this.filterTable.getPrimaryIndex();
            }
            if (this.isMultiFindFirst) {
                boolean bl = true;
                int[] nArray = this.filterTable.getColumnTypes();
                n = 0;
                while (n < this.findFirstExpressions.length) {
                    Expression expression = this.findFirstExpressions[n];
                    if (expression != null) {
                        Object object = expression.getValue(session);
                        if (Column.compareToTypeRange(object, nArray[n]) != 0) {
                            bl = false;
                            break;
                        }
                        object = Column.convertObject(object, nArray[n]);
                        this.currentJoinData[n] = expression.getValue(session, nArray[n]);
                    }
                    ++n;
                }
                RowIterator rowIterator = this.it = bl ? this.filterIndex.findFirstRow(session, this.currentJoinData) : this.filterIndex.emptyIterator();
                if (!this.it.hasNext()) {
                    ArrayUtil.clearArray(76, this.currentJoinData, 0, this.currentJoinData.length);
                }
            } else if (this.eStart == null) {
                this.it = this.eEnd == null ? this.filterIndex.firstRow(session) : this.filterIndex.findFirstRowNotNull(session);
            } else {
                Object object = this.eStart.getArg2().getValue(session);
                int n2 = this.eStart.getArg2().getDataType();
                n = this.eStart.getArg().getDataType();
                this.it = TableFilter.getFirstIterator(session, this.eStart.getType(), object, n2, this.filterIndex, n);
            }
            do {
                this.currentRow = this.it.next();
                if (this.currentRow == null) break block10;
                this.currentData = this.currentRow.getData();
                if (this.eEnd != null && !this.eEnd.testCondition(session)) break block10;
            } while (this.eAnd != null && !this.eAnd.testCondition(session));
            return true;
        }
        this.currentRow = null;
        this.currentData = this.emptyData;
        return false;
    }

    static RowIterator getFirstIterator(Session session, int n, Object object, int n2, Index index, int n3) throws HsqlException {
        RowIterator rowIterator;
        int n4 = 0;
        if (n3 != n2) {
            n4 = Column.compareToTypeRange(object, n3);
        }
        if (n4 == 0) {
            object = Column.convertObject(object, n3);
            rowIterator = index.findFirstRow(session, object, n);
        } else {
            switch (n) {
                case 22: 
                case 23: {
                    if (n4 < 0) {
                        rowIterator = index.findFirstRowNotNull(session);
                        break;
                    }
                }
                default: {
                    rowIterator = index.emptyIterator();
                }
            }
        }
        return rowIterator;
    }

    boolean next(Session session) throws HsqlException {
        boolean bl;
        block2: {
            bl = false;
            this.nonJoinIsNull = false;
            this.isCurrentOuter = false;
            do {
                this.currentRow = this.it.next();
                if (this.currentRow == null) break block2;
                this.currentData = this.currentRow.getData();
                if (this.eEnd != null && !this.eEnd.testCondition(session)) break block2;
            } while (this.eAnd != null && !this.eAnd.testCondition(session));
            bl = true;
        }
        if (bl) {
            return true;
        }
        this.currentRow = null;
        this.currentData = this.emptyData;
        return false;
    }

    boolean nextOuter(Session session) throws HsqlException {
        this.nonJoinIsNull = false;
        this.isCurrentOuter = true;
        this.currentData = this.emptyData;
        this.currentRow = null;
        return this.eAnd == null || this.eAnd.getFilter() != this && this.eAnd.isInJoin || this.eAnd.testCondition(session);
    }

    private void addAndCondition(Expression expression) {
        Expression expression2;
        Expression expression3 = new Expression(expression);
        this.eAnd = this.eAnd == null ? expression3 : (expression2 = new Expression(28, this.eAnd, expression3));
        expression.setTrue();
    }

    void setAsCheckFilter() {
        this.filterIndex = null;
    }

    public String describe(Session session) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        Index index = this.filterIndex;
        Index index2 = this.filterTable.getPrimaryIndex();
        int[] nArray = this.filterTable.getPrimaryKey();
        boolean bl2 = false;
        boolean bl3 = bl = this.eStart == null && this.eEnd == null;
        if (index == null) {
            index = index2;
        }
        if (index == index2 && nArray.length == 0) {
            bl2 = true;
            bl = true;
        }
        stringBuffer.append(super.toString()).append('\n');
        stringBuffer.append("table=[").append(this.filterTable.getName().name).append("]\n");
        stringBuffer.append("alias=[").append(this.tableAlias).append("]\n");
        stringBuffer.append("access=[").append(bl ? "FULL SCAN" : "INDEX PRED").append("]\n");
        stringBuffer.append("index=[");
        stringBuffer.append(index == null ? "NONE" : (index.getName() == null ? "UNNAMED" : index.getName().name));
        stringBuffer.append(bl2 ? "[HIDDEN]]\n" : "]\n");
        stringBuffer.append("isOuterJoin=[").append(this.isOuterJoin).append("]\n");
        String string = this.eStart == null ? "null" : this.eStart.describe(session);
        stringBuffer.append("eStart=[").append(string).append("]\n");
        string = this.eEnd == null ? "null" : this.eEnd.describe(session);
        stringBuffer.append("eEnd=[").append(string).append("]\n");
        string = this.eAnd == null ? "null" : this.eAnd.describe(session);
        stringBuffer.append("eAnd=[").append(string).append("]");
        return stringBuffer.toString();
    }
}

