/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.Transaction;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongKeyIntValueHashMap;

public class TransactionManager {
    LongKeyIntValueHashMap rowSessionMap;
    boolean reWriteProtect;
    Database database;

    TransactionManager(Database database) {
        this.database = database;
        this.rowSessionMap = new LongKeyIntValueHashMap(true);
    }

    public void setReWriteProtection(boolean bl) {
        this.reWriteProtect = bl;
    }

    void checkDelete(Session session, Row row) throws HsqlException {
    }

    void checkDelete(Session session, HashMappedList hashMappedList) throws HsqlException {
        if (!this.reWriteProtect) {
            return;
        }
        int n = session.getId();
        int n2 = 0;
        int n3 = hashMappedList.size();
        while (n2 < n3) {
            Row row = (Row)hashMappedList.getKey(n2);
            long l = row.getId();
            if (this.rowSessionMap.get(l, n) != n) {
                throw Trace.error(117, 122);
            }
            ++n2;
        }
    }

    void checkDelete(Session session, HsqlArrayList hsqlArrayList) throws HsqlException {
        if (!this.reWriteProtect) {
            return;
        }
        int n = session.getId();
        int n2 = 0;
        int n3 = hsqlArrayList.size();
        while (n2 < n3) {
            Row row = (Row)hsqlArrayList.get(n2);
            long l = row.getId();
            if (this.rowSessionMap.get(l, n) != n) {
                throw Trace.error(117, 122);
            }
            ++n2;
        }
    }

    void commit(Session session) {
        Object[] objectArray = session.transactionList.getArray();
        int n = session.transactionList.size();
        int n2 = 0;
        while (n2 < n) {
            Transaction transaction = (Transaction)objectArray[n2];
            long l = transaction.row.getId();
            transaction.commit(session);
            this.rowSessionMap.remove(l);
            ++n2;
        }
        session.transactionList.clear();
        session.savepoints.clear();
    }

    synchronized void rollback(Session session) {
        this.rollbackTransactions(session, 0, false);
        session.savepoints.clear();
    }

    void rollbackSavepoint(Session session, String string) throws HsqlException {
        int n = session.savepoints.getIndex(string);
        if (n < 1) {
            throw Trace.error(44, string);
        }
        Integer n2 = (Integer)session.savepoints.get(n);
        int n3 = n2;
        this.rollbackTransactions(session, n3, false);
        while (session.savepoints.size() > n) {
            session.savepoints.remove(session.savepoints.size() - 1);
        }
    }

    void rollbackTransactions(Session session, int n, boolean bl) {
        Object[] objectArray = session.transactionList.getArray();
        int n2 = session.transactionList.size();
        int n3 = n2 - 1;
        while (n3 >= n) {
            Transaction transaction = (Transaction)objectArray[n3];
            transaction.rollback(session, false);
            --n3;
        }
        int n4 = n;
        while (n4 < n2) {
            Transaction transaction = (Transaction)objectArray[n4];
            long l = transaction.row.getId();
            this.rowSessionMap.remove(l);
            ++n4;
        }
        session.transactionList.setSize(n);
    }

    void addTransaction(Session session, Transaction transaction) {
        if (this.reWriteProtect) {
            this.rowSessionMap.put(transaction.row.getId(), session.getId());
        }
    }

    /*
     * Unable to fully structure code
     */
    Transaction[] getTransactionList() {
        var1_1 = this.database.sessionManager.getAllSessions();
        var2_2 = new int[var1_1.length];
        var4_3 = 0;
        var5_4 = 0;
        var6_5 = 0;
        while (var6_5 < var1_1.length) {
            var5_4 += var1_1[var6_5].getTransactionSize();
            ++var6_5;
        }
        var3_7 = new Transaction[var5_4];
        block1: while (true) {
            var5_4 = 0;
            var6_6 = 0x7FFFFFFFFFFFFFFFL;
            var8_8 = 0;
            var9_9 = 0;
            while (var9_9 < var1_1.length) {
                var10_11 = var1_1[var9_9].getTransactionSize();
                if (var2_2[var9_9] < var10_11) {
                    var11_12 = (Transaction)var1_1[var9_9].transactionList.get(var2_2[var9_9]);
                    if (var11_12.SCN < var6_6) {
                        var6_6 = var11_12.SCN;
                        var8_8 = var9_9;
                    }
                    var5_4 = 1;
                }
                ++var9_9;
            }
            if (var5_4 == 0) break;
            var10_10 = var1_1[var8_8].transactionList;
            while (true) {
                if (var2_2[var8_8] >= var10_10.size()) continue block1;
                var11_12 = (Transaction)var10_10.get(var2_2[var8_8]);
                if (var11_12.SCN == var6_6 + 1L) {
                    ++var6_6;
                }
                if (var11_12.SCN == var6_6) ** break;
                continue block1;
                var3_7[var4_3++] = var11_12;
                v0 = var8_8;
                var2_2[v0] = var2_2[v0] + 1;
            }
            break;
        }
        return var3_7;
    }

    public DoubleIntIndex getTransactionIDList() {
        Session[] sessionArray = this.database.sessionManager.getAllSessions();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(10, false);
        doubleIntIndex.setKeysSearchTarget();
        int n = 0;
        while (n < sessionArray.length) {
            HsqlArrayList hsqlArrayList = sessionArray[n].transactionList;
            int n2 = 0;
            int n3 = hsqlArrayList.size();
            while (n2 < n3) {
                Transaction transaction = (Transaction)hsqlArrayList.get(n2);
                if (transaction.tTable.getTableType() == 4) {
                    doubleIntIndex.addUnique(transaction.row.getPos(), 0);
                }
                ++n2;
            }
            ++n;
        }
        return doubleIntIndex;
    }

    public void convertTransactionIDs(DoubleIntIndex doubleIntIndex) {
        Session[] sessionArray = this.database.sessionManager.getAllSessions();
        int n = 0;
        while (n < sessionArray.length) {
            HsqlArrayList hsqlArrayList = sessionArray[n].transactionList;
            int n2 = 0;
            int n3 = hsqlArrayList.size();
            while (n2 < n3) {
                Transaction transaction = (Transaction)hsqlArrayList.get(n2);
                if (transaction.tTable.getTableType() == 4) {
                    int n4 = doubleIntIndex.lookupFirstEqual(transaction.row.getPos());
                    transaction.row.setPos(n4);
                }
                ++n2;
            }
            ++n;
        }
    }
}

