/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.GrantConstants;
import org.hsqldb.Grantee;
import org.hsqldb.GranteeManager;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.User;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;

class UserManager
implements GrantConstants {
    User sysUser = null;
    private HashMappedList uUser;
    private GranteeManager granteeManager;

    UserManager(Database database) throws HsqlException {
        this.granteeManager = database.getGranteeManager();
        this.uUser = new HashMappedList();
        this.createUser("PUBLIC", null);
        this.sysUser = this.createUser("_SYSTEM", null);
        this.sysUser.getGrantee().setAdminDirect();
    }

    User createUser(String string, String string2) throws HsqlException {
        if (string == null) {
            Trace.doAssert(false, Trace.getMessage(236));
        }
        Grantee grantee = this.granteeManager.addGrantee(string);
        User user = new User(string, string2, grantee);
        if ("_SYSTEM".equals(string)) {
            return user;
        }
        Trace.check(this.uUser.add(string, user), 36, string);
        return user;
    }

    void dropUser(String string) throws HsqlException {
        boolean bl = GranteeManager.isReserved(string);
        Trace.check(!bl, 231, string);
        boolean bl2 = this.granteeManager.removeGrantee(string);
        Trace.check(bl2, 232, string);
        User user = (User)this.uUser.remove(string);
        Trace.check(user != null, 37, string);
    }

    User getUser(String string, String string2) throws HsqlException {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string.equals("PUBLIC")) {
            throw Trace.error(33);
        }
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        User user = this.get(string);
        user.checkPassword(string2);
        return user;
    }

    HashMappedList getUsers() {
        return this.uUser;
    }

    boolean exists(String string) {
        return this.uUser.get(string) != null;
    }

    User get(String string) throws HsqlException {
        User user = (User)this.uUser.get(string);
        if (user == null) {
            throw Trace.error(37, string);
        }
        return user;
    }

    HsqlArrayList listVisibleUsers(Session session, boolean bl) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        boolean bl2 = session.isAdmin();
        String string = session.getUsername();
        if (this.uUser == null || this.uUser.size() == 0) {
            return hsqlArrayList;
        }
        int n = 0;
        while (n < this.uUser.size()) {
            User user = (User)this.uUser.get(n);
            if (user != null) {
                String string2 = user.getName();
                if ("PUBLIC".equals(string2)) {
                    if (bl) {
                        hsqlArrayList.add(user);
                    }
                } else if (bl2) {
                    hsqlArrayList.add(user);
                } else if (string.equals(string2)) {
                    hsqlArrayList.add(user);
                }
            }
            ++n;
        }
        return hsqlArrayList;
    }

    static String[] getRightsArray(int n) {
        return GranteeManager.getRightsArray(n);
    }

    void removeDbObject(Object object) {
        this.granteeManager.removeDbObject(object);
    }

    User getSysUser() throws HsqlException {
        if (this.sysUser == null) {
            Trace.doAssert(false, Trace.getMessage(233) + ": " + "_SYSTEM");
        }
        return this.sysUser;
    }
}

