/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HashMap;

public class HashMappedList
extends HashMap {
    public HashMappedList() {
        this(16, 0.75f);
    }

    public HashMappedList(int n) throws IllegalArgumentException {
        this(n, 0.75f);
    }

    public HashMappedList(int n, float f) throws IllegalArgumentException {
        super(n, f);
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return this.objectValueTable[n];
    }

    public Object remove(Object object) {
        int n = this.getLookup(object, object.hashCode());
        if (n < 0) {
            return null;
        }
        Object object2 = super.remove(object);
        this.removeRow(n);
        return object2;
    }

    public Object remove(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return this.remove(this.objectKeyTable[n]);
    }

    public boolean add(Object object, Object object2) {
        if (this.keySet().contains(object)) {
            return false;
        }
        super.put(object, object2);
        return true;
    }

    public Object put(Object object, Object object2) {
        return super.put(object, object2);
    }

    public Object set(int n, Object object) throws IndexOutOfBoundsException {
        this.checkRange(n);
        Object object2 = this.objectKeyTable[n];
        this.objectKeyTable[n] = object;
        return object2;
    }

    public boolean insert(int n, Object object, Object object2) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.keySet().contains(object)) {
            return false;
        }
        if (n == this.size()) {
            return this.add(object, object2);
        }
        HashMappedList hashMappedList = new HashMappedList(this.size());
        int n2 = n;
        while (n2 < this.size()) {
            hashMappedList.add(this.getKey(n2), this.get(n2));
            ++n2;
        }
        int n3 = this.size() - 1;
        while (n3 >= n) {
            this.remove(n3);
            --n3;
        }
        int n4 = 0;
        while (n4 < hashMappedList.size()) {
            this.add(hashMappedList.getKey(n4), hashMappedList.get(n4));
            ++n4;
        }
        return true;
    }

    public boolean set(int n, Object object, Object object2) throws IndexOutOfBoundsException {
        this.checkRange(n);
        if (this.keySet().contains(object) && this.getIndex(object) != n) {
            return false;
        }
        super.remove(this.objectKeyTable[n]);
        super.put(object, object2);
        return true;
    }

    public boolean setKey(int n, Object object) throws IndexOutOfBoundsException {
        this.checkRange(n);
        Object object2 = this.objectValueTable[n];
        return this.set(n, object, object2);
    }

    public Object getKey(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return this.objectKeyTable[n];
    }

    public int getIndex(Object object) {
        return this.getLookup(object, object.hashCode());
    }

    private void checkRange(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

