/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.store.BaseHashMap;

public class HashSet
extends BaseHashMap
implements Set {
    public HashSet() {
        this(16, 0.75f);
    }

    public HashSet(int n) throws IllegalArgumentException {
        this(n, 0.75f);
    }

    public HashSet(int n, float f) throws IllegalArgumentException {
        super(n, f, 3, 0, false);
    }

    public boolean contains(Object object) {
        return super.containsKey(object);
    }

    public Object get(Object object) {
        int n = this.getLookup(object, object.hashCode());
        if (n < 0) {
            return null;
        }
        return this.objectKeyTable[n];
    }

    public boolean add(Object object) {
        int n = this.size();
        super.addOrRemove(0L, 0L, object, null, false);
        return n != this.size();
    }

    public boolean addAll(Collection collection) {
        int n = this.size();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return n != this.size();
    }

    public boolean addAll(Object[] objectArray) {
        boolean bl = false;
        int n = 0;
        while (n < objectArray.length) {
            if (this.add(objectArray[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public boolean remove(Object object) {
        int n = this.size();
        super.removeObject(object);
        return n != this.size();
    }

    public Object[] toArray(Object[] objectArray) {
        if (objectArray == null || objectArray.length < this.size()) {
            objectArray = new Object[this.size()];
        }
        Iterator iterator = this.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = iterator.next();
            ++n;
        }
        return objectArray;
    }

    public Iterator iterator() {
        return new BaseHashMap.BaseHashIterator(this, true);
    }

    public String toString() {
        Iterator iterator = this.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            } else {
                stringBuffer.append('[');
            }
            stringBuffer.append(iterator.next());
        }
        return stringBuffer.toString() + ']';
    }
}

