/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.DoubleIntIndex;

public class DataFileBlockManager {
    private DoubleIntIndex lookup;
    private final int capacity;
    private int midSize;
    private final int scale;
    private long releaseCount;
    private long requestCount;
    private long requestSize;
    long lostFreeBlockSize;

    public DataFileBlockManager(int n, int n2, long l) {
        this.lookup = new DoubleIntIndex(n, true);
        this.lookup.setValuesSearchTarget();
        this.capacity = n;
        this.scale = n2;
        this.lostFreeBlockSize = l;
        this.midSize = 128;
    }

    void add(int n, int n2) {
        ++this.releaseCount;
        if (this.lookup.size() == this.capacity) {
            this.resetList();
        }
        this.lookup.add(n, n2);
    }

    int get(int n) {
        if (this.lookup.size() == 0) {
            return -1;
        }
        int n2 = this.lookup.findFirstGreaterEqualKeyIndex(n);
        if (n2 == -1) {
            return -1;
        }
        ++this.requestCount;
        this.requestSize += (long)n;
        int n3 = this.lookup.getValue(n2);
        int n4 = n3 - n;
        int n5 = this.lookup.getKey(n2);
        this.lookup.remove(n2);
        if (n4 >= this.midSize) {
            int n6 = n5 + n / this.scale;
            this.lookup.add(n6, n4);
        } else {
            this.lostFreeBlockSize += (long)n4;
        }
        return n5;
    }

    int size() {
        return this.lookup.size();
    }

    long getLostBlocksSize() {
        return this.lostFreeBlockSize;
    }

    private void resetList() {
        int n;
        if (this.requestCount != 0L) {
            this.midSize = (int)(this.requestSize / this.requestCount);
        }
        if ((n = this.lookup.findFirstGreaterEqualSlotIndex(this.midSize)) < this.lookup.size() / 4) {
            n = this.lookup.size() / 4;
        }
        this.removeBlocks(n);
    }

    private void removeBlocks(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.lostFreeBlockSize += (long)this.lookup.getValue(n2);
            ++n2;
        }
        this.lookup.removeRange(0, n);
    }

    private void checkIntegrity() throws NullPointerException {
    }
}

