/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.util.ConnectionSetting;

class ConnectionDialogCommon {
    private static String[][] connTypes;
    private static final String[][] sJDBCTypes;
    private static final String fileName = "hsqlprefs.dat";
    private static File recentSettings;
    static String emptySettingName;
    private static String homedir;
    static /* synthetic */ Class class$java$lang$String;

    ConnectionDialogCommon() {
    }

    static String[][] getTypes() {
        return sJDBCTypes;
    }

    static Hashtable loadRecentConnectionSettings() throws IOException {
        Hashtable<String, ConnectionSetting> hashtable = new Hashtable<String, ConnectionSetting>();
        try {
            if (recentSettings == null) {
                ConnectionDialogCommon.setHomeDir();
                if (homedir == null) {
                    return hashtable;
                }
                recentSettings = new File(homedir, fileName);
                if (!recentSettings.exists()) {
                    JavaSystem.createNewFile(recentSettings);
                    return hashtable;
                }
            }
        }
        catch (Throwable throwable) {
            return hashtable;
        }
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(recentSettings);
                objectInputStream = new ObjectInputStream(fileInputStream);
                hashtable.clear();
                while (true) {
                    ConnectionSetting connectionSetting;
                    if (emptySettingName.equals((connectionSetting = (ConnectionSetting)objectInputStream.readObject()).getName())) {
                        continue;
                    }
                    hashtable.put(connectionSetting.getName(), connectionSetting);
                }
            }
            catch (EOFException eOFException) {}
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("Unrecognized class type " + classNotFoundException.getMessage());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Unrecognized class type " + classCastException.getMessage());
            }
            finally {
                Object var8_6 = null;
                if (objectInputStream != null) {
                    objectInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            throw throwable;
        }
        return hashtable;
    }

    static void addToRecentConnectionSettings(Hashtable hashtable, ConnectionSetting connectionSetting) throws IOException {
        hashtable.put(connectionSetting.getName(), connectionSetting);
        ConnectionDialogCommon.storeRecentConnectionSettings(hashtable);
    }

    private static void storeRecentConnectionSettings(Hashtable hashtable) {
        try {
            if (recentSettings == null) {
                ConnectionDialogCommon.setHomeDir();
                if (homedir == null) {
                    return;
                }
                recentSettings = new File(homedir, fileName);
                if (!recentSettings.exists()) {
                    // empty if block
                }
            }
            if (hashtable == null || hashtable.size() == 0) {
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(recentSettings);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                objectOutputStream.writeObject(enumeration.nextElement());
            }
            objectOutputStream.flush();
            objectOutputStream.close();
            fileOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void deleteRecentConnectionSettings() {
        try {
            if (recentSettings == null) {
                ConnectionDialogCommon.setHomeDir();
                if (homedir == null) {
                    return;
                }
                recentSettings = new File(homedir, fileName);
            }
            if (!recentSettings.exists()) {
                recentSettings = null;
                return;
            }
            recentSettings.delete();
            recentSettings = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setHomeDir() {
        if (homedir == null) {
            try {
                Class<?> clazz = Class.forName("sun.security.action.GetPropertyAction");
                Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ConnectionDialogCommon.class$("java.lang.String")) : class$java$lang$String);
                PrivilegedAction privilegedAction = (PrivilegedAction)constructor.newInstance("user.home");
                homedir = (String)AccessController.doPrivileged(privilegedAction);
            }
            catch (Exception exception) {
                System.err.println("No access to home directory.  Continuing without...");
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        sJDBCTypes = new String[][]{{"HSQL Database Engine In-Memory", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:mem:."}, {"HSQL Database Engine Standalone", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:file:\u00abdatabase/path?\u00bb"}, {"HSQL Database Engine Server", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:hsql://localhost/"}, {"HSQL Database Engine WebServer", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:http://\u00abhostname/?\u00bb"}, {"JDBC-ODBC Bridge from Sun", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:\u00abdatabase?\u00bb"}, {"Cloudscape RMI", "RmiJdbc.RJDriver", "jdbc:rmi://\u00abhost?\u00bb:1099/jdbc:cloudscape:\u00abdatabase?\u00bb;create=true"}, {"IBM DB2", "COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:\u00abdatabase?\u00bb"}, {"IBM DB2 (thin)", "COM.ibm.db2.jdbc.net.DB2Driver", "jdbc:db2://\u00abhost?\u00bb:6789/\u00abdatabase?\u00bb"}, {"Informix", "com.informix.jdbc.IfxDriver", "jdbc:informix-sqli://\u00abhost?\u00bb:1533/\u00abdatabase?\u00bb:INFORMIXSERVER=\u00abserver?\u00bb"}, {"InstantDb", "jdbc.idbDriver", "jdbc:idb:\u00abdatabase?\u00bb.prp"}, {"MySQL Connector/J", "com.mysql.jdbc.Driver", "jdbc:mysql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"MM.MySQL", "org.gjt.mm.mysql.Driver", "jdbc:mysql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@\u00abdatabase?\u00bb"}, {"Oracle (thin)", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@\u00abhost?\u00bb:1521:\u00abdatabase?\u00bb"}, {"PointBase", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"PostgreSQL", "org.postgresql.Driver", "jdbc:postgresql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}, {"PostgreSQL v6.5", "postgresql.Driver", "jdbc:postgresql://\u00abhost?\u00bb/\u00abdatabase?\u00bb"}};
        recentSettings = null;
        emptySettingName = "Recent settings...";
        homedir = null;
    }
}

