/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Properties;
import org.hsqldb.lib.java.JavaSystem;

public class ScriptTool {
    private static Properties pProperties = new Properties();
    private Connection cConn;
    private Statement sStatement;
    private boolean BATCH = true;
    private String EKW = new String("go");
    private boolean EOF = false;
    private int ln = 0;

    public static void main(String[] stringArray) {
        Object object;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if (((String)object).equals("-?")) {
                ScriptTool.printHelp();
                System.exit(0);
            }
            ++n;
        }
        object = new ScriptTool();
        ((ScriptTool)object).execute(stringArray);
        System.exit(0);
    }

    public void execute(String[] stringArray) {
        Object object;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if (((String)object).charAt(0) == '-') {
                ((Hashtable)pProperties).put(((String)object).substring(1), stringArray[n + 1]);
                ++n;
            }
            ++n;
        }
        this.ln = 0;
        this.EOF = false;
        object = null;
        Properties properties = pProperties;
        String string = properties.getProperty("driver", "org.hsqldb.jdbcDriver");
        String string2 = properties.getProperty("url", "jdbc:hsqldb:");
        String string3 = properties.getProperty("database", "test");
        String string4 = properties.getProperty("user", "sa");
        String string5 = properties.getProperty("password", "");
        String string6 = properties.getProperty("script", "st.sql");
        boolean bl = properties.getProperty("log", "false").equalsIgnoreCase("true");
        this.BATCH = properties.getProperty("batch", "true").equalsIgnoreCase("true");
        try {
            if (bl) {
                this.trace("driver   = " + string);
                this.trace("url      = " + string2);
                this.trace("database = " + string3);
                this.trace("user     = " + string4);
                this.trace("password = " + string5);
                this.trace("script   = " + string6);
                this.trace("log      = " + bl);
                this.trace("batch    = " + this.BATCH);
                JavaSystem.setLogToSystem(true);
            }
            Class.forName(string).newInstance();
            this.cConn = DriverManager.getConnection(string2 + string3, string4, string5);
            object = new BufferedReader(new FileReader(string6));
        }
        catch (Exception exception) {
            System.out.println("ScriptTool.init error: " + exception.getMessage());
            exception.printStackTrace();
        }
        try {
            String string7;
            this.sStatement = this.cConn.createStatement();
            while ((string7 = this.fileToString((BufferedReader)object)) != null) {
                if (string7.length() == 1) continue;
                if (bl) {
                    this.trace("SQL (" + this.ln + ") : " + string7.substring(0, string7.length() - 2));
                }
                this.sStatement.execute(string7);
                ResultSet resultSet = this.sStatement.getResultSet();
                int n2 = this.sStatement.getUpdateCount();
                if (n2 == -1) {
                    this.trace(this.toString(resultSet));
                    continue;
                }
                this.trace("update count " + n2);
            }
        }
        catch (SQLException sQLException) {
            System.out.println("SQL Error at line " + this.ln + ": " + sQLException);
        }
        try {
            this.cConn.close();
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String toString(ResultSet resultSet) {
        try {
            if (resultSet == null) {
                return "No Result";
            }
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 1;
            while (n2 <= n) {
                stringBuffer = stringBuffer.append(resultSetMetaData.getColumnLabel(n2) + "\t");
                ++n2;
            }
            stringBuffer = stringBuffer.append("\n");
            while (resultSet.next()) {
                int n3 = 1;
                while (n3 <= n) {
                    stringBuffer = stringBuffer.append(resultSet.getString(n3) + "\t");
                    if (resultSet.wasNull()) {
                        stringBuffer = stringBuffer.append("(null)\t");
                    }
                    ++n3;
                }
                stringBuffer = stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    private String fileToString(BufferedReader bufferedReader) {
        if (this.EOF) {
            return null;
        }
        this.EOF = true;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                ++this.ln;
                if (this.BATCH) {
                    if (string.startsWith("print ")) {
                        this.trace("\n" + string.substring(5));
                        continue;
                    }
                    if (string.equalsIgnoreCase(this.EKW)) {
                        this.EOF = false;
                        break;
                    }
                }
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
    }

    private void trace(String string) {
        System.out.println(string);
    }

    private static void printHelp() {
        System.out.println("Usage: java ScriptTool [-options]\nwhere options include:\n    -driver <classname>     name of the driver class\n    -url <name>             first part of the jdbc url\n    -database <name>        second part of the jdbc url\n    -user <name>            username used for connection\n    -password <name>        password for this user\n    -log <true/false>       write log to system out\n    -batch <true/false>     allow go/print pseudo statements\n    -script <script file>   reads from script file\n");
    }
}

